/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.server.rest.repr.FullPath;

public final class RepresentationType {
    private static final Map<Class<?>, Class<?>> boxed = new HashMap();
    private static final Map<String, RepresentationType> types;
    private static final Map<Class<?>, RepresentationType> extended;
    public static final RepresentationType GRAPHDB;
    public static final RepresentationType NODE;
    public static final RepresentationType RELATIONSHIP;
    public static final RepresentationType PATH;
    public static final RepresentationType FULL_PATH;
    public static final RepresentationType RELATIONSHIP_TYPE;
    public static final RepresentationType PROPERTIES;
    public static final RepresentationType INDEX;
    public static final RepresentationType NODE_INDEX_ROOT;
    public static final RepresentationType RELATIONSHIP_INDEX_ROOT;
    public static final RepresentationType INDEX_DEFINITION;
    public static final RepresentationType CONSTRAINT_DEFINITION;
    public static final RepresentationType PLUGINS;
    public static final RepresentationType PLUGIN;
    public static final RepresentationType PLUGIN_DESCRIPTION;
    public static final RepresentationType SERVER_PLUGIN_DESCRIPTION;
    public static final RepresentationType PLUGIN_PARAMETER;
    public static final RepresentationType URI;
    public static final RepresentationType TEMPLATE;
    public static final RepresentationType STRING;
    public static final RepresentationType BYTE;
    public static final RepresentationType CHAR;
    public static final RepresentationType SHORT;
    public static final RepresentationType INTEGER;
    public static final RepresentationType LONG;
    public static final RepresentationType FLOAT;
    public static final RepresentationType DOUBLE;
    public static final RepresentationType BOOLEAN;
    public static final RepresentationType NOTHING;
    public static final RepresentationType EXCEPTION;
    public static final RepresentationType MAP;
    public static final RepresentationType NULL;
    final String valueName;
    final String listName;
    final Class<?> extend;

    private RepresentationType(String valueName, String listName) {
        this(valueName, listName, null);
    }

    private RepresentationType(String valueName, String listName, Class<?> extend) {
        this.valueName = valueName;
        this.listName = listName;
        this.extend = extend;
        if (valueName != null) {
            types.put(valueName.replace("-", ""), this);
        }
        if (extend != null) {
            extended.put(extend, this);
            if (extend.isPrimitive()) {
                extended.put(boxed.get(extend), this);
            }
        }
    }

    RepresentationType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("type may not be null");
        }
        this.valueName = type;
        this.listName = type + "s";
        this.extend = null;
    }

    public String toString() {
        return this.valueName;
    }

    static RepresentationType valueOf(Class<? extends Number> type) {
        return types.get(type.getSimpleName().toLowerCase());
    }

    public int hashCode() {
        if (this.valueName == null) {
            return this.listName.hashCode();
        }
        return this.valueName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RepresentationType) {
            RepresentationType that = (RepresentationType)obj;
            if (this.valueName != null) {
                if (this.valueName.equals(that.valueName)) {
                    if (this.listName != null) {
                        return this.listName.equals(that.listName);
                    }
                    return that.listName == null;
                }
            } else if (this.listName != null) {
                return that.valueName == null && this.listName.equals(that.listName);
            }
        }
        return false;
    }

    static RepresentationType extended(Class<?> extend) {
        return extended.get(extend);
    }

    static {
        boxed.put(Byte.TYPE, Byte.class);
        boxed.put(Character.TYPE, Character.class);
        boxed.put(Short.TYPE, Short.class);
        boxed.put(Integer.TYPE, Integer.class);
        boxed.put(Long.TYPE, Long.class);
        boxed.put(Float.TYPE, Float.class);
        boxed.put(Double.TYPE, Double.class);
        boxed.put(Boolean.TYPE, Boolean.class);
        types = new HashMap<String, RepresentationType>();
        extended = new HashMap();
        GRAPHDB = new RepresentationType("graphdb", null, GraphDatabaseService.class);
        NODE = new RepresentationType("node", "nodes", Node.class);
        RELATIONSHIP = new RepresentationType("relationship", "relationships", Relationship.class);
        PATH = new RepresentationType("path", "paths", Path.class);
        FULL_PATH = new RepresentationType("full-path", "full-paths", FullPath.class);
        RELATIONSHIP_TYPE = new RepresentationType("relationship-type", "relationship-types", RelationshipType.class);
        PROPERTIES = new RepresentationType("properties");
        INDEX = new RepresentationType("index");
        NODE_INDEX_ROOT = new RepresentationType("node-index");
        RELATIONSHIP_INDEX_ROOT = new RepresentationType("relationship-index");
        INDEX_DEFINITION = new RepresentationType("index-definition", "index-definitions", IndexDefinition.class);
        CONSTRAINT_DEFINITION = new RepresentationType("constraint-definition", "constraint-definitions", ConstraintDefinition.class);
        PLUGINS = new RepresentationType("plugins");
        PLUGIN = new RepresentationType("plugin");
        PLUGIN_DESCRIPTION = new RepresentationType("plugin-point");
        SERVER_PLUGIN_DESCRIPTION = new RepresentationType("server-plugin", null);
        PLUGIN_PARAMETER = new RepresentationType("plugin-parameter", "plugin-parameter-list");
        URI = new RepresentationType("uri", null);
        TEMPLATE = new RepresentationType("uri-template");
        STRING = new RepresentationType("string", "strings", String.class);
        BYTE = new RepresentationType("byte", "bytes", Byte.TYPE);
        CHAR = new RepresentationType("character", "characters", Character.TYPE);
        SHORT = new RepresentationType("short", "shorts", Short.TYPE);
        INTEGER = new RepresentationType("integer", "integers", Integer.TYPE);
        LONG = new RepresentationType("long", "longs", Long.TYPE);
        FLOAT = new RepresentationType("float", "floats", Float.TYPE);
        DOUBLE = new RepresentationType("double", "doubles", Double.TYPE);
        BOOLEAN = new RepresentationType("boolean", "booleans", Boolean.TYPE);
        NOTHING = new RepresentationType("void", null);
        EXCEPTION = new RepresentationType("exception");
        MAP = new RepresentationType("map", "maps", Map.class);
        NULL = new RepresentationType("null", "nulls", Object.class);
    }
}

