/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.annotate;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.ExpandModulesRequest;
import org.netbeans.lib.cvsclient.request.RootRequest;

public class RannotateCommand
extends BasicCommand {
    private final List modules = new LinkedList();
    private final List expandedModules = new LinkedList();
    private boolean useHeadIfNotFound;
    private String annotateByDate;
    private String annotateByRevision;
    private boolean headerAndDescOnly;

    public RannotateCommand() {
        this.resetCVSCommand();
    }

    public void setModule(String string) {
        this.modules.add(string);
    }

    public void clearModules() {
        this.modules.clear();
    }

    public void setModules(String[] stringArray) {
        this.clearModules();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.modules.add(string);
        }
    }

    public String[] getModules() {
        String[] stringArray = new String[this.modules.size()];
        stringArray = this.modules.toArray(stringArray);
        return stringArray;
    }

    private void processExistingModules(String string) {
        if (this.expandedModules.size() == 0) {
            return;
        }
        String[] stringArray = new String[this.expandedModules.size()];
        stringArray = this.expandedModules.toArray(stringArray);
        this.setModules(stringArray);
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        this.requests = new LinkedList();
        if (clientServices.isFirstCommand()) {
            this.requests.add(new RootRequest(clientServices.getRepository()));
        }
        Iterator iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.requests.add(new ArgumentRequest(string));
        }
        this.expandedModules.clear();
        this.requests.add(new DirectoryRequest(".", clientServices.getRepository()));
        this.requests.add(new ExpandModulesRequest());
        try {
            clientServices.processRequests(this.requests);
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
        this.requests.clear();
        this.postExpansionExecute(clientServices, eventManager);
    }

    public void moduleExpanded(ModuleExpansionEvent moduleExpansionEvent) {
        this.expandedModules.add(moduleExpansionEvent.getModule());
    }

    private void postExpansionExecute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        super.execute(clientServices, eventManager);
        if (!this.isRecursive()) {
            this.requests.add(1, new ArgumentRequest("-l"));
        }
        if (this.useHeadIfNotFound) {
            this.requests.add(1, new ArgumentRequest("-f"));
        }
        if (this.annotateByDate != null && this.annotateByDate.length() > 0) {
            this.requests.add(1, new ArgumentRequest("-D"));
            this.requests.add(2, new ArgumentRequest(this.getAnnotateByDate()));
        }
        if (this.annotateByRevision != null && this.annotateByRevision.length() > 0) {
            this.requests.add(1, new ArgumentRequest("-r"));
            this.requests.add(2, new ArgumentRequest(this.getAnnotateByRevision()));
        }
        Iterator iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.requests.add(new ArgumentRequest(string));
        }
        this.requests.add(new DirectoryRequest(".", clientServices.getRepository()));
        this.requests.add(CommandRequest.RANNOTATE);
        try {
            clientServices.processRequests(this.requests);
            this.requests.clear();
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("rannotate ");
        stringBuffer.append(this.getCVSArguments());
        if (this.modules != null && this.modules.size() > 0) {
            Iterator iterator = this.modules.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string);
                stringBuffer.append(' ');
            }
        } else {
            String string = CommandException.getLocalMessage("ExportCommand.moduleEmpty.text");
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.getAnnotateByRevision() != null) {
            stringBuffer.append("-r ");
            stringBuffer.append(this.getAnnotateByRevision());
            stringBuffer.append(" ");
        }
        if (this.getAnnotateByDate() != null) {
            stringBuffer.append("-D ");
            stringBuffer.append(this.getAnnotateByDate());
            stringBuffer.append(" ");
        }
        if (this.isUseHeadIfNotFound()) {
            stringBuffer.append("-f ");
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'r') {
            this.setAnnotateByRevision(string);
        } else if (c == 'D') {
            this.setAnnotateByDate(string);
        } else if (c == 'f') {
            this.setUseHeadIfNotFound(true);
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setAnnotateByDate(null);
        this.setAnnotateByRevision(null);
        this.setUseHeadIfNotFound(false);
    }

    public String getOptString() {
        return "Rlr:D:f";
    }

    public Builder createBuilder(EventManager eventManager) {
        return new AnnotateBuilder(eventManager, this);
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    public void setUseHeadIfNotFound(boolean bl) {
        this.useHeadIfNotFound = bl;
    }

    public String getAnnotateByDate() {
        return this.annotateByDate;
    }

    public void setAnnotateByDate(String string) {
        this.annotateByDate = string;
    }

    public String getAnnotateByRevision() {
        return this.annotateByRevision;
    }

    public void setAnnotateByRevision(String string) {
        this.annotateByRevision = string;
    }
}

