/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import java.io.IOException;
import org.netbeans.lib.cvsclient.connection.AbstractConnection;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class LocalConnection
extends AbstractConnection {
    private static final String CVS_EXE_COMMAND = System.getProperty("Env-CVS_EXE", "cvs") + " server";
    protected Process process;

    public LocalConnection() {
        this.reset();
    }

    private void openConnection() throws AuthenticationException {
        try {
            this.process = Runtime.getRuntime().exec(CVS_EXE_COMMAND);
            this.setOutputStream(new LoggedDataOutputStream(this.process.getOutputStream()));
            this.setInputStream(new LoggedDataInputStream(this.process.getInputStream()));
        }
        catch (IOException iOException) {
            this.reset();
            String string = AuthenticationException.getBundleString("AuthenticationException.ServerConnection");
            throw new AuthenticationException("Connection error", iOException, string);
        }
    }

    private void reset() {
        this.process = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    public void verify() throws AuthenticationException {
        try {
            this.openConnection();
            this.verifyProtocol();
            this.process.destroy();
        }
        catch (Exception exception) {
            String string = AuthenticationException.getBundleString("AuthenticationException.ServerVerification");
            throw new AuthenticationException("Verification error", exception, string);
        }
        finally {
            this.reset();
        }
    }

    public void open() throws AuthenticationException {
        this.openConnection();
    }

    public boolean isOpen() {
        return this.process != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.process != null) {
                this.process.destroy();
            }
        }
        finally {
            this.reset();
        }
    }

    public int getPort() {
        return 0;
    }

    public void modifyInputStream(ConnectionModifier connectionModifier) throws IOException {
        connectionModifier.modifyInputStream(this.getInputStream());
    }

    public void modifyOutputStream(ConnectionModifier connectionModifier) throws IOException {
        connectionModifier.modifyOutputStream(this.getOutputStream());
    }
}

