/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.util.ConverterUtil;
import org.nuiton.util.ObjectUtil;
import org.nuiton.util.SortedProperties;

public class ApplicationConfig {
    private static Log log = LogFactory.getLog(ApplicationConfig.class);
    private static final String CLASS_METHOD_SEPARATOR = "#";
    public static final String CONFIG_FILE_NAME = "config.file";
    protected boolean useOnlyAliases = false;
    protected Map<String, List<String>> aliases = new HashMap<String, List<String>>();
    String systemPath = File.separator + "etc" + File.separator;
    String userPath = ApplicationConfig.getUserHome() + File.separator + ".";
    protected boolean inParseOptionPhase = false;
    protected Properties defaults = new Properties();
    protected Properties classpath = new Properties(this.defaults);
    protected Properties etcfile = new Properties(this.classpath);
    protected Properties homefile = new Properties(this.etcfile);
    protected Properties curfile = new Properties(this.homefile);
    protected Properties env = new Properties(this.curfile);
    protected Properties jvm = new Properties(this.env);
    protected Properties line = new Properties(this.jvm);
    protected Properties options = new Properties(this.line);
    protected Map<String, CacheItem<?>> cacheOption = new HashMap();
    protected Map<Class<?>, Object> cacheAction = new HashMap();
    protected List<String> unparsed = new ArrayList<String>();
    protected Map<Integer, List<Action>> actions = new HashMap<Integer, List<Action>>();
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public ApplicationConfig() {
        this.setConfigFileName(this.getClass().getSimpleName());
        ConverterUtil.initConverters();
    }

    public static String getUserHome() {
        String result = System.getProperty("user.home");
        return result;
    }

    public String getUsername() {
        String result = this.getOption("user.name");
        return result;
    }

    protected void setDefaultOption(String key, String value) {
        this.defaults.setProperty(key, value);
    }

    public void save(File file, boolean forceAll, String ... excludeKeys) throws IOException {
        SortedProperties prop = new SortedProperties();
        if (forceAll) {
            prop.putAll((Map<?, ?>)this.defaults);
            prop.putAll((Map<?, ?>)this.classpath);
        }
        prop.putAll((Map<?, ?>)this.etcfile);
        prop.putAll((Map<?, ?>)this.homefile);
        prop.putAll((Map<?, ?>)this.curfile);
        if (forceAll) {
            prop.putAll((Map<?, ?>)this.jvm);
            prop.putAll((Map<?, ?>)this.env);
            prop.putAll((Map<?, ?>)this.line);
        }
        prop.putAll((Map<?, ?>)this.options);
        for (String excludeKey : excludeKeys) {
            prop.remove(excludeKey);
        }
        FileWriter writer = new FileWriter(file);
        prop.store(writer, "Last saved " + new java.util.Date());
    }

    public void saveForSystem(String ... excludeKeys) {
        block2: {
            File file = new File(this.systemPath + this.getConfigFileName());
            try {
                this.save(file, false, excludeKeys);
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)I18n._("nuitonutil.error.applicationconfig.save", file), (Throwable)eee);
            }
        }
    }

    public void saveForUser(String ... excludeKeys) {
        block2: {
            File file = new File(this.userPath + this.getConfigFileName());
            try {
                this.save(file, false, excludeKeys);
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)I18n._("nuitonutil.error.applicationconfig.save", file), (Throwable)eee);
            }
        }
    }

    public List<String> getUnparsed() {
        return this.unparsed;
    }

    public void addAction(Action action) {
        if (action != null) {
            Integer step = action.step;
            List<Action> list = this.actions.get(step);
            if (list == null) {
                list = new LinkedList<Action>();
                this.actions.put(step, list);
            }
            list.add(action);
        }
    }

    public void doAction(int step) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        List<Action> list = this.actions.get(step);
        if (list != null) {
            for (Action a : list) {
                a.doAction();
            }
        }
    }

    public void setUseOnlyAliases(boolean useOnlyAliases) {
        this.useOnlyAliases = useOnlyAliases;
    }

    public boolean isUseOnlyAliases() {
        return this.useOnlyAliases;
    }

    public void addAlias(String alias, String ... target) {
        this.aliases.put(alias, Arrays.asList(target));
    }

    public void addActionAlias(String alias, String actionMethod) {
        this.addAlias(alias, "--" + actionMethod);
    }

    public void setConfigFileName(String name) {
        this.setDefaultOption(CONFIG_FILE_NAME, name);
    }

    public String getConfigFileName() {
        String result = this.options.getProperty(CONFIG_FILE_NAME);
        return result;
    }

    public void setOption(String key, String value) {
        if (this.inParseOptionPhase) {
            this.line.setProperty(key, value);
        } else {
            this.options.setProperty(key, value);
        }
    }

    public String getOption(String key) {
        String value = this.options.getProperty(key);
        return value;
    }

    public Properties getOptionStartsWith(String prefix) {
        Properties result = new Properties();
        for (String key : this.options.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            result.setProperty(key, this.options.getProperty(key));
        }
        return result;
    }

    public Object getOption(OptionDef key) {
        Object result = this.getOption(key.getType(), key.getKey());
        return result;
    }

    public <T> T getOption(Class<T> clazz, String key) {
        CacheItem<Object> cacheItem;
        Object result = null;
        String cacheKey = key + "-" + clazz.getName();
        String value = this.options.getProperty(key);
        int hash = 0;
        if (value != null) {
            hash = value.hashCode();
        }
        if ((cacheItem = this.cacheOption.get(cacheKey)) == null || cacheItem.hash != hash) {
            result = ConverterUtil.convert(clazz, value);
            cacheItem = new CacheItem<Object>(result, hash);
            this.cacheOption.put(cacheKey, cacheItem);
        } else {
            result = cacheItem.item;
        }
        return result;
    }

    public File getOptionAsFile(String key) {
        File result = this.getOption(File.class, key);
        result = result.getAbsoluteFile();
        return result;
    }

    public URL getOptionAsURL(String key) {
        URL result = this.getOption(URL.class, key);
        return result;
    }

    public Class<?> getOptionAsClass(String key) {
        Class result = this.getOption(Class.class, key);
        return result;
    }

    public Date getOptionAsDate(String key) {
        Date result = this.getOption(Date.class, key);
        return result;
    }

    public Time getOptionAsTime(String key) {
        Time result = this.getOption(Time.class, key);
        return result;
    }

    public Timestamp getOptionAsTimestamp(String key) {
        Timestamp result = this.getOption(Timestamp.class, key);
        return result;
    }

    public int getOptionAsInt(String key) {
        Integer result = this.getOption(Integer.class, key);
        return result;
    }

    public double getOptionAsDouble(String key) {
        Double result = this.getOption(Double.class, key);
        return result;
    }

    public boolean getOptionAsBoolean(String key) {
        Boolean result = this.getOption(Boolean.class, key);
        return result;
    }

    public Properties getOptions() {
        return this.options;
    }

    public void setOptions(Properties options) {
        this.options = options;
    }

    protected Map<String, Method> getMethods() {
        Method[] allMethods = this.getClass().getMethods();
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Method m : allMethods) {
            String methodName = m.getName();
            if (!methodName.startsWith("set")) continue;
            methodName = methodName.substring(3).toLowerCase();
            methods.put(methodName, m);
        }
        return methods;
    }

    protected String[] getParams(Method m, ListIterator<String> args) {
        ArrayList<String> result = new ArrayList<String>();
        if (m.isVarArgs()) {
            while (args.hasNext()) {
                String p = args.next();
                if (p.startsWith("--")) {
                    args.previous();
                    break;
                }
                result.add(p);
                args.remove();
            }
        } else {
            int paramLenght = m.getParameterTypes().length;
            for (int i = 0; i < paramLenght; ++i) {
                String p = args.next();
                args.remove();
                result.add(p);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    protected Action createAction(String name, ListIterator<String> args) throws ArgumentsParserException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> clazz;
        Action result = null;
        Method method = null;
        int sep = name.lastIndexOf(CLASS_METHOD_SEPARATOR);
        if (sep == -1) {
            throw new IllegalArgumentException(String.format("Can't find action method in %s", name));
        }
        String className = name.substring(0, sep);
        String methodName = name.substring(sep + 1);
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException eee) {
            throw new IllegalArgumentException(String.format("Can't find action class %s", className));
        }
        List<Method> methods = ObjectUtil.getMethod(clazz, methodName, true);
        if (methods.size() > 0) {
            if (methods.size() > 1) {
                log.warn((Object)String.format("More than one method found, used the first: %s", methods));
            }
            method = methods.get(0);
        }
        if (method != null) {
            args.remove();
            Object o = this.cacheAction.get(clazz);
            if (o == null && !Modifier.isStatic(method.getModifiers())) {
                try {
                    o = ConstructorUtils.invokeConstructor(clazz, (Object)this);
                }
                catch (NoSuchMethodException eee) {
                    log.debug((Object)String.format("Use default constructor, because no constructor with Config parameter on class %s", clazz.getName()));
                    o = clazz.newInstance();
                }
                this.cacheAction.put(clazz, o);
            }
            int step = 0;
            Action.Step annotation = method.getAnnotation(Action.Step.class);
            if (annotation != null) {
                step = annotation.value();
            }
            String[] params = this.getParams(method, args);
            result = new Action(step, o, method, params);
        }
        return result;
    }

    public void parse(String[] args) throws ArgumentsParserException {
        try {
            String arg;
            File config;
            File homeConfig;
            File etcConfig;
            String arg2;
            Map<String, Method> methods = this.getMethods();
            ArrayList<String> arguments = new ArrayList<String>(args.length);
            for (String arg3 : args) {
                if (this.aliases.containsKey(arg3)) {
                    arguments.addAll((Collection)this.aliases.get(arg3));
                    continue;
                }
                arguments.add(arg3);
            }
            this.inParseOptionPhase = true;
            ListIterator<String> i = arguments.listIterator();
            while (i.hasNext() && !(arg2 = (String)i.next()).equals("--")) {
                String optionName;
                if (!arg2.startsWith("--") || !methods.containsKey(optionName = arg2.substring(2))) continue;
                i.remove();
                Method m = methods.get(optionName);
                Object[] params = this.getParams(m, i);
                log.debug((Object)String.format("Set option '%s' with method '%s %s'", optionName, m, Arrays.toString(params)));
                ObjectUtil.call(this, m, (String[])params);
            }
            this.inParseOptionPhase = false;
            this.jvm.putAll((Map<?, ?>)System.getProperties());
            this.env.putAll(System.getenv());
            String filename = this.getConfigFileName();
            URL inClasspath = ClassLoader.getSystemClassLoader().getResource(filename);
            if (inClasspath == null) {
                inClasspath = ApplicationConfig.class.getResource("/" + filename);
            }
            if (inClasspath != null) {
                log.info((Object)("Chargement du fichier de config: " + inClasspath));
                this.classpath.load(inClasspath.openStream());
            }
            if ((etcConfig = new File(this.systemPath + filename)).exists()) {
                log.info((Object)("Chargement du fichier de config: " + etcConfig));
                this.etcfile.load(etcConfig.toURI().toURL().openStream());
            }
            if ((homeConfig = new File(this.userPath + filename)).exists()) {
                log.info((Object)("Chargement du fichier de config: " + homeConfig));
                this.homefile.load(homeConfig.toURI().toURL().openStream());
            }
            if ((config = new File(filename)).exists()) {
                log.info((Object)("Chargement du fichier de config: " + config));
                this.curfile.load(config.toURI().toURL().openStream());
            }
            ListIterator<String> i2 = arguments.listIterator();
            while (i2.hasNext() && !(arg = (String)i2.next()).equals("--")) {
                if (!arg.startsWith("--")) continue;
                String optionName = arg.substring(2);
                Action action = this.createAction(optionName, i2);
                this.addAction(action);
            }
            arguments.remove("--");
            this.unparsed.addAll(arguments);
        }
        catch (Exception eee) {
            eee.printStackTrace();
            throw new ArgumentsParserException("Can't parse argument", eee);
        }
    }

    public void printConfig() {
        System.out.println("-------------------Value-------------------------");
        System.out.println("defaults " + this.defaults);
        System.out.println("classpath " + this.classpath);
        System.out.println("etcfile " + this.etcfile);
        System.out.println("homefile " + this.homefile);
        System.out.println("curfile " + this.curfile);
        System.out.println("env " + this.env);
        System.out.println("jvm " + this.jvm);
        System.out.println("line " + this.line);
        System.out.println("options " + this.options);
        System.out.println("-------------------------------------------------");
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    protected static class CacheItem<T> {
        public T item;
        public int hash;

        public CacheItem(T item, int hash) {
            this.item = item;
            this.hash = hash;
        }
    }

    public static class Action {
        protected int step;
        protected Object o;
        protected Method m;
        protected String[] params;

        public Action(int step, Object o, Method m, String ... params) {
            this.step = step;
            this.o = o;
            this.m = m;
            this.params = params;
        }

        public void doAction() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
            ObjectUtil.call(this.o, this.m, this.params);
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.METHOD})
        public static @interface Step {
            public int value() default 0;
        }
    }

    public static interface OptionDef {
        public String getKey();

        public Class<?> getType();

        public String getDescription();

        public String getDefaultValue();

        public boolean isTransient();

        public boolean isFinal();
    }
}

