/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.Console;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Locale;
import org.nuiton.i18n.I18n;

public class FileCompletion {
    private boolean exit;
    private boolean creation;
    private boolean consoleAvailable;
    private Console console;

    public FileCompletion(boolean creation, boolean exit) {
        this.exit = exit;
        this.creation = creation;
        if (Locale.getDefault().getLanguage().equals("fr")) {
            I18n.init("fr", "FR");
        } else {
            I18n.init("en", "US");
        }
        this.console = System.console();
        this.consoleAvailable = this.console != null;
    }

    public String read() throws IOException {
        if (this.creation) {
            System.out.println(I18n._("nuitonutil.fileCompletion.save"));
        }
        if (this.exit) {
            System.out.println(I18n._("nuitonutil.fileCompletion.exit"));
        }
        System.out.println(I18n._("nuitonutil.fileCompletion.cancel"));
        System.out.println(I18n._("nuitonutil.fileCompletion.enter"));
        String line = System.getProperty("user.dir");
        line = line + this.readLine("> " + line + File.separator);
        File f = new File(line);
        String moreLastLine = line;
        boolean isDirectory = true;
        do {
            if (!f.isDirectory() && f.exists()) continue;
            String lastLine = line;
            if (!f.exists() && !f.isDirectory()) {
                File fTmp = f.getParentFile();
                String file = f.getName();
                if (file.matches("^.*\\!s$") && this.creation) {
                    return f.getCanonicalPath().substring(0, f.getCanonicalPath().length() - 2);
                }
                if (file.matches("^.*\\!q$") && this.exit) {
                    return null;
                }
                if (file.matches("^.*\\.\\.$")) {
                    line = fTmp.getCanonicalPath();
                } else {
                    Filter filtre = new Filter();
                    filtre.setFilter(file);
                    String[] listFichier = fTmp.list(filtre);
                    if (listFichier.length == 1) {
                        line = fTmp.getParentFile() != null ? fTmp.getCanonicalPath() + File.separator + listFichier[0] : fTmp.getCanonicalPath() + listFichier[0];
                    } else if (listFichier.length > 1) {
                        this.afficherListe(listFichier);
                    } else {
                        line = moreLastLine;
                    }
                }
            } else if (f.exists() && f.isDirectory() && f.getParentFile() != null) {
                Filter filtre = new Filter();
                filtre.setFilter(f.getName());
                String[] listFichier = f.getParentFile().list(filtre);
                if (listFichier.length <= 1 || line.charAt(line.length() - 1) == File.separatorChar) {
                    line = f.getCanonicalPath();
                    isDirectory = true;
                } else if (listFichier.length > 1) {
                    isDirectory = false;
                    this.afficherListe(listFichier);
                }
            }
            moreLastLine = line;
            f = new File(line);
            if (f.isDirectory() && isDirectory && line.charAt(line.length() - 1) != File.separatorChar) {
                line = line + File.separator;
            }
            String read = this.readLine("> " + line);
            line = line + read;
            f = new File(line);
            if (read.equals("") || read.equals(File.separator)) {
                this.afficherListe(f.list());
            }
            if (line.matches(".* " + File.separator + ".*") || line.matches(".*" + File.separator + " .*")) {
                line = lastLine;
            }
            f = new File(line);
        } while (!f.exists() || f.isDirectory());
        return line;
    }

    private String readLine(String path) {
        String lineNonNull = null;
        while (lineNonNull == null) {
            lineNonNull = this.console.readLine(path, new Object[0]);
        }
        return lineNonNull;
    }

    public boolean consoleAvailable() {
        return this.consoleAvailable;
    }

    private void afficherListe(String[] listefichiers) {
        if (listefichiers != null) {
            int i = 0;
            int nomMax = 0;
            for (String l : listefichiers) {
                nomMax = Math.max(nomMax, l.length());
            }
            for (String l : listefichiers) {
                String space = "";
                int nbSpace = nomMax + 1 - l.length();
                for (int j = 0; j < nbSpace; ++j) {
                    space = space + " ";
                }
                if (i++ < 2) {
                    System.out.print(l + space);
                    continue;
                }
                i = 0;
                System.out.println(l);
            }
            System.out.println();
        }
    }

    class Filter
    implements FilenameFilter {
        private String filtre;

        Filter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.filtre);
        }

        public void setFilter(String s) {
            this.filtre = s;
        }
    }
}

