/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.MD5;

public class MD5InputStream
extends FilterInputStream {
    private static Log log = LogFactory.getLog(MD5InputStream.class);
    protected MD5 md5 = new MD5();
    protected long streamLength;

    public MD5InputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            return -1;
        }
        if ((c & 0xFFFFFF00) != 0) {
            log.warn((Object)"MD5InputStream.read() got character with (c & ~0xff) != 0)!");
        } else {
            ++this.streamLength;
            this.md5.Update(c);
        }
        return c;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int r = this.in.read(bytes, offset, length);
        if (r == -1) {
            return r;
        }
        this.streamLength += (long)r;
        this.md5.Update(bytes, offset, r);
        return r;
    }

    public byte[] hash() {
        return this.md5.Final();
    }

    public MD5 getMD5() {
        return this.md5;
    }

    public long getStreamLength() {
        return this.streamLength;
    }
}

