/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.i18n.I18n;

public class ReflectUtil {
    public static boolean isConstantField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static <T> List<T> getConstants(Class<?> klass, Class<T> searchingClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Field field : klass.getDeclaredFields()) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (!searchingClass.isAssignableFrom(field.getType()) || !ReflectUtil.isConstantField(field)) continue;
            try {
                result.add(field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        Class<?> superClass = klass.getSuperclass();
        if (superClass != null) {
            result.addAll(ReflectUtil.getConstants(superClass, searchingClass));
        }
        return result;
    }

    public static <T> T getConstant(Class<?> klass, String fieldName) {
        try {
            Object result = null;
            Field f = klass.getDeclaredField(fieldName);
            if (ReflectUtil.isConstantField(f)) {
                f.setAccessible(true);
                result = f.get(null);
            }
            return (T)result;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Enum<T>> Class<T> getEnumClass(Class<?> type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException(I18n._("nuitonutil.error.null.parameter", "type"));
        }
        if (!type.isEnum()) {
            throw new IllegalArgumentException(I18n._("nuitonutil.error.not.an.enum", type));
        }
        return type;
    }
}

