/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.war;

import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.swing.ImageIcon;
import winstone.Launcher;

public class WinstoneLauncher
implements ActionListener,
MouseListener {
    protected Launcher winstone;
    protected URI serverUri;

    public static void main(String[] args) throws IOException {
        WinstoneLauncher launcher = new WinstoneLauncher();
        launcher.startServer(args);
        launcher.installSystemTray();
        launcher.openBrowser();
    }

    protected void startServer(String[] args) throws IOException {
        System.out.println("Starting server embedded mode...");
        String fqnLauncherFile = WinstoneLauncher.class.getName().replaceAll("\\.", "/") + ".class";
        System.out.println("Search for launcher class : " + fqnLauncherFile);
        URL classFile = WinstoneLauncher.class.getClassLoader().getResource(fqnLauncherFile);
        System.out.println(" - using classFile : " + classFile);
        File me = new File(((JarURLConnection)classFile.openConnection()).getJarFile().getName());
        System.out.println(" - using warfile file : " + me);
        Map hashArgs = Launcher.getArgsFromCommandLine((String[])args);
        hashArgs.put("warfile", me.getAbsolutePath());
        System.out.println(" - using args : " + hashArgs);
        Launcher.initLogger((Map)hashArgs);
        this.winstone = new Launcher(hashArgs);
        int port = 8080;
        String configPort = (String)hashArgs.get("httpPort");
        if (configPort != null && !configPort.isEmpty()) {
            try {
                port = Integer.parseInt(configPort);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        try {
            this.serverUri = new URI("http://localhost:" + port);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    protected void stopServer() {
        if (this.winstone != null) {
            this.winstone.shutdown();
            System.exit(0);
        }
    }

    protected void installSystemTray() {
        if (SystemTray.isSupported()) {
            PopupMenu menu = new PopupMenu();
            MenuItem browserItem = new MenuItem("Start browser");
            browserItem.addActionListener(this);
            browserItem.setActionCommand("browser");
            menu.add(browserItem);
            MenuItem stopItem = new MenuItem("Stop server");
            stopItem.addActionListener(this);
            stopItem.setActionCommand("stop");
            menu.add(stopItem);
            URL imageURL = WinstoneLauncher.class.getResource("/favicon.png");
            if (imageURL == null) {
                imageURL = WinstoneLauncher.class.getResource("/favicon.jpg");
            }
            if (imageURL == null) {
                System.out.println("No favicon.{png|jpg} found, skip systray installation");
            } else {
                Image image = new ImageIcon(imageURL).getImage();
                TrayIcon icon = new TrayIcon(image, "Server", menu);
                icon.setImageAutoSize(true);
                icon.addMouseListener(this);
                SystemTray systemTray = SystemTray.getSystemTray();
                try {
                    systemTray.add(icon);
                }
                catch (AWTException ex) {
                    throw new RuntimeException("Can't install tray icon", ex);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("browser".equalsIgnoreCase(e.getActionCommand())) {
            this.openBrowser();
        } else if ("stop".equalsIgnoreCase(e.getActionCommand())) {
            this.stopServer();
        }
    }

    protected void openBrowser() {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && this.serverUri != null && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            System.out.println("Opening browser at " + this.serverUri);
            try {
                desktop.browse(this.serverUri);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.openBrowser();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

