/*
 * Decompiled with CFR 0.152.
 */
package org.onepf.opfiab.google;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.android.vending.billing.IInAppBillingService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.onepf.opfiab.billing.AidlBillingHelper;
import org.onepf.opfiab.google.GoogleUtils;
import org.onepf.opfiab.google.Response;
import org.onepf.opfiab.google.model.ItemType;
import org.onepf.opfutils.OPFLog;
import org.onepf.opfutils.OPFPreferences;
import org.onepf.opfutils.OPFUtils;

class GoogleBillingHelper
extends AidlBillingHelper<IInAppBillingService> {
    private static final String INTENT_ACTION = "com.android.vending.billing.InAppBillingService.BIND";
    private static final String INTENT_PACKAGE = "com.android.vending";
    private static final String KEY_CONTINUATION_TOKEN = "com.google.play.continuation_token.";
    private static final int API = 3;
    private static final int BATCH_SIZE = 20;
    @NonNull
    private final String packageName;
    @NonNull
    private final OPFPreferences preferences;

    GoogleBillingHelper(@NonNull Context context) {
        super(context, IInAppBillingService.class);
        this.packageName = context.getPackageName();
        this.preferences = new OPFPreferences(context, "Google");
    }

    @Nullable
    Response isBillingSupported() {
        OPFLog.logMethod((Object[])new Object[0]);
        IInAppBillingService service = (IInAppBillingService)this.getService();
        if (service == null) {
            return null;
        }
        try {
            for (ItemType itemType : ItemType.values()) {
                int code = service.isBillingSupported(3, this.packageName, itemType.toString());
                Response response = Response.fromCode(code);
                if (response == Response.OK) continue;
                return response;
            }
            return Response.OK;
        }
        catch (RemoteException exception) {
            OPFLog.d((String)"Billing check failed.", (Throwable)exception);
            return null;
        }
    }

    @Nullable
    Bundle getBuyIntent(@NonNull String sku, @NonNull ItemType itemType) {
        OPFLog.logMethod((Object[])new Object[]{sku, itemType});
        IInAppBillingService service = (IInAppBillingService)this.getService();
        if (service == null) {
            return null;
        }
        try {
            String type = itemType.toString();
            Bundle result = service.getBuyIntent(3, this.packageName, sku, type, "");
            Response response = GoogleUtils.getResponse(result);
            OPFLog.d((String)"Response: %s. Result: %s", (Object[])new Object[]{response, OPFUtils.toString((Bundle)result)});
            return result;
        }
        catch (RemoteException exception) {
            OPFLog.d((String)"getBuyIntent request failed.", (Throwable)exception);
            return null;
        }
    }

    @Nullable
    Response consumePurchase(@NonNull String token) {
        OPFLog.logMethod((Object[])new Object[]{token});
        IInAppBillingService service = (IInAppBillingService)this.getService();
        if (service == null) {
            return null;
        }
        try {
            int code = service.consumePurchase(3, this.packageName, token);
            Response response = Response.fromCode(code);
            OPFLog.d((String)"Response: %s", (Object[])new Object[]{response});
            return response;
        }
        catch (RemoteException exception) {
            OPFLog.e((String)"consumePurchase request failed.", (Throwable)exception);
            return null;
        }
    }

    @Nullable
    Bundle getSkuDetails(@NonNull Collection<String> skus) {
        OPFLog.logMethod((Object[])new Object[]{Arrays.toString(skus.toArray())});
        IInAppBillingService service = (IInAppBillingService)this.getService();
        if (service == null) {
            return null;
        }
        ArrayList<String> skuList = new ArrayList<String>(skus);
        Bundle result = new Bundle();
        try {
            int size = skuList.size();
            int batchCount = size / 20;
            for (int i = 0; i <= batchCount; ++i) {
                int first = i * 20;
                int last = Math.min((i + 1) * 20, size);
                ArrayList<String> batch = new ArrayList<String>(skuList.subList(first, last));
                Bundle bundle = GoogleUtils.putSkuList(new Bundle(), batch);
                for (ItemType itemType : ItemType.values()) {
                    String type = itemType.toString();
                    Bundle details = service.getSkuDetails(3, this.packageName, type, bundle);
                    Response response = GoogleUtils.getResponse(details);
                    OPFLog.d((String)"From %d to %d. Type: %s. Response: %s. Details: %s.", (Object[])new Object[]{first, last, itemType, response, OPFUtils.toString((Bundle)details)});
                    if (response != Response.OK) {
                        return details;
                    }
                    ArrayList<String> skuDetails = GoogleUtils.getSkuDetails(details);
                    GoogleUtils.addSkuDetails(result, skuDetails);
                }
            }
        }
        catch (RemoteException exception) {
            OPFLog.e((String)"getSkuDetails request failed.", (Throwable)exception);
            return null;
        }
        return GoogleUtils.putResponse(result, Response.OK);
    }

    @Nullable
    Bundle getPurchases(boolean startOver) {
        OPFLog.logMethod((Object[])new Object[]{startOver});
        IInAppBillingService service = (IInAppBillingService)this.getService();
        if (service == null) {
            return null;
        }
        Bundle result = new Bundle();
        try {
            for (ItemType itemType : ItemType.values()) {
                String type = itemType.toString();
                String key = KEY_CONTINUATION_TOKEN + type;
                String token = startOver ? null : this.preferences.getString(key);
                Bundle purchases = service.getPurchases(3, this.packageName, type, token);
                Response response = GoogleUtils.getResponse(purchases);
                OPFLog.d((String)"Type: %s. Response: %s. Purchases: %s.", (Object[])new Object[]{itemType, response, OPFUtils.toString((Bundle)purchases)});
                if (response != Response.OK) {
                    return purchases;
                }
                ArrayList<String> purchaseDataList = GoogleUtils.getDataList(purchases);
                ArrayList<String> itemList = GoogleUtils.getItemList(purchases);
                ArrayList<String> signatureList = GoogleUtils.getSignatureList(purchases);
                String newToken = GoogleUtils.getContinuationToken(purchases);
                GoogleUtils.addDataList(result, purchaseDataList);
                GoogleUtils.addItemList(result, itemList);
                GoogleUtils.addSignatureList(result, signatureList);
                if (TextUtils.isEmpty((CharSequence)newToken)) {
                    this.preferences.remove(key);
                    continue;
                }
                this.preferences.put(key, newToken);
            }
        }
        catch (RemoteException exception) {
            OPFLog.e((String)"getPurchases request failed.", (Throwable)exception);
            return null;
        }
        return GoogleUtils.putResponse(result, Response.OK);
    }

    @NonNull
    protected Intent getServiceIntent() {
        Intent serviceIntent = new Intent(INTENT_ACTION);
        serviceIntent.setPackage(INTENT_PACKAGE);
        return serviceIntent;
    }
}

