/*
 * Decompiled with CFR 0.152.
 */
package org.onepf.opfiab.google;

import android.accounts.AccountManager;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.json.JSONException;
import org.onepf.opfiab.billing.ActivityBillingProvider;
import org.onepf.opfiab.billing.BaseBillingProvider;
import org.onepf.opfiab.google.GoogleBillingHelper;
import org.onepf.opfiab.google.GoogleSkuResolver;
import org.onepf.opfiab.google.GoogleUtils;
import org.onepf.opfiab.google.Response;
import org.onepf.opfiab.google.model.GooglePurchase;
import org.onepf.opfiab.google.model.GoogleSkuDetails;
import org.onepf.opfiab.google.model.ItemType;
import org.onepf.opfiab.google.model.PurchaseState;
import org.onepf.opfiab.google.model.SignedPurchase;
import org.onepf.opfiab.model.BillingProviderInfo;
import org.onepf.opfiab.model.billing.Purchase;
import org.onepf.opfiab.model.billing.SkuDetails;
import org.onepf.opfiab.model.billing.SkuType;
import org.onepf.opfiab.model.event.billing.Status;
import org.onepf.opfiab.sku.SkuResolver;
import org.onepf.opfiab.verification.PurchaseVerifier;
import org.onepf.opfutils.OPFChecks;
import org.onepf.opfutils.OPFLog;
import org.onepf.opfutils.OPFUtils;

public class GoogleBillingProvider
extends ActivityBillingProvider<GoogleSkuResolver, PurchaseVerifier> {
    protected static final String NAME = "Google";
    protected static final String PACKAGE = "com.google.play";
    protected static final String INSTALLER = "com.android.vending";
    protected static final String PERMISSION_BILLING = "com.android.vending.BILLING";
    protected static final String ACCOUNT_TYPE_GOOGLE = "com.google";
    public static final BillingProviderInfo INFO = new BillingProviderInfo("Google", "com.google.play", "com.android.vending");
    protected final GoogleBillingHelper helper;

    protected GoogleBillingProvider(@NonNull Context context, @NonNull GoogleSkuResolver skuResolver, @NonNull PurchaseVerifier purchaseVerifier) {
        super(context, (SkuResolver)skuResolver, purchaseVerifier);
        this.helper = new GoogleBillingHelper(context);
    }

    @NonNull
    protected SkuType skuType(@NonNull String sku, @NonNull ItemType itemType) {
        switch (itemType) {
            case CONSUMABLE_OR_ENTITLEMENT: {
                return ((GoogleSkuResolver)this.skuResolver).resolveType(sku);
            }
            case SUBSCRIPTION: {
                return SkuType.SUBSCRIPTION;
            }
        }
        return SkuType.UNKNOWN;
    }

    @NonNull
    protected SkuDetails newSkuDetails(@NonNull GoogleSkuDetails googleSkuDetails) {
        String sku = googleSkuDetails.getProductId();
        ItemType itemType = googleSkuDetails.getItemType();
        SkuType skuType = this.skuType(sku, itemType);
        return new SkuDetails.Builder(sku).setType(skuType).setProviderInfo(this.getInfo()).setOriginalJson(googleSkuDetails.getOriginalJson()).setPrice(googleSkuDetails.getPrice()).setTitle(googleSkuDetails.getTitle()).setDescription(googleSkuDetails.getDescription()).build();
    }

    @NonNull
    protected Purchase newPurchase(@NonNull GooglePurchase googlePurchase) {
        String sku = googlePurchase.getProductId();
        SkuType skuType = ((GoogleSkuResolver)this.skuResolver).resolveType(sku);
        return new Purchase.Builder(sku).setType(skuType).setProviderInfo(this.getInfo()).setOriginalJson(googlePurchase.getOriginalJson()).setToken(googlePurchase.getPurchaseToken()).setPurchaseTime(googlePurchase.getPurchaseTime()).setCanceled(googlePurchase.getPurchaseState() == PurchaseState.CANCELED).build();
    }

    protected Status getStatus(@Nullable Response response) {
        if (response == null) {
            return Status.UNKNOWN_ERROR;
        }
        switch (response) {
            case OK: {
                return Status.SUCCESS;
            }
            case USER_CANCELED: {
                return Status.USER_CANCELED;
            }
            case SERVICE_UNAVAILABLE: {
                return Status.SERVICE_UNAVAILABLE;
            }
            case ITEM_UNAVAILABLE: {
                return Status.ITEM_UNAVAILABLE;
            }
            case ITEM_ALREADY_OWNED: {
                return Status.ITEM_ALREADY_OWNED;
            }
            case BILLING_UNAVAILABLE: {
                return this.isAuthorised() ? Status.BILLING_UNAVAILABLE : Status.UNAUTHORISED;
            }
        }
        return Status.UNKNOWN_ERROR;
    }

    public void checkManifest() {
        OPFChecks.checkPermission((Context)this.context, (String)"android.permission.GET_ACCOUNTS");
        OPFChecks.checkPermission((Context)this.context, (String)PERMISSION_BILLING);
    }

    public boolean isAvailable() {
        Response response = this.helper.isBillingSupported();
        OPFLog.d((String)"Check if billing supported: %s", (Object[])new Object[]{response});
        Status status = this.getStatus(response);
        return status == Status.SUCCESS || status == Status.UNAUTHORISED;
    }

    public boolean isAuthorised() {
        Object service = this.context.getSystemService("account");
        AccountManager accountManager = (AccountManager)service;
        return accountManager.getAccountsByType(ACCOUNT_TYPE_GOOGLE).length > 0;
    }

    @NonNull
    public BillingProviderInfo getInfo() {
        return INFO;
    }

    public void purchase(@NonNull Activity activity, @NonNull String sku) {
        SkuType skuType = ((GoogleSkuResolver)this.skuResolver).resolveType(sku);
        ItemType itemType = ItemType.fromSkuType(skuType);
        if (itemType == null) {
            OPFLog.e((String)"Unknown sku type: %s", (Object[])new Object[]{sku});
            this.postPurchaseResponse(Status.UNKNOWN_ERROR, null);
            return;
        }
        Bundle result = this.helper.getBuyIntent(sku, itemType);
        Response response = GoogleUtils.getResponse(result);
        PendingIntent intent = GoogleUtils.getBuyIntent(result);
        if (response != Response.OK || intent == null) {
            OPFLog.e((String)"Failed to retrieve buy intent.");
            this.postPurchaseResponse(this.getStatus(response), null);
            return;
        }
        IntentSender sender = intent.getIntentSender();
        try {
            activity.startIntentSenderForResult(sender, REQUEST_CODE, new Intent(), 0, 0, 0);
        }
        catch (IntentSender.SendIntentException exception) {
            OPFLog.e((String)"Failed to send buy intent.", (Throwable)exception);
            this.postPurchaseResponse(Status.UNKNOWN_ERROR, null);
        }
    }

    public void consume(@NonNull Purchase purchase) {
        String token = purchase.getToken();
        if (TextUtils.isEmpty((CharSequence)token)) {
            OPFLog.e((String)"Purchase toke in empty.");
            this.postConsumeResponse(Status.ITEM_UNAVAILABLE, purchase);
            return;
        }
        Response response = this.helper.consumePurchase(token);
        if (response != Response.OK) {
            OPFLog.e((String)"Consume failed.");
            this.postConsumeResponse(this.getStatus(response), purchase);
            return;
        }
        this.postConsumeResponse(Status.SUCCESS, purchase);
    }

    public void skuDetails(@NonNull Set<String> skus) {
        Bundle result = this.helper.getSkuDetails(skus);
        Response response = GoogleUtils.getResponse(result);
        if (response != Response.OK || result == null) {
            OPFLog.e((String)"Failed to retrieve sku details.");
            this.postSkuDetailsResponse(this.getStatus(response), null);
            return;
        }
        ArrayList<String> jsonSkuDetails = GoogleUtils.getSkuDetails(result);
        if (jsonSkuDetails == null) {
            this.postSkuDetailsResponse(Status.SUCCESS, Collections.emptyList());
            return;
        }
        ArrayList<SkuDetails> skusDetails = new ArrayList<SkuDetails>();
        LinkedList<String> unresolvedSkus = new LinkedList<String>(skus);
        for (String jsonSku : jsonSkuDetails) {
            try {
                GoogleSkuDetails googleSkuDetails = new GoogleSkuDetails(jsonSku);
                SkuDetails skuDetails = this.newSkuDetails(googleSkuDetails);
                unresolvedSkus.remove(skuDetails.getSku());
                skusDetails.add(skuDetails);
            }
            catch (JSONException exception) {
                OPFLog.e((String)("Failed to parse sku details: " + skusDetails), (Throwable)exception);
            }
        }
        for (String sku : unresolvedSkus) {
            skusDetails.add(new SkuDetails(sku));
        }
        this.postSkuDetailsResponse(Status.SUCCESS, skusDetails);
    }

    public void inventory(boolean startOver) {
        Bundle result = this.helper.getPurchases(startOver);
        Response response = GoogleUtils.getResponse(result);
        if (response != Response.OK || result == null) {
            OPFLog.e((String)"Failed to retrieve purchase data.");
            this.postInventoryResponse(this.getStatus(response), null, false);
            return;
        }
        ArrayList<String> itemList = GoogleUtils.getItemList(result);
        ArrayList<String> dataList = GoogleUtils.getDataList(result);
        ArrayList<String> signatureList = GoogleUtils.getSignatureList(result);
        if (itemList == null || dataList == null || signatureList == null) {
            this.postInventoryResponse(Status.SUCCESS, Collections.emptyList(), false);
            return;
        }
        int size = dataList.size();
        if (itemList.size() < size || signatureList.size() < size) {
            OPFLog.e((String)"Failed to parse purchase data response.");
            this.postInventoryResponse(Status.UNKNOWN_ERROR, Collections.emptyList(), false);
            return;
        }
        ArrayList<SignedPurchase> inventory = new ArrayList<SignedPurchase>(size);
        for (int i = 0; i < size; ++i) {
            String data = (String)dataList.get(i);
            try {
                GooglePurchase googlePurchase = new GooglePurchase(data);
                Purchase purchase = this.newPurchase(googlePurchase);
                String signature = (String)signatureList.get(i);
                SignedPurchase signedPurchase = new SignedPurchase(purchase, signature);
                inventory.add(signedPurchase);
                continue;
            }
            catch (JSONException exception) {
                OPFLog.e((String)"Failed to parse purchase data.", (Throwable)exception);
            }
        }
        String token = GoogleUtils.getContinuationToken(result);
        boolean hasMore = !TextUtils.isEmpty((CharSequence)token);
        this.postInventoryResponse(Status.SUCCESS, inventory, hasMore);
    }

    public void onActivityResult(@NonNull Activity activity, int requestCode, int resultCode, @Nullable Intent data) {
        GooglePurchase googlePurchase;
        Response response = GoogleUtils.getResponse(data);
        String purchaseData = GoogleUtils.getPurchaseData(data);
        String signature = GoogleUtils.getSignature(data);
        if (resultCode != -1 || response != Response.OK || purchaseData == null || signature == null) {
            OPFLog.e((String)"Failed to handle activity result. Code:%s, Data:%s", (Object[])new Object[]{resultCode, OPFUtils.toString((Intent)data)});
            this.postPurchaseResponse(this.getStatus(response), null);
            return;
        }
        try {
            googlePurchase = new GooglePurchase(purchaseData);
        }
        catch (JSONException exception) {
            OPFLog.e((String)("Failed to parse purchase data: " + purchaseData), (Throwable)exception);
            this.postPurchaseResponse(Status.UNKNOWN_ERROR, null);
            return;
        }
        Purchase purchase = this.newPurchase(googlePurchase);
        SignedPurchase signedPurchase = new SignedPurchase(purchase, signature);
        this.postPurchaseResponse(Status.SUCCESS, signedPurchase);
    }

    public static class Builder
    extends BaseBillingProvider.Builder<GoogleSkuResolver, PurchaseVerifier> {
        public Builder(@NonNull Context context) {
            super(context, (SkuResolver)GoogleSkuResolver.DEFAULT, PurchaseVerifier.DEFAULT);
        }

        public GoogleBillingProvider build() {
            return new GoogleBillingProvider(this.context, (GoogleSkuResolver)this.skuResolver, this.purchaseVerifier);
        }

        public Builder setSkuResolver(@NonNull GoogleSkuResolver skuResolver) {
            return (Builder)super.setSkuResolver((SkuResolver)skuResolver);
        }

        public Builder setPurchaseVerifier(@NonNull PurchaseVerifier purchaseVerifier) {
            return (Builder)super.setPurchaseVerifier(purchaseVerifier);
        }
    }
}

