/*
 * Decompiled with CFR 0.152.
 */
package org.onepf.opfiab.google;

import android.app.PendingIntent;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import org.onepf.opfiab.google.Response;

@SuppressFBWarnings(value={"CFS_CONFUSING_FUNCTION_SEMANTICS"})
public final class GoogleUtils {
    private static final String RESPONSE_CODE = "RESPONSE_CODE";
    private static final String SKU_DETAILS_LIST = "DETAILS_LIST";
    private static final String SKU_LIST = "ITEM_ID_LIST";
    private static final String BUY_INTENT = "BUY_INTENT";
    private static final String PURCHASE_DATA = "INAPP_PURCHASE_DATA";
    private static final String SIGNATURE = "INAPP_DATA_SIGNATURE";
    private static final String ITEM_LIST = "INAPP_PURCHASE_ITEM_LIST";
    private static final String PURCHASE_DATA_LIST = "INAPP_PURCHASE_DATA_LIST";
    private static final String SIGNATURE_LIST = "INAPP_DATA_SIGNATURE_LIST";
    private static final String CONTINUATION_TOKEN = "INAPP_CONTINUATION_TOKEN";

    @Nullable
    private static ArrayList<String> getList(@Nullable Bundle bundle, @NonNull String key) {
        if (bundle != null && bundle.containsKey(key)) {
            return bundle.getStringArrayList(key);
        }
        return null;
    }

    @NonNull
    private static Bundle putList(@NonNull Bundle bundle, @Nullable ArrayList<String> list, @NonNull String key) {
        if (list != null && !list.isEmpty()) {
            bundle.putStringArrayList(key, list);
        }
        return bundle;
    }

    @NonNull
    private static Bundle addList(@NonNull Bundle bundle, @Nullable ArrayList<String> list, @NonNull String key) {
        if (list != null && !list.isEmpty()) {
            ArrayList<String> newList;
            ArrayList<String> oldList = GoogleUtils.getList(bundle, key);
            if (oldList == null) {
                newList = list;
            } else {
                newList = new ArrayList<String>(oldList);
                newList.addAll(list);
            }
            bundle.putStringArrayList(key, newList);
        }
        return bundle;
    }

    @NonNull
    static Bundle addSkuDetails(@NonNull Bundle bundle, @Nullable ArrayList<String> skuDetailsList) {
        return GoogleUtils.addList(bundle, skuDetailsList, SKU_DETAILS_LIST);
    }

    @Nullable
    static ArrayList<String> getSkuDetails(@Nullable Bundle bundle) {
        return GoogleUtils.getList(bundle, SKU_DETAILS_LIST);
    }

    @NonNull
    static Bundle addDataList(@NonNull Bundle bundle, @Nullable ArrayList<String> purchaseData) {
        return GoogleUtils.addList(bundle, purchaseData, PURCHASE_DATA_LIST);
    }

    @Nullable
    static ArrayList<String> getDataList(@Nullable Bundle bundle) {
        return GoogleUtils.getList(bundle, PURCHASE_DATA_LIST);
    }

    @NonNull
    static Bundle addItemList(@NonNull Bundle bundle, @Nullable ArrayList<String> purchaseData) {
        return GoogleUtils.addList(bundle, purchaseData, ITEM_LIST);
    }

    @Nullable
    static ArrayList<String> getItemList(@Nullable Bundle bundle) {
        return GoogleUtils.getList(bundle, ITEM_LIST);
    }

    @NonNull
    static Bundle addSignatureList(@NonNull Bundle bundle, @Nullable ArrayList<String> purchaseData) {
        return GoogleUtils.addList(bundle, purchaseData, SIGNATURE_LIST);
    }

    @Nullable
    static ArrayList<String> getSignatureList(@Nullable Bundle bundle) {
        return GoogleUtils.getList(bundle, SIGNATURE_LIST);
    }

    @NonNull
    static Bundle putSkuList(@NonNull Bundle bundle, @Nullable ArrayList<String> skuList) {
        return GoogleUtils.putList(bundle, skuList, SKU_LIST);
    }

    @Nullable
    static Response getResponse(@Nullable Bundle bundle) {
        if (bundle != null && bundle.containsKey(RESPONSE_CODE)) {
            int responseCode = bundle.getInt(RESPONSE_CODE);
            return Response.fromCode(responseCode);
        }
        return null;
    }

    @Nullable
    static Response getResponse(@Nullable Intent intent) {
        return GoogleUtils.getResponse(intent == null ? null : intent.getExtras());
    }

    @NonNull
    static Bundle putResponse(@NonNull Bundle bundle, @NonNull Response response) {
        bundle.putInt(RESPONSE_CODE, response.code());
        return bundle;
    }

    @Nullable
    static String getContinuationToken(@Nullable Bundle bundle) {
        if (bundle != null && bundle.containsKey(CONTINUATION_TOKEN)) {
            return bundle.getString(CONTINUATION_TOKEN);
        }
        return null;
    }

    @Nullable
    static PendingIntent getBuyIntent(@Nullable Bundle bundle) {
        if (bundle != null && bundle.containsKey(BUY_INTENT)) {
            return (PendingIntent)bundle.getParcelable(BUY_INTENT);
        }
        return null;
    }

    @Nullable
    static String getPurchaseData(@Nullable Intent intent) {
        if (intent != null && intent.hasExtra(PURCHASE_DATA)) {
            return intent.getStringExtra(PURCHASE_DATA);
        }
        return null;
    }

    @Nullable
    static String getSignature(@Nullable Intent intent) {
        if (intent != null && intent.hasExtra(SIGNATURE)) {
            return intent.getStringExtra(SIGNATURE);
        }
        return null;
    }

    private GoogleUtils() {
        throw new UnsupportedOperationException();
    }
}

