/*
 * Decompiled with CFR 0.152.
 */
package org.onepf.opfiab.google.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.onepf.opfiab.google.model.GoogleModel;
import org.onepf.opfiab.google.model.PurchaseState;

public class GooglePurchase
extends GoogleModel {
    private static final String NAME_ORDER_ID = "orderId";
    private static final String NAME_PACKAGE_NAME = "packageName";
    private static final String NAME_PURCHASE_TOKEN = "purchaseToken";
    private static final String NAME_PURCHASE_STATE = "purchaseState";
    private static final String NAME_PURCHASE_TIME = "purchaseTime";
    private static final String NAME_DEVELOPER_PAYLOAD = "developerPayload";
    private static final String NAME_AUTO_RENEWING = "autoRenewing";
    @NonNull
    private final String orderId;
    @NonNull
    private final String packageName;
    @NonNull
    private final String purchaseToken;
    @NonNull
    private final PurchaseState purchaseState;
    @Nullable
    private final String developerPayload;
    private final long purchaseTime;
    private final boolean autoRenewing;

    public GooglePurchase(@NonNull String originalJson, @NonNull JSONObject jsonObject) throws JSONException {
        super(originalJson, jsonObject);
        this.orderId = jsonObject.getString(NAME_ORDER_ID);
        this.packageName = jsonObject.getString(NAME_PACKAGE_NAME);
        this.purchaseToken = jsonObject.getString(NAME_PURCHASE_TOKEN);
        this.developerPayload = jsonObject.optString(NAME_DEVELOPER_PAYLOAD, null);
        this.purchaseTime = jsonObject.getLong(NAME_PURCHASE_TIME);
        this.autoRenewing = jsonObject.optBoolean(NAME_AUTO_RENEWING, false);
        int purchaseStateCode = jsonObject.getInt(NAME_PURCHASE_STATE);
        PurchaseState purchaseState = PurchaseState.fromCode(purchaseStateCode);
        if (purchaseState == null) {
            throw new JSONException("Unrecognized purchase state: " + purchaseStateCode);
        }
        this.purchaseState = purchaseState;
    }

    public GooglePurchase(@NonNull String originalJson) throws JSONException {
        this(originalJson, new JSONObject(originalJson));
    }

    @NonNull
    public String getOrderId() {
        return this.orderId;
    }

    @NonNull
    public String getPackageName() {
        return this.packageName;
    }

    @NonNull
    public String getPurchaseToken() {
        return this.purchaseToken;
    }

    @NonNull
    public PurchaseState getPurchaseState() {
        return this.purchaseState;
    }

    @Nullable
    public String getDeveloperPayload() {
        return this.developerPayload;
    }

    public long getPurchaseTime() {
        return this.purchaseTime;
    }

    public boolean isAutoRenewing() {
        return this.autoRenewing;
    }
}

