/*
 * Decompiled with CFR 0.152.
 */
package org.onepf.opfiab.google.model;

import android.support.annotation.NonNull;
import org.json.JSONException;
import org.json.JSONObject;
import org.onepf.opfiab.google.model.GoogleModel;
import org.onepf.opfiab.google.model.ItemType;

public class GoogleSkuDetails
extends GoogleModel {
    private static final String NAME_TYPE = "type";
    private static final String NAME_PRICE = "price";
    private static final String NAME_CURRENCY = "price_currency_code";
    private static final String NAME_TITLE = "title";
    private static final String NAME_DESCRIPTION = "description";
    private static final String NAME_MICROS = "price_amount_micros";
    @NonNull
    private final ItemType itemType;
    @NonNull
    private final String price;
    @NonNull
    private final String currency;
    @NonNull
    private final String title;
    @NonNull
    private final String description;
    private final long micros;

    public GoogleSkuDetails(@NonNull String originalJson, @NonNull JSONObject jsonObject) throws JSONException {
        super(originalJson, jsonObject);
        String itemTypeCode = jsonObject.getString(NAME_TYPE);
        ItemType itemType = ItemType.fromCode(itemTypeCode);
        if (itemType == null) {
            throw new JSONException("Unrecognized itemType: " + itemTypeCode);
        }
        this.itemType = itemType;
        this.price = jsonObject.getString(NAME_PRICE);
        this.micros = jsonObject.getLong(NAME_MICROS);
        this.currency = jsonObject.getString(NAME_CURRENCY);
        this.title = jsonObject.getString(NAME_TITLE);
        this.description = jsonObject.getString(NAME_DESCRIPTION);
    }

    public GoogleSkuDetails(@NonNull String originalJson) throws JSONException {
        this(originalJson, new JSONObject(originalJson));
    }

    @NonNull
    public ItemType getItemType() {
        return this.itemType;
    }

    @NonNull
    public String getPrice() {
        return this.price;
    }

    @NonNull
    public String getCurrency() {
        return this.currency;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    public long getMicros() {
        return this.micros;
    }
}

