/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.core;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.onosproject.app.ApplicationDescription;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.ApplicationRole;
import org.onosproject.core.Version;
import org.onosproject.security.Permission;

public final class DefaultApplication
implements Application {
    private final ApplicationId appId;
    private final Version version;
    private final String title;
    private final String description;
    private final String category;
    private final String url;
    private final String readme;
    private final byte[] icon;
    private final String origin;
    private final ApplicationRole role;
    private final Set<Permission> permissions;
    private final Optional<URI> featuresRepo;
    private final List<String> features;
    private final List<String> requiredApps;

    private DefaultApplication() {
        this.appId = null;
        this.version = null;
        this.title = null;
        this.description = null;
        this.category = null;
        this.url = null;
        this.readme = null;
        this.icon = null;
        this.origin = null;
        this.role = null;
        this.permissions = null;
        this.featuresRepo = Optional.empty();
        this.features = ImmutableList.of();
        this.requiredApps = ImmutableList.of();
    }

    private DefaultApplication(ApplicationId appId, Version version, String title, String description, String origin, String category, String url, String readme, byte[] icon, ApplicationRole role, Set<Permission> permissions, Optional<URI> featuresRepo, List<String> features, List<String> requiredApps) {
        this.appId = appId;
        this.version = version;
        this.title = title;
        this.description = description;
        this.origin = origin;
        this.category = category;
        this.url = url;
        this.readme = readme;
        this.icon = icon == null ? new byte[]{} : (byte[])icon.clone();
        this.role = role;
        this.permissions = ImmutableSet.copyOf(permissions);
        this.featuresRepo = featuresRepo;
        this.features = ImmutableList.copyOf(features);
        this.requiredApps = ImmutableList.copyOf(requiredApps);
    }

    @Override
    public ApplicationId id() {
        return this.appId;
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String category() {
        return this.category;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public String readme() {
        return this.readme;
    }

    @Override
    public byte[] icon() {
        return (byte[])this.icon.clone();
    }

    @Override
    public String origin() {
        return this.origin;
    }

    @Override
    public ApplicationRole role() {
        return this.role;
    }

    @Override
    public Set<Permission> permissions() {
        return this.permissions;
    }

    @Override
    public Optional<URI> featuresRepo() {
        return this.featuresRepo;
    }

    @Override
    public List<String> features() {
        return this.features;
    }

    @Override
    public List<String> requiredApps() {
        return this.requiredApps;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appId, this.version, this.title, this.description, this.origin, this.category, this.url, this.readme, this.role, this.permissions, this.featuresRepo, this.features, this.requiredApps});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultApplication other = (DefaultApplication)obj;
        return Objects.equals(this.appId, other.appId) && Objects.equals(this.version, other.version) && Objects.equals(this.title, other.title) && Objects.equals(this.description, other.description) && Objects.equals(this.origin, other.origin) && Objects.equals(this.category, other.category) && Objects.equals(this.url, other.url) && Objects.equals(this.readme, other.readme) && Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.permissions, other.permissions) && Objects.equals(this.featuresRepo, other.featuresRepo) && Objects.equals(this.features, other.features) && Objects.equals(this.requiredApps, other.requiredApps);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("appId", (Object)this.appId).add("version", (Object)this.version).add("title", (Object)this.title).add("description", (Object)this.description).add("origin", (Object)this.origin).add("category", (Object)this.category).add("url", (Object)this.url).add("readme", (Object)this.readme).add("role", (Object)this.role).add("permissions", this.permissions).add("featuresRepo", this.featuresRepo).add("features", this.features).add("requiredApps", this.requiredApps).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Builder builder) {
        return new Builder(builder);
    }

    public static Builder builder(Application application) {
        return new Builder(application);
    }

    public static Builder builder(ApplicationDescription appDesc) {
        return new Builder(appDesc);
    }

    public static final class Builder {
        private ApplicationId appId;
        private Version version;
        private String title;
        private String description;
        private String category;
        private String url;
        private String readme;
        private byte[] icon;
        private String origin;
        private ApplicationRole role;
        private Set<Permission> permissions;
        private Optional<URI> featuresRepo;
        private List<String> features;
        private List<String> requiredApps;

        public Builder() {
        }

        public Builder(Builder builder) {
            this.appId = builder.appId;
            this.version = builder.version;
            this.title = builder.title;
            this.description = builder.description;
            this.category = builder.category;
            this.url = builder.url;
            this.readme = builder.readme;
            this.icon = builder.icon;
            this.origin = builder.origin;
            this.role = builder.role;
            this.permissions = builder.permissions;
            this.featuresRepo = builder.featuresRepo;
            this.features = builder.features;
            this.requiredApps = builder.requiredApps;
        }

        public Builder(Application application) {
            this.appId = application.id();
            this.version = application.version();
            this.title = application.title();
            this.description = application.description();
            this.category = application.category();
            this.url = application.url();
            this.readme = application.readme();
            this.icon = application.icon();
            this.origin = application.origin();
            this.role = application.role();
            this.permissions = application.permissions();
            this.featuresRepo = application.featuresRepo();
            this.features = application.features();
            this.requiredApps = application.requiredApps();
        }

        public Builder(ApplicationDescription appDesc) {
            this.version = appDesc.version();
            this.title = appDesc.title();
            this.description = appDesc.description();
            this.category = appDesc.category();
            this.url = appDesc.url();
            this.readme = appDesc.readme();
            this.icon = appDesc.icon();
            this.origin = appDesc.origin();
            this.role = appDesc.role();
            this.permissions = appDesc.permissions();
            this.featuresRepo = appDesc.featuresRepo();
            this.features = appDesc.features();
            this.requiredApps = appDesc.requiredApps();
        }

        public Builder withAppId(ApplicationId appId) {
            this.appId = appId;
            return this;
        }

        public Builder withVersion(Version version) {
            this.version = version;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withReadme(String readme) {
            this.readme = readme;
            return this;
        }

        public Builder withIcon(byte[] icon) {
            this.icon = icon;
            return this;
        }

        public Builder withOrigin(String origin) {
            this.origin = origin;
            return this;
        }

        public Builder withRole(ApplicationRole role) {
            this.role = role;
            return this;
        }

        public Builder withPermissions(Set<Permission> permissions) {
            this.permissions = permissions;
            return this;
        }

        public Builder withFeaturesRepo(Optional<URI> featuresRepo) {
            this.featuresRepo = featuresRepo;
            return this;
        }

        public Builder withFeatures(List<String> features) {
            this.features = features;
            return this;
        }

        public Builder withRequiredApps(List<String> requiredApps) {
            this.requiredApps = requiredApps;
            return this;
        }

        public DefaultApplication build() {
            Preconditions.checkNotNull((Object)this.appId, (Object)"ID cannot be null");
            Preconditions.checkNotNull((Object)this.version, (Object)"Version cannot be null");
            Preconditions.checkNotNull((Object)this.title, (Object)"Title cannot be null");
            Preconditions.checkNotNull((Object)this.description, (Object)"Description cannot be null");
            Preconditions.checkNotNull((Object)this.origin, (Object)"Origin cannot be null");
            Preconditions.checkNotNull((Object)this.category, (Object)"Category cannot be null");
            Preconditions.checkNotNull((Object)this.readme, (Object)"Readme cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.role), (Object)"Role cannot be null");
            Preconditions.checkNotNull(this.permissions, (Object)"Permissions cannot be null");
            Preconditions.checkNotNull(this.featuresRepo, (Object)"Features repo cannot be null");
            Preconditions.checkNotNull(this.features, (Object)"Features cannot be null");
            Preconditions.checkNotNull(this.requiredApps, (Object)"Required apps cannot be null");
            Preconditions.checkArgument((!this.features.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one feature");
            return new DefaultApplication(this.appId, this.version, this.title, this.description, this.origin, this.category, this.url, this.readme, this.icon, this.role, this.permissions, this.featuresRepo, this.features, this.requiredApps);
        }
    }
}

