/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.DscpClass;
import org.onlab.packet.IPPrecedence;

@Beta
public final class BandwidthProfileAction {
    private final Action action;
    private final DscpClass dscpClass;
    private final IPPrecedence ipPrecedence;
    private final Short dropPrecedence;

    private BandwidthProfileAction(Action action, DscpClass dscpClass, IPPrecedence ipPrecedence, Short dropPrecedence) {
        this.action = action;
        this.dscpClass = dscpClass;
        this.ipPrecedence = ipPrecedence;
        this.dropPrecedence = dropPrecedence;
    }

    public Action getAction() {
        return this.action;
    }

    public DscpClass getDscpClass() {
        return this.dscpClass;
    }

    public IPPrecedence getIpPrecedence() {
        return this.ipPrecedence;
    }

    public Short getDropPrecedence() {
        return this.dropPrecedence;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.dscpClass, this.ipPrecedence, this.dropPrecedence});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BandwidthProfileAction) {
            BandwidthProfileAction that = (BandwidthProfileAction)obj;
            return this.getClass() == that.getClass() && Objects.equals((Object)this.action, (Object)that.action) && Objects.equals(this.dscpClass, that.dscpClass) && Objects.equals(this.ipPrecedence, that.ipPrecedence) && Objects.equals(this.dropPrecedence, that.dropPrecedence);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("action", this.action == null ? null : this.action.name()).add("dscpClass", this.dscpClass == null ? null : this.dscpClass.name()).add("ipPrecedence", (Object)this.ipPrecedence).add("dropPrecedence", (Object)this.dropPrecedence).toString();
    }

    public static final class Builder {
        private Action action;
        private DscpClass dscpClass;
        private IPPrecedence ipPrecedence;
        private Short dropPrecedence;

        public Builder action(Action action) {
            this.action = action;
            return this;
        }

        public Builder dscpClass(DscpClass dscpClass) {
            this.dscpClass = dscpClass;
            return this;
        }

        public Builder ipPrecedence(IPPrecedence ipPrecedence) {
            this.ipPrecedence = ipPrecedence;
            return this;
        }

        public Builder dropPrecedence(Short dropPrecedence) {
            this.dropPrecedence = dropPrecedence;
            return this;
        }

        public BandwidthProfileAction build() {
            Preconditions.checkNotNull((Object)((Object)this.action));
            Preconditions.checkArgument((!this.action.equals((Object)Action.REMARK) || this.dscpClass != null ^ this.ipPrecedence != null ^ this.dropPrecedence != null ? 1 : 0) != 0, (Object)"Exactly one remark type must be defined");
            return new BandwidthProfileAction(this.action, this.dscpClass, this.ipPrecedence, this.dropPrecedence);
        }
    }

    public static enum Action {
        PASS,
        REMARK,
        DISCARD;

    }
}

