/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onosproject.net.Annotated;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;

public class ControllerInfo
implements Annotated {
    private IpAddress ip = IpAddress.valueOf((String)"0.0.0.0");
    private int port = 6653;
    private String type = "error";
    private final Annotations annotations;

    public ControllerInfo(IpAddress ip, int port, String type) {
        this(ip, port, type, DefaultAnnotations.EMPTY);
    }

    public ControllerInfo(IpAddress ip, int port, String type, Annotations annotations) {
        this.ip = (IpAddress)Preconditions.checkNotNull((Object)ip);
        this.port = port;
        this.type = (String)Preconditions.checkNotNull((Object)type);
        this.annotations = (Annotations)Preconditions.checkNotNull((Object)annotations);
    }

    @Deprecated
    public ControllerInfo(String target) {
        String[] data = target.split(":");
        this.type = data[0];
        Preconditions.checkArgument((!data[0].contains("unix") ? 1 : 0) != 0, (String)"Unable to create controller info from {} because it's based on unix sockets", (Object)target);
        if (data[0].startsWith("p")) {
            if (data.length >= 2) {
                this.port = Integer.parseInt(data[1]);
            }
            if (data.length == 3) {
                this.ip = IpAddress.valueOf((String)data[2]);
            }
        } else {
            this.ip = IpAddress.valueOf((String)data[1]);
            if (data.length == 3) {
                this.port = Integer.parseInt(data[2]);
            }
        }
        this.annotations = DefaultAnnotations.EMPTY;
    }

    public IpAddress ip() {
        return this.ip;
    }

    public int port() {
        return this.port;
    }

    public String type() {
        return this.type;
    }

    @Override
    public Annotations annotations() {
        return this.annotations;
    }

    @Deprecated
    public String target() {
        if (this.type.startsWith("p")) {
            return this.type + ":" + this.port + ":" + this.ip;
        }
        if (this.annotations.equals(DefaultAnnotations.EMPTY)) {
            return this.type + ":" + this.ip + ":" + this.port;
        }
        return this.type + ":" + this.ip + ":" + this.port + ":" + this.annotations.toString();
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.port, this.type);
    }

    public boolean equals(Object toBeCompared) {
        if (toBeCompared instanceof ControllerInfo) {
            ControllerInfo that = (ControllerInfo)toBeCompared;
            return Objects.equals(this.type, that.type) && Objects.equals(this.ip, that.ip) && Objects.equals(this.port, that.port);
        }
        return false;
    }
}

