/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.google.common.annotations.Beta;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.config.Config;

@Beta
public class McastConfig
extends Config<ApplicationId> {
    private static final String INGRESS_VLAN = "ingressVlan";
    private static final String EGRESS_VLAN = "egressVlan";

    @Override
    public boolean isValid() {
        return this.hasOnlyFields(INGRESS_VLAN, EGRESS_VLAN) && this.ingressVlan() != null && this.egressVlan() != null;
    }

    public VlanId ingressVlan() {
        if (!this.object.has(INGRESS_VLAN)) {
            return VlanId.NONE;
        }
        try {
            return VlanId.vlanId((String)this.object.path(INGRESS_VLAN).asText());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public McastConfig setIngressVlan(VlanId vlanId) {
        if (vlanId == null) {
            this.object.remove(INGRESS_VLAN);
        } else {
            this.object.put(INGRESS_VLAN, vlanId.toString());
        }
        return this;
    }

    public VlanId egressVlan() {
        if (!this.object.has(EGRESS_VLAN)) {
            return VlanId.NONE;
        }
        try {
            return VlanId.vlanId((String)this.object.path(EGRESS_VLAN).asText());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public McastConfig setEgressVlan(VlanId vlanId) {
        if (vlanId == null) {
            this.object.remove(EGRESS_VLAN);
        } else {
            this.object.put(EGRESS_VLAN, vlanId.toString());
        }
        return this;
    }
}

