/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class IPv6FlowLabelCriterion
implements Criterion {
    private static final int MASK = 1048575;
    private final int flowLabel;

    IPv6FlowLabelCriterion(int flowLabel) {
        this.flowLabel = flowLabel & 0xFFFFF;
    }

    @Override
    public Criterion.Type type() {
        return Criterion.Type.IPV6_FLABEL;
    }

    public int flowLabel() {
        return this.flowLabel;
    }

    public String toString() {
        return this.type().toString() + ":" + Long.toHexString(this.flowLabel);
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.flowLabel);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IPv6FlowLabelCriterion) {
            IPv6FlowLabelCriterion that = (IPv6FlowLabelCriterion)obj;
            return Objects.equals(this.flowLabel, that.flowLabel) && Objects.equals((Object)this.type(), (Object)that.type());
        }
        return false;
    }
}

