/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;

@Beta
public final class DefaultFilteringObjective
implements FilteringObjective {
    private final FilteringObjective.Type type;
    private final boolean permanent;
    private final int timeout;
    private final ApplicationId appId;
    private final int priority;
    private final Criterion key;
    private final List<Criterion> conditions;
    private final int id;
    private final Objective.Operation op;
    private final Optional<ObjectiveContext> context;
    private final TrafficTreatment meta;

    private DefaultFilteringObjective(Builder builder) {
        this.key = builder.key;
        this.type = builder.type;
        this.permanent = builder.permanent;
        this.timeout = builder.timeout;
        this.appId = builder.appId;
        this.priority = builder.priority;
        this.conditions = builder.conditions;
        this.op = builder.op;
        this.context = Optional.ofNullable(builder.context);
        this.meta = builder.meta;
        this.id = Objects.hash(new Object[]{this.type, this.key, this.conditions, this.permanent, this.timeout, this.appId, this.priority});
    }

    @Override
    public Criterion key() {
        return this.key;
    }

    @Override
    public FilteringObjective.Type type() {
        return this.type;
    }

    @Override
    public Collection<Criterion> conditions() {
        return this.conditions;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public TrafficTreatment meta() {
        return this.meta;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public ApplicationId appId() {
        return this.appId;
    }

    @Override
    public int timeout() {
        return this.timeout;
    }

    @Override
    public boolean permanent() {
        return this.permanent;
    }

    @Override
    public Objective.Operation op() {
        return this.op;
    }

    @Override
    public Optional<ObjectiveContext> context() {
        return this.context;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.permanent, this.timeout, this.appId, this.priority, this.key, this.conditions, this.op, this.meta});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultFilteringObjective) {
            DefaultFilteringObjective other = (DefaultFilteringObjective)obj;
            return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.permanent, other.permanent) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.appId, other.appId) && Objects.equals(this.priority, other.priority) && Objects.equals(this.key, other.key) && Objects.equals(this.conditions, other.conditions) && Objects.equals((Object)this.op, (Object)other.op) && Objects.equals(this.meta, other.meta);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id()).add("type", (Object)this.type()).add("op", (Object)this.op()).add("priority", this.priority()).add("key", (Object)this.key()).add("conditions", this.conditions()).add("meta", (Object)this.meta()).add("appId", (Object)this.appId()).add("permanent", this.permanent()).add("timeout", this.timeout()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    public static final class Builder
    implements FilteringObjective.Builder {
        private final ImmutableList.Builder<Criterion> listBuilder = ImmutableList.builder();
        private FilteringObjective.Type type;
        private boolean permanent = true;
        private int timeout = 0;
        private ApplicationId appId;
        private int priority = 32768;
        private Criterion key = Criteria.dummy();
        private List<Criterion> conditions;
        private Objective.Operation op;
        private ObjectiveContext context;
        private TrafficTreatment meta;

        private Builder() {
        }

        private Builder(FilteringObjective objective) {
            this.type = objective.type();
            this.key = objective.key();
            objective.conditions().forEach(this::addCondition);
            this.permanent = objective.permanent();
            this.timeout = objective.timeout();
            this.priority = objective.priority();
            this.appId = objective.appId();
            this.meta = objective.meta();
            this.op = objective.op();
        }

        @Override
        public Builder withKey(Criterion key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder addCondition(Criterion criterion) {
            this.listBuilder.add((Object)criterion);
            return this;
        }

        @Override
        public Builder permit() {
            this.type = FilteringObjective.Type.PERMIT;
            return this;
        }

        @Override
        public Builder deny() {
            this.type = FilteringObjective.Type.DENY;
            return this;
        }

        @Override
        public Builder makeTemporary(int timeout) {
            this.timeout = timeout;
            this.permanent = false;
            return this;
        }

        @Override
        public Builder makePermanent() {
            this.permanent = true;
            return this;
        }

        @Override
        public Builder fromApp(ApplicationId appId) {
            this.appId = appId;
            return this;
        }

        @Override
        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public Builder withMeta(TrafficTreatment treatment) {
            this.meta = treatment;
            return this;
        }

        @Override
        public FilteringObjective add() {
            this.conditions = this.listBuilder.build();
            this.op = Objective.Operation.ADD;
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"Must have a type.");
            Preconditions.checkArgument((!this.conditions.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one condition.");
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            Preconditions.checkArgument((this.priority <= 65535 && this.priority >= 0 ? 1 : 0) != 0, (Object)"Priority out of range");
            return new DefaultFilteringObjective(this);
        }

        @Override
        public FilteringObjective remove() {
            this.conditions = this.listBuilder.build();
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"Must have a type.");
            Preconditions.checkArgument((!this.conditions.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one condition.");
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            this.op = Objective.Operation.REMOVE;
            return new DefaultFilteringObjective(this);
        }

        @Override
        public FilteringObjective add(ObjectiveContext context) {
            this.conditions = this.listBuilder.build();
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"Must have a type.");
            Preconditions.checkArgument((!this.conditions.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one condition.");
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            this.op = Objective.Operation.ADD;
            this.context = context;
            return new DefaultFilteringObjective(this);
        }

        @Override
        public FilteringObjective remove(ObjectiveContext context) {
            this.conditions = this.listBuilder.build();
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"Must have a type.");
            Preconditions.checkArgument((!this.conditions.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one condition.");
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            this.op = Objective.Operation.REMOVE;
            this.context = context;
            return new DefaultFilteringObjective(this);
        }
    }
}

