/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiMatchFieldId;
import org.onosproject.net.pi.model.PiMatchType;
import org.onosproject.net.pi.runtime.PiFieldMatch;

@Beta
public final class PiLpmFieldMatch
extends PiFieldMatch {
    private final ImmutableByteSequence value;
    private final int prefixLength;

    public PiLpmFieldMatch(PiMatchFieldId fieldId, ImmutableByteSequence value, int prefixLength) {
        super(fieldId);
        this.value = (ImmutableByteSequence)Preconditions.checkNotNull((Object)value);
        this.prefixLength = prefixLength;
        Preconditions.checkArgument((value.size() > 0 ? 1 : 0) != 0, (Object)"Value must have non-zero size");
        Preconditions.checkArgument((prefixLength >= 0 ? 1 : 0) != 0, (Object)"Prefix length must be a non-negative integer");
    }

    @Override
    public PiMatchType type() {
        return PiMatchType.LPM;
    }

    public ImmutableByteSequence value() {
        return this.value;
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiLpmFieldMatch that = (PiLpmFieldMatch)o;
        return this.prefixLength == that.prefixLength && Objects.equal((Object)this.value, (Object)that.value) && Objects.equal((Object)((Object)this.fieldId()), (Object)((Object)that.fieldId()));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fieldId(), this.value, this.prefixLength});
    }

    public String toString() {
        return this.fieldId().toString() + '=' + this.value.toString() + '/' + String.valueOf(this.prefixLength);
    }
}

