/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiMeterBand;
import org.onosproject.net.pi.runtime.PiMeterCellId;

@Beta
public final class PiMeterCellConfig
implements PiEntity {
    private final PiMeterCellId cellId;
    private final ImmutableList<PiMeterBand> piMeterBands;

    private PiMeterCellConfig(PiMeterCellId cellId, Collection<PiMeterBand> piMeterBands) {
        this.cellId = cellId;
        this.piMeterBands = ImmutableList.copyOf(piMeterBands);
    }

    public PiMeterCellId cellId() {
        return this.cellId;
    }

    public Collection<PiMeterBand> meterBands() {
        return this.piMeterBands;
    }

    @Override
    public PiEntityType piEntityType() {
        return PiEntityType.METER_CELL_CONFIG;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PiMeterCellConfig)) {
            return false;
        }
        PiMeterCellConfig that = (PiMeterCellConfig)o;
        return this.piMeterBands.containsAll(that.piMeterBands) && this.piMeterBands.size() == that.piMeterBands.size() && Objects.equal((Object)this.cellId, (Object)that.cellId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.cellId, this.piMeterBands});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cellId", (Object)this.cellId).add("meterBands", this.piMeterBands).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PiMeterCellId cellId;
        private List<PiMeterBand> bands = new ArrayList<PiMeterBand>();

        private Builder() {
        }

        public Builder withMeterCellId(PiMeterCellId meterCellId) {
            this.cellId = meterCellId;
            return this;
        }

        public Builder withMeterBand(PiMeterBand band) {
            this.bands.add(band);
            return this;
        }

        public PiMeterCellConfig build() {
            Preconditions.checkNotNull((Object)this.cellId);
            return new PiMeterCellConfig(this.cellId, this.bands);
        }
    }
}

