/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.pi.model.PiData;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiRegisterCellId;

@Beta
public final class PiRegisterCell
implements PiEntity {
    private final PiRegisterCellId registerCellId;
    private final PiData piData;

    private PiRegisterCell(PiRegisterCellId registerCellId, PiData piData) {
        this.registerCellId = registerCellId;
        this.piData = piData;
    }

    public PiRegisterCellId cellId() {
        return this.registerCellId;
    }

    public PiData data() {
        return this.piData;
    }

    @Override
    public PiEntityType piEntityType() {
        return PiEntityType.REGISTER_CELL;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PiRegisterCell other = (PiRegisterCell)obj;
        return Objects.equal((Object)this.registerCellId, (Object)other.registerCellId) && Objects.equal((Object)this.piData, (Object)other.piData);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.registerCellId, this.piData});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cellId", (Object)this.registerCellId).add("piData", (Object)this.piData).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PiRegisterCellId cellId;
        private PiData piData;

        private Builder() {
        }

        public Builder withCellId(PiRegisterCellId registerCellId) {
            this.cellId = registerCellId;
            return this;
        }

        public Builder withData(PiData data) {
            this.piData = data;
            return this;
        }

        public PiRegisterCell build() {
            Preconditions.checkNotNull((Object)this.cellId);
            return new PiRegisterCell(this.cellId, this.piData);
        }
    }
}

