/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.net.resource.ContinuousResource;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceId;
import org.onosproject.net.resource.Resources;

@Beta
public final class DiscreteResource
implements Resource {
    private final DiscreteResourceId id;

    DiscreteResource(DiscreteResourceId id) {
        this.id = id;
    }

    DiscreteResource() {
        this.id = ResourceId.ROOT;
    }

    @Override
    public DiscreteResourceId id() {
        return this.id;
    }

    @Override
    public String simpleTypeName() {
        return this.id.simpleTypeName();
    }

    @Override
    public boolean isTypeOf(Class<?> type) {
        Preconditions.checkNotNull(type);
        return this.id.isTypeOf(type);
    }

    @Override
    public boolean isSubTypeOf(Class<?> ancestor) {
        Preconditions.checkNotNull(ancestor);
        return this.id.isSubTypeOf(ancestor);
    }

    @Override
    public <T> Optional<T> valueAs(Class<T> type) {
        Preconditions.checkNotNull(type);
        return this.id.lastComponentAs(type);
    }

    @Override
    public DiscreteResource child(Object child) {
        Preconditions.checkArgument((!(child instanceof Class) ? 1 : 0) != 0);
        return Resources.discrete(this.id.child(child)).resource();
    }

    @Override
    public ContinuousResource child(Class<?> child, double value) {
        return Resources.continuous(this.id.child(child)).resource(value);
    }

    @Override
    public Optional<DiscreteResource> parent() {
        return this.id.parent().map(x -> Resources.discrete(x).resource());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DiscreteResource other = (DiscreteResource)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }
}

