/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.onosproject.store.service.AsyncAtomicCounter;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.StorageException;
import org.onosproject.store.service.Synchronous;

public class DefaultAtomicCounter
extends Synchronous<AsyncAtomicCounter>
implements AtomicCounter {
    private final AsyncAtomicCounter asyncCounter;
    private final long operationTimeoutMillis;

    public DefaultAtomicCounter(AsyncAtomicCounter asyncCounter, long operationTimeoutMillis) {
        super(asyncCounter);
        this.asyncCounter = asyncCounter;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public long incrementAndGet() {
        return this.complete(this.asyncCounter.incrementAndGet());
    }

    @Override
    public long getAndIncrement() {
        return this.complete(this.asyncCounter.getAndIncrement());
    }

    @Override
    public long getAndAdd(long delta) {
        return this.complete(this.asyncCounter.getAndAdd(delta));
    }

    @Override
    public long addAndGet(long delta) {
        return this.complete(this.asyncCounter.addAndGet(delta));
    }

    @Override
    public void set(long value) {
        this.complete(this.asyncCounter.set(value));
    }

    @Override
    public boolean compareAndSet(long expectedValue, long updateValue) {
        return this.complete(this.asyncCounter.compareAndSet(expectedValue, updateValue));
    }

    @Override
    public long get() {
        return this.complete(this.asyncCounter.get());
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StorageException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new StorageException.Timeout();
        }
        catch (ExecutionException e) {
            throw new StorageException(e.getCause());
        }
    }
}

