/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.model.topo.UiNode;
import org.onosproject.ui.model.topo.UiTopology;

public class UiHost
extends UiNode {
    private static final String HOST_CANNOT_BE_NULL = "Host cannot be null";
    private final UiTopology topology;
    private final HostId hostId;
    private DeviceId locDevice;
    private PortNumber locPort;
    private UiLinkId edgeLinkId;
    private RegionId regionId;

    public UiHost(UiTopology topology, Host host) {
        Preconditions.checkNotNull((Object)host, (Object)HOST_CANNOT_BE_NULL);
        this.topology = topology;
        this.hostId = host.id();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("dev", (Object)this.locDevice).add("port", (Object)this.locPort).toString();
    }

    public HostId id() {
        return this.hostId;
    }

    public void setRegionId(RegionId regionId) {
        this.regionId = regionId;
    }

    @Override
    public String idAsString() {
        return this.id().toString();
    }

    public void setLocation(DeviceId deviceId, PortNumber port) {
        this.locDevice = deviceId;
        this.locPort = port;
    }

    public void setEdgeLinkId(UiLinkId id) {
        this.edgeLinkId = id;
    }

    public Host backingHost() {
        return this.topology.services.host().getHost(this.hostId);
    }

    public UiLinkId edgeLinkId() {
        return this.edgeLinkId;
    }

    public DeviceId locationDevice() {
        return this.locDevice;
    }

    public PortNumber locationPort() {
        return this.locPort;
    }
}

