/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import com.google.common.base.Preconditions;
import java.text.DecimalFormat;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;

public final class TopoUtils {
    public static final double N_KILO = 1024.0;
    public static final double N_MEGA = 1048576.0;
    public static final double N_GIGA = 1.073741824E9;
    public static final String BITS_UNIT = "b";
    public static final String BYTES_UNIT = "B";
    public static final String PACKETS_UNIT = "p";
    private static final DecimalFormat DF2 = new DecimalFormat("#,###.##");
    private static final String COMPACT = "%s/%s-%s/%s";
    private static final String EMPTY = "";
    private static final String SPACE = " ";
    private static final String FLOW = "flow";
    private static final String FLOWS = "flows";

    private TopoUtils() {
    }

    public static String compactLinkString(Link link) {
        return String.format(COMPACT, link.src().elementId(), link.src().port(), link.dst().elementId(), link.dst().port());
    }

    public static LinkKey canonicalLinkKey(Link link) {
        String dn;
        String sn = link.src().elementId().toString();
        return sn.compareTo(dn = link.dst().elementId().toString()) < 0 ? LinkKey.linkKey(link.src(), link.dst()) : LinkKey.linkKey(link.dst(), link.src());
    }

    public static ValueLabel formatBytes(long bytes) {
        return new ValueLabel(bytes, BYTES_UNIT);
    }

    public static ValueLabel formatPacketRate(long packets) {
        return new ValueLabel(packets, PACKETS_UNIT).perSec();
    }

    public static ValueLabel formatClippedBitRate(long bytes) {
        return new ValueLabel(bytes * 8L, BITS_UNIT).perSec().clipG(100.0);
    }

    public static String formatFlows(long flows) {
        if (flows < 1L) {
            return EMPTY;
        }
        return String.valueOf(flows) + SPACE + (flows > 1L ? FLOWS : FLOW);
    }

    public static class ValueLabel {
        private final long value;
        private final String unit;
        private double divDown;
        private Magnitude mag;
        private boolean perSec = false;
        private boolean clipped = false;

        public ValueLabel(long value, String unit) {
            this.value = value;
            this.unit = unit;
            this.computeAdjusted();
        }

        private void computeAdjusted() {
            if ((double)this.value >= 1.073741824E9) {
                this.divDown = (double)this.value / 1.073741824E9;
                this.mag = Magnitude.GIGA;
            } else if ((double)this.value >= 1048576.0) {
                this.divDown = (double)this.value / 1048576.0;
                this.mag = Magnitude.MEGA;
            } else if ((double)this.value >= 1024.0) {
                this.divDown = (double)this.value / 1024.0;
                this.mag = Magnitude.KILO;
            } else {
                this.divDown = this.value;
                this.mag = Magnitude.ONE;
            }
        }

        public ValueLabel perSec() {
            this.perSec = true;
            return this;
        }

        public ValueLabel clipG(double threshold) {
            return this.clip(threshold, Magnitude.GIGA);
        }

        private ValueLabel clip(double threshold, Magnitude m) {
            Preconditions.checkArgument((threshold >= 1.0 ? 1 : 0) != 0, (Object)"threshold must be 1.0 or more");
            double clipAt = threshold * m.mult();
            if ((double)this.value > clipAt) {
                this.divDown = threshold;
                this.mag = m;
                this.clipped = true;
            }
            return this;
        }

        public boolean clipped() {
            return this.clipped;
        }

        public Magnitude magnitude() {
            return this.mag;
        }

        public String toString() {
            return DF2.format(this.divDown) + TopoUtils.SPACE + (Object)((Object)this.mag) + this.unit + (this.perSec ? "ps" : TopoUtils.EMPTY);
        }
    }

    public static enum Magnitude {
        ONE("", 1.0),
        KILO("K", 1024.0),
        MEGA("M", 1048576.0),
        GIGA("G", 1.073741824E9);

        private final String label;
        private final double mult;

        private Magnitude(String label, double mult) {
            this.label = label;
            this.mult = mult;
        }

        public String toString() {
            return this.label;
        }

        private double mult() {
            return this.mult;
        }
    }
}

