/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstackinterface.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.net.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ip4Address;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.Port;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.openstackinterface.OpenstackFloatingIP;
import org.onosproject.openstackinterface.OpenstackInterfaceConfig;
import org.onosproject.openstackinterface.OpenstackInterfaceService;
import org.onosproject.openstackinterface.OpenstackNetwork;
import org.onosproject.openstackinterface.OpenstackPort;
import org.onosproject.openstackinterface.OpenstackRouter;
import org.onosproject.openstackinterface.OpenstackSecurityGroup;
import org.onosproject.openstackinterface.OpenstackSubnet;
import org.onosproject.openstackinterface.web.OpenstackFloatingIpCodec;
import org.onosproject.openstackinterface.web.OpenstackNetworkCodec;
import org.onosproject.openstackinterface.web.OpenstackPortCodec;
import org.onosproject.openstackinterface.web.OpenstackRouterCodec;
import org.onosproject.openstackinterface.web.OpenstackSecurityGroupCodec;
import org.onosproject.openstackinterface.web.OpenstackSubnetCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class OpenstackInterfaceManager
implements OpenstackInterfaceService {
    private static final String URI_NETWORKS = "networks";
    private static final String URI_PORTS = "ports";
    private static final String URI_SUBNETS = "subnets";
    private static final String URI_SECURITY_GROUPS = "security-groups";
    private static final String URI_FLOATINGIPS = "floatingips";
    private static final String URI_TOKENS = "tokens";
    private static final String FLOATINGIP = "floatingip";
    private static final String PORT_ID = "port_id";
    private static final String FIXED_IP_ADDRESS = "fixed_ip_address";
    private static final String PATH_ROUTERS = "routers";
    private static final String PATH_NETWORKS = "networks";
    private static final String PATH_PORTS = "ports";
    private static final String PATH_SUBNETS = "subnets";
    private static final String PATH_FLOATINGIPS = "floatingips";
    private static final String PATH_ACCESS = "access";
    private static final String PATH_TOKEN = "token";
    private static final String PATH_ID = "id";
    private static final String PATH_EXPIRES = "expires";
    private static final String HEADER_AUTH_TOKEN = "X-Auth-Token";
    private static final String TOKEN_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final int DEFAULT_TIMEOUT_MS = 2000;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Client client = ClientBuilder.newClient();
    private String neutronUrl;
    private String keystoneUrl;
    private String tokenId;
    private String tokenExpires;
    private String userName;
    private String pass;
    private ApplicationId appId;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry cfgService;
    private InternalConfigListener internalConfigListener = new InternalConfigListener();
    private ExecutorService networkEventExcutorService = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/openstackinterface", (String)"config-event", (Logger)this.log));
    private final Set<ConfigFactory> factories = ImmutableSet.of((Object)new ConfigFactory<ApplicationId, OpenstackInterfaceConfig>(SubjectFactories.APP_SUBJECT_FACTORY, OpenstackInterfaceConfig.class, "openstackinterface"){

        public OpenstackInterfaceConfig createConfig() {
            return new OpenstackInterfaceConfig();
        }
    });

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.openstackinterface");
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgService).registerConfigFactory(arg_0));
        this.cfgService.addListener((EventListener)this.internalConfigListener);
        this.client.property("jersey.config.client.connectTimeout", (Object)2000);
        this.client.property("jersey.config.client.readTimeout", (Object)2000);
        this.configureNetwork();
        this.log.info("started");
    }

    @Deactivate
    protected void deactivate() {
        this.cfgService.removeListener((EventListener)this.internalConfigListener);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgService).unregisterConfigFactory(arg_0));
        this.log.info("stopped");
    }

    public Collection<OpenstackNetwork> getNetworks() {
        Invocation.Builder builder = this.getClientBuilder(this.neutronUrl, "networks");
        if (builder == null) {
            this.log.warn("Failed to get networks");
            return Collections.EMPTY_LIST;
        }
        String response = (String)builder.accept(new javax.ws.rs.core.MediaType[]{javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE}).header(HEADER_AUTH_TOKEN, (Object)this.getToken()).get(String.class);
        this.log.debug("networks response:" + response);
        ObjectMapper mapper = new ObjectMapper();
        ArrayList openstackNetworks = Lists.newArrayList();
        try {
            ObjectNode node = (ObjectNode)mapper.readTree(response);
            ArrayNode networkList = (ArrayNode)node.path("networks");
            OpenstackNetworkCodec networkCodec = new OpenstackNetworkCodec();
            networkList.forEach(n -> openstackNetworks.add(networkCodec.decode((ObjectNode)n, null)));
        }
        catch (IOException e) {
            this.log.warn("getNetworks()", (Throwable)e);
        }
        openstackNetworks.removeAll(Collections.singleton(null));
        openstackNetworks.forEach(n -> this.log.debug("network ID: {}", (Object)n.id()));
        return openstackNetworks;
    }

    public Collection<OpenstackPort> getPorts() {
        Invocation.Builder builder = this.getClientBuilder(this.neutronUrl, "ports");
        if (builder == null) {
            this.log.warn("Failed to get ports");
            return Collections.EMPTY_LIST;
        }
        String response = (String)builder.accept(new javax.ws.rs.core.MediaType[]{javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE}).header(HEADER_AUTH_TOKEN, (Object)this.getToken()).get(String.class);
        ObjectMapper mapper = new ObjectMapper();
        ArrayList openstackPorts = Lists.newArrayList();
        try {
            ObjectNode node = (ObjectNode)mapper.readTree(response);
            ArrayNode portList = (ArrayNode)node.path("ports");
            OpenstackPortCodec portCodec = new OpenstackPortCodec();
            portList.forEach(p -> openstackPorts.add(portCodec.decode((ObjectNode)p, null)));
        }
        catch (IOException e) {
            this.log.warn("getPorts()", (Throwable)e);
        }
        this.log.debug("port response:" + response);
        openstackPorts.forEach(n -> this.log.debug("port ID: {}", (Object)n.id()));
        return openstackPorts;
    }

    public Collection<OpenstackRouter> getRouters() {
        Invocation.Builder builder = this.getClientBuilder(this.neutronUrl, PATH_ROUTERS);
        if (builder == null) {
            this.log.warn("Failed to get routers");
            return Collections.EMPTY_LIST;
        }
        String response = (String)builder.accept(new javax.ws.rs.core.MediaType[]{javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE}).header(HEADER_AUTH_TOKEN, (Object)this.getToken()).get(String.class);
        ObjectMapper mapper = new ObjectMapper();
        ArrayList openstackRouters = Lists.newArrayList();
        try {
            ObjectNode node = (ObjectNode)mapper.readTree(response);
            ArrayNode routerList = (ArrayNode)node.path(PATH_ROUTERS);
            OpenstackRouterCodec openstackRouterCodec = new OpenstackRouterCodec();
            routerList.forEach(r -> openstackRouters.add(openstackRouterCodec.decode((ObjectNode)r, null)));
        }
        catch (IOException e) {
            this.log.warn("getRouters()", (Throwable)e);
        }
        this.log.debug("router response:" + response);
        openstackRouters.forEach(r -> this.log.debug("router ID: {}", (Object)r.id()));
        return openstackRouters;
    }

    public Collection<OpenstackSubnet> getSubnets() {
        Invocation.Builder builder = this.getClientBuilder(this.neutronUrl, "subnets");
        if (builder == null) {
            this.log.warn("Failed to get subnets");
            return Collections.EMPTY_LIST;
        }
        String response = (String)builder.accept(new javax.ws.rs.core.MediaType[]{javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE}).header(HEADER_AUTH_TOKEN, (Object)this.getToken()).get(String.class);
        ObjectMapper mapper = new ObjectMapper();
        ArrayList subnets = Lists.newArrayList();
        try {
            ObjectNode node = (ObjectNode)mapper.readTree(response);
            ArrayNode subnetList = (ArrayNode)node.path("subnets");
            OpenstackSubnetCodec subnetCodec = new OpenstackSubnetCodec();
            subnetList.forEach(s -> subnets.add(subnetCodec.decode((ObjectNode)s, null)));
        }
        catch (IOException e) {
            this.log.warn("getSubnets()", (Throwable)e);
        }
        this.log.debug("subnets response:" + response);
        subnets.forEach(s -> this.log.debug("subnet ID: {}", (Object)s.id()));
        return subnets;
    }

    public OpenstackSecurityGroup securityGroup(String id) {
        Invocation.Builder builder = this.getClientBuilder(this.neutronUrl, "security-groups/" + id);
        if (builder == null) {
            this.log.warn("Failed to get security group {}", (Object)id);
            return null;
        }
        String response = (String)builder.accept(new javax.ws.rs.core.MediaType[]{javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE}).header(HEADER_AUTH_TOKEN, (Object)this.getToken()).get(String.class);
        ObjectMapper mapper = new ObjectMapper();
        OpenstackSecurityGroup securityGroup = null;
        try {
            ObjectNode node = (ObjectNode)mapper.readTree(response);
            OpenstackSecurityGroupCodec sgCodec = new OpenstackSecurityGroupCodec();
            securityGroup = sgCodec.decode(node, null);
        }
        catch (IOException e) {
            this.log.warn("securityGroup()", (Throwable)e);
        }
        return securityGroup;
    }

    private Invocation.Builder getClientBuilder(String baseUrl, String path) {
        if (Strings.isNullOrEmpty((String)baseUrl)) {
            this.log.warn("Keystone or Neutron URL is not set");
            return null;
        }
        WebTarget wt = this.client.target(baseUrl + path);
        return wt.request(new String[]{MediaType.JSON_UTF_8.toString()});
    }

    private String getToken() {
        if (!this.isTokenValid()) {
            String request = "{\"auth\": {\"tenantName\": \"admin\", \"passwordCredentials\":  {\"username\": \"" + this.userName + "\",\"password\": \"" + this.pass + "\"}}}";
            Invocation.Builder builder = this.getClientBuilder(this.keystoneUrl, URI_TOKENS);
            if (builder == null) {
                this.log.warn("Failed to get token");
                return null;
            }
            String response = (String)builder.accept(new String[]{"application/json"}).post(Entity.json((Object)request), String.class);
            ObjectMapper mapper = new ObjectMapper();
            try {
                ObjectNode node = (ObjectNode)mapper.readTree(response);
                this.tokenId = node.path(PATH_ACCESS).path(PATH_TOKEN).path(PATH_ID).asText();
                this.tokenExpires = node.path(PATH_ACCESS).path(PATH_TOKEN).path(PATH_EXPIRES).asText();
            }
            catch (IOException e) {
                this.log.warn("getToken()", (Throwable)e);
            }
            this.log.debug("token response:" + response);
        }
        return this.tokenId;
    }

    private boolean isTokenValid() {
        if (this.tokenExpires == null || this.tokenId == null || this.tokenExpires.isEmpty()) {
            return false;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(TOKEN_DATE_FORMAT);
            Date exireDate = dateFormat.parse(this.tokenExpires);
            Calendar today = Calendar.getInstance();
            if (exireDate.after(today.getTime())) {
                return true;
            }
        }
        catch (ParseException e) {
            this.log.error("Token parse exception error : {}", (Object)e.getMessage());
            return false;
        }
        this.log.debug("token is Invalid");
        return false;
    }

    public Collection<OpenstackPort> ports(String networkId) {
        return this.getPorts().stream().filter(port -> port.networkId().equals(networkId)).collect(Collectors.toList());
    }

    public Collection<OpenstackPort> ports() {
        return this.getPorts();
    }

    public OpenstackPort port(Port port) {
        String uuid = port.annotations().value("portName").substring(3);
        return this.getPorts().stream().filter(p -> p.id().startsWith(uuid)).findAny().orElse(null);
    }

    public OpenstackPort port(String portId) {
        return this.getPorts().stream().filter(p -> p.id().equals(portId)).findAny().orElse(null);
    }

    public OpenstackNetwork network(String networkId) {
        Collection subnets = this.getSubnets().stream().filter(s -> s.networkId().equals(networkId)).collect(Collectors.toList());
        OpenstackNetwork openstackNetwork = this.getNetworks().stream().filter(n -> n.id().equals(networkId)).findAny().orElse(null);
        if (openstackNetwork == null) {
            return null;
        }
        return OpenstackNetwork.builder().id(openstackNetwork.id()).name(openstackNetwork.name()).networkType(openstackNetwork.networkType()).segmentId(openstackNetwork.segmentId()).tenantId(openstackNetwork.tenantId()).subnets(subnets).build();
    }

    public Collection<OpenstackNetwork> networks() {
        return this.getNetworks();
    }

    public OpenstackSubnet subnet(String subnetId) {
        return this.getSubnets().stream().filter(subnet -> subnet.id().equals(subnetId)).findAny().orElse(null);
    }

    public Collection<OpenstackSubnet> subnets() {
        return this.getSubnets();
    }

    public Collection<OpenstackRouter> routers() {
        return this.getRouters();
    }

    public OpenstackRouter router(String routerId) {
        return this.getRouters().stream().filter(router -> router.id().equals(routerId)).findAny().orElse(null);
    }

    public Collection<OpenstackFloatingIP> floatingIps() {
        Invocation.Builder builder = this.getClientBuilder(this.neutronUrl, "floatingips");
        if (builder == null) {
            this.log.warn("Failed to get floating IPs");
            return Collections.EMPTY_LIST;
        }
        String response = (String)builder.accept(new javax.ws.rs.core.MediaType[]{javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE}).header(HEADER_AUTH_TOKEN, (Object)this.getToken()).get(String.class);
        this.log.debug("floatingIps response:" + response);
        ObjectMapper mapper = new ObjectMapper();
        ArrayList openstackFloatingIPs = Lists.newArrayList();
        try {
            ObjectNode node = (ObjectNode)mapper.readTree(response);
            ArrayNode floatingIpList = (ArrayNode)node.path("floatingips");
            OpenstackFloatingIpCodec fipCodec = new OpenstackFloatingIpCodec();
            floatingIpList.forEach(f -> openstackFloatingIPs.add(fipCodec.decode((ObjectNode)f, null)));
        }
        catch (IOException e) {
            this.log.warn("floatingIps()", (Throwable)e);
        }
        openstackFloatingIPs.removeAll(Collections.singleton(null));
        return openstackFloatingIPs;
    }

    public boolean updateFloatingIp(String id, String portId, Optional<Ip4Address> fixedIpAddress) {
        Invocation.Builder builder = this.getClientBuilder(this.neutronUrl, "floatingips/" + id);
        if (builder == null || portId != null && !fixedIpAddress.isPresent()) {
            this.log.warn("Failed to update floating IP");
            return false;
        }
        ObjectNode objectNode = this.createFloatingIpObject(portId, fixedIpAddress);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(objectNode.toString().getBytes());
        try {
            Response response = builder.header(HEADER_AUTH_TOKEN, (Object)this.getToken()).put(Entity.entity((Object)IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), (String)"application/json"));
            this.log.debug("updateFloatingIp called: {}, status: {}", response.readEntity(String.class), (Object)String.valueOf(response.getStatus()));
            return this.checkReply(response);
        }
        catch (IOException e) {
            this.log.error("Cannot do PUT {} request");
            return false;
        }
    }

    private ObjectNode createFloatingIpObject(String portId, Optional<Ip4Address> fixedIpAddress) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode objectNode = mapper.createObjectNode();
        objectNode.putObject(FLOATINGIP).put(PORT_ID, portId);
        if (portId != null) {
            objectNode.put(FIXED_IP_ADDRESS, fixedIpAddress.get().toString());
        }
        return objectNode;
    }

    private boolean checkReply(Response response) {
        if (response != null) {
            return this.checkStatusCode(response.getStatus());
        }
        this.log.warn("Null floating IP response from openstack");
        return false;
    }

    private boolean checkStatusCode(int statusCode) {
        return statusCode == Response.Status.OK.getStatusCode();
    }

    private void configureNetwork() {
        OpenstackInterfaceConfig cfg = (OpenstackInterfaceConfig)this.cfgService.getConfig((Object)this.appId, OpenstackInterfaceConfig.class);
        if (cfg == null) {
            this.log.error("There is no openstack server information in config.");
            return;
        }
        this.neutronUrl = (String)Preconditions.checkNotNull((Object)cfg.neutronServer());
        this.keystoneUrl = (String)Preconditions.checkNotNull((Object)cfg.keystoneServer());
        this.userName = (String)Preconditions.checkNotNull((Object)cfg.userName());
        this.pass = (String)Preconditions.checkNotNull((Object)cfg.password());
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        this.cfgService = networkConfigRegistry;
    }

    protected void unbindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        if (this.cfgService == networkConfigRegistry) {
            this.cfgService = null;
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if ((event.type() == NetworkConfigEvent.Type.CONFIG_ADDED || event.type() == NetworkConfigEvent.Type.CONFIG_UPDATED) && event.configClass().equals(OpenstackInterfaceConfig.class)) {
                OpenstackInterfaceManager.this.log.info("Network configuration changed");
                OpenstackInterfaceManager.this.networkEventExcutorService.execute(() -> OpenstackInterfaceManager.this.configureNetwork());
            }
        }
    }
}

