/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstackinterface.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.openstackinterface.OpenstackPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenstackPortCodec
extends JsonCodec<OpenstackPort> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PORT = "port";
    private static final String STATUS = "status";
    private static final String NAME = "name";
    private static final String ADDRESS_PAIR = "allowed_address_pairs";
    private static final String ADMIN_STATUS = "admin_status";
    private static final String NETWORK_ID = "network_id";
    private static final String TENANT_ID = "tenant_id";
    private static final String DEVICE_OWNER = "device_owner";
    private static final String MAC_ADDRESS = "mac_address";
    private static final String FIXED_IPS = "fixed_ips";
    private static final String SUBNET_ID = "subnet_id";
    private static final String IP_ADDRESS = "ip_address";
    private static final String ID = "id";
    private static final String SECURITY_GROUPS = "security_groups";
    private static final String DEVICE_ID = "device_id";
    private static final String NA = "N/A";

    public OpenstackPort decode(ObjectNode json, CodecContext context) {
        Preconditions.checkNotNull((Object)json);
        HashMap fixedIpMap = Maps.newHashMap();
        JsonNode portInfo = json.get(PORT);
        if (portInfo == null) {
            portInfo = json;
        }
        String status = portInfo.path(STATUS).asText();
        String name = portInfo.path(NAME).asText();
        boolean adminStateUp = portInfo.path(ADMIN_STATUS).asBoolean();
        String networkId = portInfo.path(NETWORK_ID).asText();
        String tenantId = portInfo.path(TENANT_ID).asText();
        String deviceOwner = portInfo.path(DEVICE_OWNER).asText();
        String macStr = portInfo.path(MAC_ADDRESS).asText();
        ArrayNode fixedIpList = (ArrayNode)portInfo.path(FIXED_IPS);
        for (JsonNode fixedIpInfo : fixedIpList) {
            String subnetId = fixedIpInfo.path(SUBNET_ID).asText();
            String ipAddressStr = fixedIpInfo.path(IP_ADDRESS).asText();
            if (fixedIpInfo.path(IP_ADDRESS).isMissingNode() || ipAddressStr == null) continue;
            Ip4Address ipAddress = Ip4Address.valueOf((String)ipAddressStr);
            fixedIpMap.put(subnetId, ipAddress);
        }
        String id = portInfo.path(ID).asText();
        ArrayNode securityGroupList = (ArrayNode)portInfo.path(SECURITY_GROUPS);
        ArrayList securityGroupIdList = Lists.newArrayList();
        securityGroupList.forEach(securityGroup -> securityGroupIdList.add(securityGroup.asText()));
        String deviceId = portInfo.path(DEVICE_ID).asText();
        HashMap addressPairs = Maps.newHashMap();
        for (JsonNode addrPair : (ArrayNode)portInfo.path(ADDRESS_PAIR)) {
            try {
                addressPairs.put(IpAddress.valueOf((String)addrPair.path(IP_ADDRESS).asText()), MacAddress.valueOf((String)addrPair.path(MAC_ADDRESS).asText()));
            }
            catch (IllegalArgumentException e) {
                this.log.debug("Invalid address pair {}", (Object)addrPair.toString());
            }
        }
        OpenstackPort.Builder openstackPortBuilder = OpenstackPort.builder();
        OpenstackPort.PortStatus portStatus = status.equals(NA) ? OpenstackPort.PortStatus.NA : OpenstackPort.PortStatus.valueOf((String)status);
        openstackPortBuilder.portStatus(portStatus).name(name).adminState(adminStateUp).netwrokId(networkId).tenantId(tenantId).deviceOwner(deviceOwner).macAddress(MacAddress.valueOf((String)macStr)).fixedIps((Map)fixedIpMap).id(id).deviceId(deviceId).securityGroup((Collection)securityGroupIdList);
        if (!addressPairs.isEmpty()) {
            openstackPortBuilder.allowedAddressPairs((Map)addressPairs);
        }
        OpenstackPort openstackPort = openstackPortBuilder.build();
        return openstackPort;
    }
}

