/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstackinterface.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.onlab.packet.Ip4Address;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.openstackinterface.OpenstackExternalGateway;
import org.onosproject.openstackinterface.OpenstackRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenstackRouterCodec
extends JsonCodec<OpenstackRouter> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String ROUTER = "router";
    private static final String TENANT_ID = "tenant_id";
    private static final String NETWORK_ID = "network_id";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String STATUS = "status";
    private static final String ADMIN_STATE_UP = "admin_state_up";
    private static final String EXTERNAL_GW_INFO = "external_gateway_info";
    private static final String EXTERNAL_FIXED_IPS = "external_fixed_ips";
    private static final String SUBNET_ID = "subnet_id";
    private static final String IP_ADDRESS = "ip_address";

    public OpenstackRouter decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        JsonNode routerInfo = json.get(ROUTER);
        if (routerInfo == null) {
            routerInfo = json;
        }
        String tenantId = (String)Preconditions.checkNotNull((Object)routerInfo.path(TENANT_ID).asText());
        String id = (String)Preconditions.checkNotNull((Object)routerInfo.path(ID).asText());
        String name = (String)Preconditions.checkNotNull((Object)routerInfo.path(NAME).asText());
        String adminStateUp = (String)Preconditions.checkNotNull((Object)routerInfo.path(ADMIN_STATE_UP).asText());
        OpenstackExternalGateway.Builder osExtBuiler = new OpenstackExternalGateway.Builder();
        if (!routerInfo.path(EXTERNAL_GW_INFO).isMissingNode()) {
            String externalGatewayNetId = (String)Preconditions.checkNotNull((Object)routerInfo.path(EXTERNAL_GW_INFO).path(NETWORK_ID).asText());
            HashMap fixedIpMap = Maps.newHashMap();
            if (!routerInfo.path(EXTERNAL_GW_INFO).path(EXTERNAL_FIXED_IPS).isMissingNode()) {
                ArrayNode fixedIpList = (ArrayNode)routerInfo.path(EXTERNAL_GW_INFO).path(EXTERNAL_FIXED_IPS);
                for (JsonNode fixedIpInfo : fixedIpList) {
                    String subnetId = (String)Preconditions.checkNotNull((Object)fixedIpInfo.path(SUBNET_ID).asText());
                    String ipAddressStr = (String)Preconditions.checkNotNull((Object)fixedIpInfo.path(IP_ADDRESS).asText());
                    if (fixedIpInfo.path(IP_ADDRESS).isMissingNode() || ipAddressStr == null) continue;
                    fixedIpMap.put(subnetId, Ip4Address.valueOf((String)ipAddressStr));
                }
            }
            osExtBuiler.networkId(externalGatewayNetId).enablePnat(true).externalFixedIps((Map)fixedIpMap);
        }
        OpenstackRouter.Builder osBuilder = new OpenstackRouter.Builder().tenantId(tenantId).id(id).name(name).status(OpenstackRouter.RouterStatus.ACTIVE).adminStateUp(Boolean.valueOf(adminStateUp).booleanValue()).gatewayExternalInfo(osExtBuiler.build());
        return osBuilder.build();
    }
}

