/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineModelResolver {
    private OpenAPI openAPI;
    private Map<String, Schema> addedModels = new HashMap<String, Schema>();
    private Map<String, String> generatedSignature = new HashMap<String, String>();
    private Map<String, String> inlineSchemaNameMapping = new HashMap<String, String>();
    private Map<String, String> inlineSchemaNameDefaults = new HashMap<String, String>();
    private Set<String> inlineSchemaNameMappingValues = new HashSet<String>();
    public boolean resolveInlineEnums = false;
    private static ObjectMapper structureMapper = Json.mapper().copy();
    private Set<String> uniqueNames = new HashSet<String>();
    final Logger LOGGER = LoggerFactory.getLogger(InlineModelResolver.class);

    public InlineModelResolver() {
        this.inlineSchemaNameDefaults.put("arrayItemSuffix", "_inner");
        this.inlineSchemaNameDefaults.put("mapItemSuffix", "_value");
    }

    public void setInlineSchemaNameMapping(Map inlineSchemaNameMapping) {
        this.inlineSchemaNameMapping = inlineSchemaNameMapping;
        this.inlineSchemaNameMappingValues = new HashSet(inlineSchemaNameMapping.values());
    }

    public void setInlineSchemaNameDefaults(Map inlineSchemaNameDefaults) {
        this.inlineSchemaNameDefaults.putAll(inlineSchemaNameDefaults);
    }

    void flatten(OpenAPI openAPI) {
        this.openAPI = openAPI;
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if (this.openAPI.getComponents().getSchemas() == null) {
            this.openAPI.getComponents().setSchemas(new HashMap());
        }
        this.flattenPaths();
        this.flattenComponents();
    }

    private void flattenPaths() {
        Paths paths = this.openAPI.getPaths();
        if (paths == null) {
            return;
        }
        for (Map.Entry pathsEntry : paths.entrySet()) {
            String pathname;
            PathItem path = (PathItem)pathsEntry.getValue();
            ArrayList operations = new ArrayList(path.readOperations());
            String name = pathname = (String)pathsEntry.getKey();
            if (path.getDelete() != null) {
                name = pathname + "_delete";
            } else if (path.getGet() != null) {
                name = pathname + "_get";
            } else if (path.getHead() != null) {
                name = pathname + "_head";
            } else if (path.getOptions() != null) {
                name = pathname + "_options";
            } else if (path.getPatch() != null) {
                name = pathname + "_patch";
            } else if (path.getPost() != null) {
                name = pathname + "_post";
            } else if (path.getPut() != null) {
                name = pathname + "_put";
            } else if (path.getTrace() != null) {
                name = pathname + "_trace";
            }
            for (Operation operation : path.readOperations()) {
                Map callbacks = operation.getCallbacks();
                if (callbacks == null) continue;
                operations.addAll(callbacks.values().stream().flatMap(callback -> callback.values().stream()).flatMap(pathItem -> pathItem.readOperations().stream()).collect(Collectors.toList()));
            }
            for (Operation operation : operations) {
                this.flattenRequestBody(name, operation);
                this.flattenParameters(name, operation);
                this.flattenResponses(name, operation);
            }
        }
    }

    private boolean isModelNeeded(Schema schema) {
        if (this.resolveInlineEnums && schema.getEnum() != null && schema.getEnum().size() > 0) {
            return true;
        }
        if ((schema.getType() == null || "object".equals(schema.getType())) && schema.getProperties() != null && schema.getProperties().size() > 0) {
            return true;
        }
        if (schema instanceof ComposedSchema) {
            ComposedSchema m = (ComposedSchema)schema;
            if (m.getAllOf() != null && !m.getAllOf().isEmpty()) {
                for (Schema inner : m.getAllOf()) {
                    if (!this.isModelNeeded(ModelUtils.getReferencedSchema(this.openAPI, inner))) continue;
                    return true;
                }
                return false;
            }
            if (m.getAnyOf() != null && !m.getAnyOf().isEmpty()) {
                return true;
            }
            if (m.getOneOf() != null && !m.getOneOf().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private void gatherInlineModels(Schema schema, String modelPrefix) {
        Schema refSchema;
        String schemaName;
        Schema refSchema2;
        String schemaName2;
        if (schema.get$ref() != null) {
            if (this.isModelNeeded(schema) || "object".equals(schema.getType()) || schema.getProperties() != null || schema.getAdditionalProperties() != null || schema instanceof ComposedSchema) {
                this.LOGGER.error("Illegal schema found with $ref combined with other properties, no properties should be defined alongside a $ref:\n " + schema.toString());
            }
            return;
        }
        if (schema.getType() == null || "object".equals(schema.getType())) {
            Map props = schema.getProperties();
            if (props != null) {
                for (String propName : props.keySet()) {
                    ComposedSchema m;
                    Schema prop = (Schema)props.get(propName);
                    schemaName2 = this.resolveModelName(prop.getTitle(), modelPrefix + "_" + propName);
                    this.gatherInlineModels(prop, schemaName2);
                    if (this.isModelNeeded(prop)) {
                        refSchema2 = this.makeSchemaInComponents(schemaName2, prop);
                        props.put(propName, refSchema2);
                        continue;
                    }
                    if (!(prop instanceof ComposedSchema) || (m = (ComposedSchema)prop).getAllOf() == null || m.getAllOf().size() != 1 || ((Schema)m.getAllOf().get(0)).getType() == null || "object".equals(((Schema)m.getAllOf().get(0)).getType())) continue;
                    this.LOGGER.info("allOf schema used by the property `{}` replaced by its only item (a type)", (Object)propName);
                    props.put(propName, m.getAllOf().get(0));
                }
            }
            if (schema.getAdditionalProperties() != null && schema.getAdditionalProperties() instanceof Schema) {
                Schema inner = (Schema)schema.getAdditionalProperties();
                schemaName = this.resolveModelName(schema.getTitle(), modelPrefix + this.inlineSchemaNameDefaults.get("mapItemSuffix"));
                this.gatherInlineModels(inner, schemaName);
                if (this.isModelNeeded(inner)) {
                    refSchema = this.makeSchemaInComponents(schemaName, inner);
                    schema.setAdditionalProperties((Object)refSchema);
                }
            }
        } else {
            if (schema.getProperties() != null) {
                this.LOGGER.error("Illegal schema found with non-object type combined with properties, no properties should be defined:\n " + schema.toString());
                return;
            }
            if (schema.getAdditionalProperties() != null) {
                this.LOGGER.error("Illegal schema found with non-object type combined with additionalProperties, no additionalProperties should be defined:\n " + schema.toString());
                return;
            }
        }
        if (schema instanceof ArraySchema) {
            ArraySchema array = (ArraySchema)schema;
            Schema items = array.getItems();
            if (items == null) {
                this.LOGGER.error("Illegal schema found with array type but no items, items must be defined for array schemas:\n " + schema.toString());
                return;
            }
            schemaName = this.resolveModelName(items.getTitle(), modelPrefix + this.inlineSchemaNameDefaults.get("arrayItemSuffix"));
            this.gatherInlineModels(items, schemaName);
            if (this.isModelNeeded(items)) {
                refSchema = this.makeSchemaInComponents(schemaName, items);
                array.setItems(refSchema);
            }
        }
        if (schema instanceof ComposedSchema) {
            ComposedSchema m = (ComposedSchema)schema;
            if (m.getAllOf() != null) {
                ArrayList<Schema> newAllOf = new ArrayList<Schema>();
                boolean atLeastOneModel = false;
                for (Schema inner : m.getAllOf()) {
                    String schemaName3 = this.resolveModelName(inner.getTitle(), modelPrefix + "_allOf");
                    this.gatherInlineModels(inner, schemaName3);
                    if (this.isModelNeeded(inner)) {
                        Schema refSchema3 = this.makeSchemaInComponents(schemaName3, inner);
                        newAllOf.add(refSchema3);
                        atLeastOneModel = true;
                        continue;
                    }
                    newAllOf.add(inner);
                }
                if (atLeastOneModel) {
                    m.setAllOf(newAllOf);
                } else if (m.getAllOf().size() != 1) {
                    if (m.getAllOf().size() > 1) {
                        this.LOGGER.warn("allOf schema `{}` containing multiple types (not model) is not supported at the moment.", (Object)schema.getName());
                    } else {
                        this.LOGGER.error("allOf schema `{}` contains no items.", (Object)schema.getName());
                    }
                }
            }
            if (m.getAnyOf() != null) {
                ArrayList<Schema> newAnyOf = new ArrayList<Schema>();
                for (Schema inner : m.getAnyOf()) {
                    schemaName2 = this.resolveModelName(inner.getTitle(), modelPrefix + "_anyOf");
                    this.gatherInlineModels(inner, schemaName2);
                    if (this.isModelNeeded(inner)) {
                        refSchema2 = this.makeSchemaInComponents(schemaName2, inner);
                        newAnyOf.add(refSchema2);
                        continue;
                    }
                    newAnyOf.add(inner);
                }
                m.setAnyOf(newAnyOf);
            }
            if (m.getOneOf() != null) {
                ArrayList<Schema> newOneOf = new ArrayList<Schema>();
                for (Schema inner : m.getOneOf()) {
                    schemaName2 = this.resolveModelName(inner.getTitle(), modelPrefix + "_oneOf");
                    this.gatherInlineModels(inner, schemaName2);
                    if (this.isModelNeeded(inner)) {
                        refSchema2 = this.makeSchemaInComponents(schemaName2, inner);
                        newOneOf.add(refSchema2);
                        continue;
                    }
                    newOneOf.add(inner);
                }
                m.setOneOf(newOneOf);
            }
        }
        if (schema.getNot() != null) {
            Schema not = schema.getNot();
            String schemaName4 = this.resolveModelName(schema.getTitle(), modelPrefix + "_not");
            this.gatherInlineModels(not, schemaName4);
            if (this.isModelNeeded(not)) {
                Schema refSchema4 = this.makeSchemaInComponents(schemaName4, not);
                schema.setNot(refSchema4);
            }
        }
    }

    private void flattenContent(Content content, String name) {
        if (content == null || content.isEmpty()) {
            return;
        }
        for (String contentType : content.keySet()) {
            Schema schema;
            MediaType mediaType = (MediaType)content.get((Object)contentType);
            if (mediaType == null || (schema = mediaType.getSchema()) == null) continue;
            String schemaName = this.resolveModelName(schema.getTitle(), name);
            this.gatherInlineModels(schema, schemaName);
            if (!this.isModelNeeded(schema)) continue;
            Schema refSchema = this.makeSchemaInComponents(schemaName, schema);
            mediaType.setSchema(refSchema);
        }
    }

    private void flattenRequestBody(String modelName, Operation operation) {
        RequestBody requestBody = operation.getRequestBody();
        if (requestBody == null) {
            return;
        }
        if (requestBody.get$ref() != null) {
            String ref = ModelUtils.getSimpleRef(requestBody.get$ref());
            requestBody = (RequestBody)this.openAPI.getComponents().getRequestBodies().get(ref);
        }
        this.flattenContent(requestBody.getContent(), (operation.getOperationId() == null ? modelName : operation.getOperationId()) + "_request");
    }

    private void flattenParameters(String modelName, Operation operation) {
        List parameters = operation.getParameters();
        if (parameters == null) {
            return;
        }
        for (Parameter parameter : parameters) {
            Schema parameterSchema;
            if (parameter.getSchema() == null || (parameterSchema = parameter.getSchema()) == null) continue;
            String schemaName = this.resolveModelName(parameterSchema.getTitle(), (operation.getOperationId() == null ? modelName : operation.getOperationId()) + "_" + parameter.getName() + "_parameter");
            this.gatherInlineModels(parameterSchema, schemaName);
            if (!this.isModelNeeded(parameterSchema)) continue;
            Schema refSchema = this.makeSchemaInComponents(schemaName, parameterSchema);
            parameter.setSchema(refSchema);
        }
    }

    private void flattenResponses(String modelName, Operation operation) {
        ApiResponses responses = operation.getResponses();
        if (responses == null) {
            return;
        }
        for (Map.Entry responsesEntry : responses.entrySet()) {
            String key = (String)responsesEntry.getKey();
            ApiResponse response = (ApiResponse)responsesEntry.getValue();
            this.flattenContent(response.getContent(), (operation.getOperationId() == null ? modelName : operation.getOperationId()) + "_" + key + "_response");
        }
    }

    private void flattenComposedChildren(String key, List<Schema> children) {
        if (children == null || children.isEmpty()) {
            return;
        }
        ListIterator<Schema> listIterator = children.listIterator();
        while (listIterator.hasNext()) {
            Schema schema;
            Schema component = listIterator.next();
            if (component == null || component.get$ref() != null || (component.getProperties() == null || component.getProperties().isEmpty()) && (component.getEnum() == null || component.getEnum().isEmpty())) continue;
            String innerModelName = this.resolveModelName(component.getTitle(), key);
            Schema innerModel = this.modelFromProperty(this.openAPI, component, innerModelName);
            String existing = this.matchGenerated(innerModel);
            if (existing == null) {
                innerModelName = this.addSchemas(innerModelName, innerModel);
                schema = new Schema().$ref(innerModelName);
                schema.setRequired(component.getRequired());
                listIterator.set(schema);
                continue;
            }
            schema = new Schema().$ref(existing);
            schema.setRequired(component.getRequired());
            listIterator.set(schema);
        }
    }

    private void flattenComponents() {
        Map models = this.openAPI.getComponents().getSchemas();
        if (models == null) {
            return;
        }
        ArrayList modelNames = new ArrayList(models.keySet());
        for (String modelName : modelNames) {
            Schema model = (Schema)models.get(modelName);
            if (ModelUtils.isComposedSchema(model)) {
                ComposedSchema m = (ComposedSchema)model;
                this.flattenComposedChildren(modelName + "_allOf", m.getAllOf());
                this.flattenComposedChildren(modelName + "_anyOf", m.getAnyOf());
                this.flattenComposedChildren(modelName + "_oneOf", m.getOneOf());
                continue;
            }
            if (!(model instanceof Schema)) continue;
            this.gatherInlineModels(model, modelName);
        }
    }

    private void fixStringModel(Schema m) {
        String example;
        if (this.schemaIsOfType(m, "string") && this.schemaContainsExample(m) && (example = m.getExample().toString()).startsWith("\"") && example.endsWith("\"")) {
            m.setExample((Object)example.substring(1, example.length() - 1));
        }
    }

    private boolean schemaIsOfType(Schema m, String type) {
        return m.getType() != null && m.getType().equals(type);
    }

    private boolean schemaContainsExample(Schema m) {
        return m.getExample() != null && m.getExample() != "";
    }

    private String resolveModelName(String title, String modelName) {
        if (title == null) {
            if (modelName == null) {
                return this.uniqueName("inline_object");
            }
            return this.uniqueName(this.sanitizeName(modelName));
        }
        return this.uniqueName(this.sanitizeName(title));
    }

    private String matchGenerated(Schema model) {
        try {
            String json = structureMapper.writeValueAsString((Object)model);
            if (this.generatedSignature.containsKey(json)) {
                return this.generatedSignature.get(json);
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void addGenerated(String name, Schema model) {
        try {
            String json = structureMapper.writeValueAsString((Object)model);
            this.generatedSignature.put(json, name);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private String sanitizeName(String name) {
        return name.replaceAll("^[0-9]", "_$0").replaceAll("[^A-Za-z0-9]", "_");
    }

    private String uniqueName(String name) {
        if (this.openAPI.getComponents().getSchemas() == null) {
            return name;
        }
        String uniqueName = name;
        int count = 0;
        while (this.openAPI.getComponents().getSchemas().containsKey(uniqueName) || this.uniqueNames.contains(uniqueName)) {
            uniqueName = name + "_" + ++count;
        }
        return uniqueName;
    }

    private void flattenProperties(OpenAPI openAPI, Map<String, Schema> properties, String path) {
        if (properties == null) {
            return;
        }
        HashMap<String, Schema> propsToUpdate = new HashMap<String, Schema>();
        HashMap<String, Schema> modelsToAdd = new HashMap<String, Schema>();
        for (Map.Entry<String, Schema> propertiesEntry : properties.entrySet()) {
            Schema schema;
            ObjectSchema op;
            Schema inner;
            ObjectSchema op2;
            ArraySchema ap;
            Schema inner2;
            String key = propertiesEntry.getKey();
            Schema property = propertiesEntry.getValue();
            if (property instanceof ObjectSchema && ((ObjectSchema)property).getProperties() != null && ((ObjectSchema)property).getProperties().size() > 0) {
                Schema schema2;
                ObjectSchema op3 = (ObjectSchema)property;
                String modelName = this.resolveModelName(op3.getTitle(), path + "_" + key);
                Schema model = this.modelFromProperty(openAPI, (Schema)op3, modelName);
                String existing = this.matchGenerated(model);
                if (existing != null) {
                    schema2 = new Schema().$ref(existing);
                    schema2.setRequired(op3.getRequired());
                    propsToUpdate.put(key, schema2);
                } else {
                    modelName = this.addSchemas(modelName, model);
                    schema2 = new Schema().$ref(modelName);
                    schema2.setRequired(op3.getRequired());
                    propsToUpdate.put(key, schema2);
                    modelsToAdd.put(modelName, model);
                }
            } else if (property instanceof ArraySchema && (inner2 = (ap = (ArraySchema)property).getItems()) instanceof ObjectSchema && (op2 = (ObjectSchema)inner2).getProperties() != null && op2.getProperties().size() > 0) {
                Schema schema3;
                this.flattenProperties(openAPI, op2.getProperties(), path);
                String modelName = this.resolveModelName(op2.getTitle(), path + "_" + key);
                Schema innerModel = this.modelFromProperty(openAPI, (Schema)op2, modelName);
                String existing = this.matchGenerated(innerModel);
                if (existing != null) {
                    schema3 = new Schema().$ref(existing);
                    schema3.setRequired(op2.getRequired());
                    ap.setItems(schema3);
                } else {
                    modelName = this.addSchemas(modelName, innerModel);
                    schema3 = new Schema().$ref(modelName);
                    schema3.setRequired(op2.getRequired());
                    ap.setItems(schema3);
                }
            }
            if (!ModelUtils.isMapSchema(property) || !((inner = ModelUtils.getAdditionalProperties(openAPI, property)) instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
            this.flattenProperties(openAPI, op.getProperties(), path);
            String modelName = this.resolveModelName(op.getTitle(), path + "_" + key);
            Schema innerModel = this.modelFromProperty(openAPI, (Schema)op, modelName);
            String existing = this.matchGenerated(innerModel);
            if (existing != null) {
                schema = new Schema().$ref(existing);
                schema.setRequired(op.getRequired());
                property.setAdditionalProperties((Object)schema);
                continue;
            }
            modelName = this.addSchemas(modelName, innerModel);
            schema = new Schema().$ref(modelName);
            schema.setRequired(op.getRequired());
            property.setAdditionalProperties((Object)schema);
        }
        if (propsToUpdate.size() > 0) {
            for (String key : propsToUpdate.keySet()) {
                properties.put(key, (Schema)propsToUpdate.get(key));
            }
        }
        for (String key : modelsToAdd.keySet()) {
            openAPI.getComponents().addSchemas(key, (Schema)modelsToAdd.get(key));
            this.addedModels.put(key, (Schema)modelsToAdd.get(key));
        }
    }

    private Schema modelFromProperty(OpenAPI openAPI, Schema object, String path) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        XML xml = object.getXml();
        Map properties = object.getProperties();
        Schema model = new Schema();
        model.setType(object.getType());
        model.setFormat(object.getFormat());
        model.setDescription(description);
        model.setExample((Object)example);
        model.setName(object.getName());
        model.setXml(xml);
        model.setRequired(object.getRequired());
        model.setNullable(object.getNullable());
        model.setEnum(object.getEnum());
        model.setType(object.getType());
        model.setDiscriminator(object.getDiscriminator());
        model.setWriteOnly(object.getWriteOnly());
        model.setUniqueItems(object.getUniqueItems());
        model.setTitle(object.getTitle());
        model.setReadOnly(object.getReadOnly());
        model.setPattern(object.getPattern());
        model.setNot(object.getNot());
        model.setMinProperties(object.getMinProperties());
        model.setMinLength(object.getMinLength());
        model.setMinItems(object.getMinItems());
        model.setMinimum(object.getMinimum());
        model.setMaxProperties(object.getMaxProperties());
        model.setMaxLength(object.getMaxLength());
        model.setMaxItems(object.getMaxItems());
        model.setMaximum(object.getMaximum());
        model.setExternalDocs(object.getExternalDocs());
        model.setExtensions(object.getExtensions());
        model.setExclusiveMinimum(object.getExclusiveMinimum());
        model.setExclusiveMaximum(object.getExclusiveMaximum());
        model.setDeprecated(object.getDeprecated());
        if (properties != null) {
            this.flattenProperties(openAPI, properties, path);
            model.setProperties(properties);
        }
        return model;
    }

    private Schema makeSchemaInComponents(String name, Schema schema) {
        Schema refSchema;
        String existing = this.matchGenerated(schema);
        if (existing != null) {
            refSchema = new Schema().$ref(existing);
        } else {
            if (this.resolveInlineEnums && schema.getEnum() != null && schema.getEnum().size() > 0) {
                this.LOGGER.warn("Model " + name + " promoted to its own schema due to resolveInlineEnums=true");
            }
            name = this.addSchemas(name, schema);
            refSchema = new Schema().$ref(name);
        }
        this.copyVendorExtensions(schema, refSchema);
        return refSchema;
    }

    private Schema makeSchema(String ref, Schema property) {
        Schema newProperty = new Schema().$ref(ref);
        this.copyVendorExtensions(property, newProperty);
        return newProperty;
    }

    private void copyVendorExtensions(Schema source, Schema target) {
        Map vendorExtensions = source.getExtensions();
        if (vendorExtensions == null) {
            return;
        }
        for (String extName : vendorExtensions.keySet()) {
            target.addExtension(extName, vendorExtensions.get(extName));
        }
    }

    private String addSchemas(String name, Schema schema) {
        if (this.inlineSchemaNameMapping.containsKey(name)) {
            name = this.inlineSchemaNameMapping.get(name);
        }
        this.addGenerated(name, schema);
        this.openAPI.getComponents().addSchemas(name, schema);
        if (!name.equals(schema.getTitle()) && !this.inlineSchemaNameMappingValues.contains(name)) {
            this.LOGGER.info("Inline schema created as {}. To have complete control of the model name, set the `title` field or use the inlineSchemaNameMapping option (--inline-schema-name-mapping in CLI).", (Object)name);
        }
        this.uniqueNames.add(name);
        return name;
    }

    static {
        structureMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        structureMapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
    }
}

