/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCppCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;

public class CppRestbedServerCodegen
extends AbstractCppCodegen {
    public static final String DECLSPEC = "declspec";
    public static final String DEFAULT_INCLUDE = "defaultInclude";
    private static final String OPEN_API_PATH_PARAM_PATTERN = "^\\{(.*)\\}$";
    private static final String X_CODEGEN_OTHER_METHODS = "x-codegen-other-methods";
    protected String packageVersion = "1.0.0";
    protected String declspec = "";
    protected String defaultInclude = "";

    public CppRestbedServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling, GlobalFeature.MultiServer}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.apiPackage = "org.openapitools.server.api";
        this.modelPackage = "org.openapitools.server.model";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-source.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-source.mustache", ".cpp");
        this.templateDir = "cpp-restbed-server";
        this.embeddedTemplateDir = "cpp-restbed-server";
        this.cliOptions.clear();
        this.addOption("modelPackage", "C++ namespace for models (convention: name.space.model).", this.modelPackage);
        this.addOption("apiPackage", "C++ namespace for apis (convention: name.space.api).", this.apiPackage);
        this.addOption("packageVersion", "C++ package version.", this.packageVersion);
        this.addOption(DECLSPEC, "C++ preprocessor to place before the class name for handling dllexport/dllimport.", this.declspec);
        this.addOption(DEFAULT_INCLUDE, "The default include statement that should be placed in all headers for including things like the declspec (convention: #include \"Commons.h\" ", this.defaultInclude);
        this.addOption("reservedWordPrefix", "Prefix to prepend to reserved words in order to avoid conflicts", this.reservedWordPrefix);
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("model-helpers-header.mustache", this.modelFileFolder(), "helpers.h"));
        this.supportingFiles.add(new SupportingFile("CMakeLists.txt.mustache", "", "CMakeLists.txt"));
        this.supportingFiles.add(new SupportingFile("FindRestbedAndBoost.cmake", "", "FindRestbedAndBoost.cmake"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("int", "char", "bool", "long", "float", "double", "int32_t", "int64_t"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "std::string");
        this.typeMapping.put("DateTime", "std::string");
        this.typeMapping.put("string", "std::string");
        this.typeMapping.put("integer", "int32_t");
        this.typeMapping.put("long", "int64_t");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("array", "std::vector");
        this.typeMapping.put("map", "std::map");
        this.typeMapping.put("set", "std::set");
        this.typeMapping.put("file", "std::string");
        this.typeMapping.put("object", "std::string");
        this.typeMapping.put("binary", "restbed::Bytes");
        this.typeMapping.put("number", "double");
        this.typeMapping.put("decimal", "std::string");
        this.typeMapping.put("UUID", "std::string");
        this.typeMapping.put("URI", "std::string");
        this.typeMapping.put("ByteArray", "std::string");
        this.importMapping = new HashMap();
        this.importMapping.put("std::vector", "#include <vector>");
        this.importMapping.put("std::map", "#include <map>");
        this.importMapping.put("std::set", "#include <set>");
        this.importMapping.put("file", "#include <string>");
        this.importMapping.put("std::string", "#include <string>");
        this.importMapping.put("restbed::Bytes", "#include <corvusoft/restbed/byte.hpp>");
    }

    @Override
    public Map<String, ModelsMap> updateAllModels(Map<String, ModelsMap> objs) {
        Map<String, CodegenModel> allModels = this.getAllModels(objs);
        for (Map.Entry<String, CodegenModel> cm : allModels.entrySet()) {
            if (cm.getValue().getInterfaces() == null || cm.getValue().getInterfaces().isEmpty()) continue;
            ArrayList<String> newIntf = new ArrayList<String>(cm.getValue().getInterfaces());
            for (String intf : allModels.get(cm.getKey()).getInterfaces()) {
                if (allModels.get(intf).getInterfaces() == null || allModels.get(intf).getInterfaces().isEmpty()) continue;
                for (String intfInner : allModels.get(intf).getInterfaces()) {
                    newIntf.remove(intfInner);
                }
            }
            cm.getValue().setInterfaces(newIntf);
        }
        objs = super.updateAllModels(objs);
        return objs;
    }

    @Override
    public String getterAndSetterCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if ((name = this.toVarName(name)).startsWith("_")) {
            return "_" + StringUtils.camelize(name);
        }
        return StringUtils.camelize(name);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "cpp-restbed-server";
    }

    @Override
    public String getHelp() {
        return "Generates a C++ API Server with Restbed (https://github.com/Corvusoft/restbed).";
    }

    @Override
    public String getTypeDeclaration(String str) {
        return this.toModelName(str);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(DECLSPEC)) {
            this.declspec = this.additionalProperties.get(DECLSPEC).toString();
        }
        if (this.additionalProperties.containsKey(DEFAULT_INCLUDE)) {
            this.defaultInclude = this.additionalProperties.get(DEFAULT_INCLUDE).toString();
        }
        if (this.additionalProperties.containsKey("reservedWordPrefix")) {
            this.reservedWordPrefix = this.additionalProperties.get("reservedWordPrefix").toString();
        }
        this.additionalProperties.put("modelNamespaceDeclarations", this.modelPackage.split("\\."));
        this.additionalProperties.put("modelNamespace", this.modelPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put("apiNamespaceDeclarations", this.apiPackage.split("\\."));
        this.additionalProperties.put("apiNamespace", this.apiPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put(DECLSPEC, this.declspec);
        this.additionalProperties.put(DEFAULT_INCLUDE, this.defaultInclude);
        this.additionalProperties.put("reservedWordPrefix", this.reservedWordPrefix);
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + "/model").replace("/", File.separator);
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + "/api").replace("/", File.separator);
    }

    @Override
    public String toModelImport(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return "#include \"" + name + ".h\"";
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        Set<String> oldImports = codegenModel.imports;
        codegenModel.imports = new HashSet<String>();
        for (String imp : oldImports) {
            String newImp = this.toModelImport(imp);
            if (newImp.isEmpty()) continue;
            codegenModel.imports.add(newImp);
        }
        return codegenModel;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    private String capitalizeFirstChar(String str) {
        if (str.length() > 1) {
            return Character.toUpperCase(str.charAt(0)) + str.substring(1);
        }
        return str.toUpperCase(Locale.ENGLISH);
    }

    private String convertPathSegmentToResourceNamePart(String pathSegment) {
        String convertedSegnemt = pathSegment;
        if (pathSegment.matches(OPEN_API_PATH_PARAM_PATTERN)) {
            convertedSegnemt = pathSegment.substring(1, pathSegment.length() - 1);
        }
        return this.capitalizeFirstChar(this.sanitizeName(convertedSegnemt));
    }

    private String convertPathParamPattern(String pathSegment) {
        if (pathSegment.matches(OPEN_API_PATH_PARAM_PATTERN)) {
            String pattern = pathSegment.substring(0, pathSegment.length() - 1);
            pattern = pattern + ": .*}";
            return pattern;
        }
        return pathSegment;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        List<CodegenOperation> operationList = operations.getOperation();
        ArrayList<CodegenOperation> newOpList = new ArrayList<CodegenOperation>();
        for (CodegenOperation op : operationList) {
            String[] pathSegments = op.path.split("/", -1);
            String resourceNameCamelCase = "";
            StringJoiner joiner = new StringJoiner("/");
            for (String pathSegment : pathSegments) {
                resourceNameCamelCase = resourceNameCamelCase + this.convertPathSegmentToResourceNamePart(pathSegment);
                String convertedPathSegment = this.convertPathParamPattern(pathSegment);
                joiner.add(convertedPathSegment);
            }
            op.path = joiner.toString();
            op.vendorExtensions.put("x-codegen-resource-name", resourceNameCamelCase);
            CodegenOperation op1 = newOpList.stream().filter(opInList -> opInList.path.equals(op.path)).findAny().orElse(null);
            if (op1 != null) {
                List<CodegenOperation> currentOtherMethodList = this.getCodegenXCodegenOtherMethodsOperations(op1);
                op.operationIdCamelCase = op1.operationIdCamelCase;
                currentOtherMethodList.add(op);
                op1.vendorExtensions.put(X_CODEGEN_OTHER_METHODS, currentOtherMethodList);
                continue;
            }
            newOpList.add(op);
        }
        operations.setOperation(newOpList);
        return objs;
    }

    private List<CodegenOperation> getCodegenXCodegenOtherMethodsOperations(CodegenOperation newOperation) {
        ArrayList currentOtherMethodList = (ArrayList)newOperation.vendorExtensions.get(X_CODEGEN_OTHER_METHODS);
        if (currentOtherMethodList == null) {
            currentOtherMethodList = new ArrayList();
        }
        return currentOtherMethodList;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        String openAPIType = this.getSchemaType(p);
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return this.getSchemaType(p) + "<std::string, " + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isByteArraySchema(p)) {
            return "std::string";
        }
        if (ModelUtils.isFileSchema(p)) {
            return "std::string";
        }
        if (ModelUtils.isStringSchema(p) || ModelUtils.isDateSchema(p) || ModelUtils.isDateTimeSchema(p) || this.languageSpecificPrimitives.contains(openAPIType)) {
            return this.toModelName(openAPIType);
        }
        return openAPIType;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isStringSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + p.getDefault().toString() + "\"";
            }
            return "\"\"";
        }
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return "false";
        }
        if (ModelUtils.isDateSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + p.getDefault().toString() + "\"";
            }
            return "\"\"";
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + p.getDefault().toString() + "\"";
            }
            return "\"\"";
        }
        if (ModelUtils.isFileSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return "std::string{}";
        }
        if (ModelUtils.isNumberSchema(p)) {
            if (ModelUtils.isFloatSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString() + "f";
                }
                return "0.0f";
            }
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return "0.0";
        }
        if (ModelUtils.isIntegerSchema(p)) {
            if (ModelUtils.isLongSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString() + "L";
                }
                return "0L";
            }
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return "0";
        }
        if (ModelUtils.isByteArraySchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + p.getDefault().toString() + "\"";
            }
            return "\"\"";
        }
        if (ModelUtils.isMapSchema(p)) {
            String inner = this.getSchemaType(this.getAdditionalProperties(p));
            return "std::map<std::string, " + inner + ">()";
        }
        if (ModelUtils.isSet(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            return "std::set<" + inner + ">()";
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            return "std::vector<" + inner + ">()";
        }
        if (ModelUtils.isModel(p)) {
            String modelName = this.getTypeDeclaration(p);
            return modelName + "{}";
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)p.get$ref())) {
            return this.toModelName(ModelUtils.getSimpleRef(p.get$ref())) + "{}";
        }
        return "nullptr";
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        boolean isString;
        super.postProcessParameter(parameter);
        boolean isPrimitiveType = parameter.isPrimitiveType == Boolean.TRUE;
        boolean isArray = parameter.isArray == Boolean.TRUE;
        boolean bl = isString = parameter.isString == Boolean.TRUE;
        if (!(isPrimitiveType || isArray || isString || parameter.dataType.startsWith("std::shared_ptr"))) {
            parameter.defaultValue = parameter.dataType + "{}";
        }
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        String originalDefaultValue = var.defaultValue;
        super.updateCodegenPropertyEnum(var);
        var.defaultValue = originalDefaultValue;
    }
}

