/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.text.StringEscapeUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K6ClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final String X_OPERATION_GROUPING = "x-k6-openapi-operation-grouping";
    private static final String X_OPERATION_RESPONSE = "x-k6-openapi-operation-response";
    private static final String X_OPERATION_RESPONSE_HIDE = "hide";
    private static final String X_OPERATION_DATAEXTRACT = "x-k6-openapi-operation-dataextract";
    private static final String X_OPERATION_DATAEXTRACT_OPERATION_ID = "operationId";
    private static final String X_OPERATION_DATAEXTRACT_VALUE_PATH = "valuePath";
    private static final String X_OPERATION_DATAEXTRACT_PARAMETER_NAME = "parameterName";
    private final Logger LOGGER = LoggerFactory.getLogger(K6ClientCodegen.class);
    public static final String PROJECT_NAME = "projectName";
    public static final String MODULE_NAME = "moduleName";
    public static final String PROJECT_DESCRIPTION = "projectDescription";
    public static final String PROJECT_VERSION = "projectVersion";
    public static final String BASE_URL = "baseURL";
    public static final String PRESERVE_LEADING_PARAM_CHAR = "preserveLeadingParamChar";
    static final Collection<String> INVOKER_PKG_SUPPORTING_FILES = Arrays.asList("script.mustache", "README.mustache");
    static final String[][] JAVASCRIPT_SUPPORTING_FILES = new String[][]{{"script.mustache", "script.js"}, {"README.mustache", "README.md"}};
    protected String projectName;
    protected String moduleName;
    protected String projectDescription;
    protected String projectVersion;
    protected String licenseName;
    protected String invokerPackage;
    protected String sourceFolder = "";
    private String modelPropertyNaming = "camelCase";
    protected boolean preserveLeadingParamChar = false;

    public K6ClientCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "k6";
    }

    @Override
    public String getHelp() {
        return "Generates a k6 script (beta).";
    }

    @Override
    public void processOpts() {
        this.templateDir = "k6";
        this.embeddedTemplateDir = "k6";
        super.processOpts();
        if (this.additionalProperties.containsKey(PROJECT_NAME)) {
            this.setProjectName((String)this.additionalProperties.get(PROJECT_NAME));
        }
        if (this.additionalProperties.containsKey(MODULE_NAME)) {
            this.setModuleName((String)this.additionalProperties.get(MODULE_NAME));
        }
        if (this.additionalProperties.containsKey(PROJECT_DESCRIPTION)) {
            this.setProjectDescription((String)this.additionalProperties.get(PROJECT_DESCRIPTION));
        }
        if (this.additionalProperties.containsKey(PROJECT_VERSION)) {
            this.setProjectVersion((String)this.additionalProperties.get(PROJECT_VERSION));
        }
        if (this.additionalProperties.containsKey("licenseName")) {
            this.setLicenseName((String)this.additionalProperties.get("licenseName"));
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
        }
        if (this.additionalProperties.containsKey("modelPropertyNaming")) {
            this.setModelPropertyNaming((String)this.additionalProperties.get("modelPropertyNaming"));
        }
        boolean preserveLeadingParamChar = this.convertPropertyToBooleanAndWriteBack(PRESERVE_LEADING_PARAM_CHAR);
        this.setPreserveLeadingParamChar(preserveLeadingParamChar);
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (openAPI.getInfo() != null) {
            Info info = openAPI.getInfo();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.projectName) && info.getTitle() != null) {
                this.projectName = this.sanitizeName(StringUtils.dashize(info.getTitle()));
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.projectVersion)) {
                this.projectVersion = this.escapeUnsafeCharacters(this.escapeQuotationMark(info.getVersion()));
            }
            if (this.projectDescription == null) {
                this.projectDescription = this.sanitizeName(info.getDescription());
            }
            if (this.additionalProperties.get("licenseName") == null && info.getLicense() != null) {
                License license = info.getLicense();
                this.licenseName = license.getName();
            }
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.projectName)) {
            this.projectName = "swagger-k6-client";
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.moduleName)) {
            this.moduleName = StringUtils.camelize(StringUtils.underscore(this.projectName));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.projectVersion)) {
            this.projectVersion = "1.0.0";
        }
        if (this.projectDescription == null) {
            this.projectDescription = "Client library of " + this.projectName;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.licenseName)) {
            this.licenseName = "Unlicense";
        }
        this.additionalProperties.put(PROJECT_NAME, this.projectName);
        this.additionalProperties.put(MODULE_NAME, this.moduleName);
        this.additionalProperties.put(PROJECT_DESCRIPTION, this.escapeText(this.projectDescription));
        this.additionalProperties.put(PROJECT_VERSION, this.projectVersion);
        this.additionalProperties.put("licenseName", this.licenseName);
        this.additionalProperties.put("apiPackage", this.apiPackage);
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("modelPackage", this.modelPackage);
        this.additionalProperties.put("sourceFolder", this.sourceFolder);
        String baseURL = ((Server)openAPI.getServers().get(0)).getUrl();
        for (Server server : openAPI.getServers()) {
            if (!server.getUrl().contains("https://")) continue;
            baseURL = server.getUrl();
        }
        this.additionalProperties.put(BASE_URL, baseURL);
        Map<String, DataExtractSubstituteParameter> dataExtractSubstituteParams = this.getDataExtractSubstituteParameters(openAPI);
        HashMap<String, HTTPRequestGroup> requestGroups = new HashMap<String, HTTPRequestGroup>();
        HashSet<Parameter> extraParameters = new HashSet<Parameter>();
        HashMap pathVariables = new HashMap();
        for (String path : openAPI.getPaths().keySet()) {
            HashMap<Integer, HTTPRequest> requests = new HashMap<Integer, HTTPRequest>();
            HashSet<Parameter> hashSet = new HashSet<Parameter>();
            String groupName = path;
            for (Map.Entry methodOperation : ((PathItem)openAPI.getPaths().get((Object)path)).readOperationsMap().entrySet()) {
                Object contentTypeValue;
                ArrayList<Parameter> httpParams = new ArrayList<Parameter>();
                ArrayList<Parameter> queryParams = new ArrayList<Parameter>();
                ArrayList<Parameter> bodyOrFormParams = new ArrayList<Parameter>();
                ArrayList<k6Check> k6Checks = new ArrayList<k6Check>();
                HashSet<String> imports = new HashSet<String>();
                Operation operation = (Operation)methodOperation.getValue();
                PathItem.HttpMethod method = (PathItem.HttpMethod)methodOperation.getKey();
                OptionalInt operationGroupingOrder = OptionalInt.empty();
                String operationId = operation.getOperationId();
                boolean hasRequestBodyExample = false;
                CodegenOperation cgOperation = super.fromOperation(path, method.name(), operation, null);
                Optional<OperationGrouping> operationGrouping = this.extractOperationGrouping(cgOperation);
                if (operationGrouping.isPresent()) {
                    groupName = operationGrouping.get().groupName;
                    operationGroupingOrder = OptionalInt.of(operationGrouping.get().order);
                }
                for (Map.Entry resp : operation.getResponses().entrySet()) {
                    String statusData = ((String)resp.getKey()).equals("default") ? "200" : (String)resp.getKey();
                    boolean hideOperationResponse = this.shouldHideOperationResponse((ApiResponse)resp.getValue());
                    int status = Integer.parseInt(statusData);
                    if (hideOperationResponse || status < 200 || status >= 300) continue;
                    k6Checks.add(new k6Check(status, ((ApiResponse)resp.getValue()).getDescription()));
                }
                if (this.hasBodyParameter(openAPI, operation) || this.hasFormParameter(openAPI, operation)) {
                    String defaultContentType = this.hasFormParameter(openAPI, operation) ? "application/x-www-form-urlencoded" : "application/json";
                    ArrayList<String> consumes = new ArrayList<String>(K6ClientCodegen.getConsumesInfo(openAPI, operation));
                    Object object = contentTypeValue = consumes.isEmpty() ? defaultContentType : (String)consumes.get(0);
                    if (((String)contentTypeValue).equals("*/*")) {
                        contentTypeValue = "application/json";
                    }
                    Parameter contentType = new Parameter("Content-Type", this.getDoubleQuotedString((String)contentTypeValue));
                    httpParams.add(contentType);
                    RequestBody requestBody = ModelUtils.getReferencedRequestBody(openAPI, operation.getRequestBody());
                    hasRequestBodyExample = this.hasRequestBodyExample(requestBody, (String)contentTypeValue);
                    if (hasRequestBodyExample) {
                        this.extractRequestBodyExample(requestBody, (String)contentTypeValue, bodyOrFormParams);
                    }
                    for (Map.Entry responseEntry : operation.getResponses().entrySet()) {
                        CodegenResponse r = this.fromResponse((String)responseEntry.getKey(), (ApiResponse)responseEntry.getValue());
                        if (r.baseType == null || this.defaultIncludes.contains(r.baseType) || this.languageSpecificPrimitives.contains(r.baseType)) continue;
                        imports.add(r.baseType);
                    }
                    if (!hasRequestBodyExample) {
                        List<CodegenParameter> formParameters = this.fromRequestBodyToFormParameters(requestBody, imports);
                        for (CodegenParameter parameter : formParameters) {
                            String reference = "";
                            if (parameter.isModel) {
                                Schema nestedSchema = ModelUtils.getSchema(openAPI, parameter.baseType);
                                CodegenModel model = this.fromModel(parameter.paramName, nestedSchema);
                                reference = this.generateNestedModelTemplate(model);
                                if (parameter.dataType.equals("List")) {
                                    reference = "[" + reference + "]";
                                }
                            }
                            Parameter k6Parameter = parameter.dataType.equals("File") ? new Parameter(parameter.paramName, "http.file(open(\"/path/to/file.bin\", \"b\"), \"test.bin\")") : new Parameter(parameter.paramName, !reference.isEmpty() ? reference : this.getDoubleQuotedString(parameter.dataType.toLowerCase(Locale.ROOT)));
                            bodyOrFormParams.add(k6Parameter);
                        }
                    }
                }
                String accepts = K6ClientCodegen.getAccept(openAPI, operation);
                String responseType = this.getDoubleQuotedString(accepts);
                try {
                    if (operation != null && operation.getParameters() != null) {
                        contentTypeValue = operation.getParameters().iterator();
                        while (contentTypeValue.hasNext()) {
                            io.swagger.v3.oas.models.parameters.Parameter parameter = (io.swagger.v3.oas.models.parameters.Parameter)contentTypeValue.next();
                            switch (parameter.getIn()) {
                                case "header": {
                                    httpParams.add(new Parameter(parameter.getName(), this.getTemplateString(this.toVarName(parameter.getName()))));
                                    extraParameters.add(new Parameter(this.toVarName(parameter.getName()), parameter.getName().toUpperCase(Locale.ROOT)));
                                    break;
                                }
                                case "path": 
                                case "query": {
                                    if (parameter.getIn().equals("query")) {
                                        queryParams.add(new Parameter(parameter.getName(), this.getTemplateVariable(parameter.getName())));
                                    }
                                    if (pathVariables.containsKey(path)) break;
                                    if (Objects.nonNull(parameter.getExample())) {
                                        hashSet.add(new Parameter(this.toVarName(parameter.getName()), parameter.getExample(), true));
                                        break;
                                    }
                                    if (Objects.nonNull(parameter.getExamples())) {
                                        hashSet.add(new Parameter(this.toVarName(parameter.getName()), parameter.getExamples(), true));
                                        break;
                                    }
                                    hashSet.add(new Parameter(this.toVarName(parameter.getName()), parameter.getName().toUpperCase(Locale.ROOT)));
                                    break;
                                }
                            }
                        }
                    }
                }
                catch (NullPointerException e) {
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                }
                pathVariables.put(groupName, hashSet);
                HTTPParameters params = new HTTPParameters(null, null, httpParams, null, null, null, null, null, responseType.length() > 0 ? responseType : null);
                assert (params.headers != null);
                Optional<DataExtractSubstituteParameter> dataExtract = this.getDataExtractSubstituteParameter(dataExtractSubstituteParams, operationId);
                Integer requestOrder = this.calculateRequestOrder(operationGroupingOrder, requests.size());
                requests.put(requestOrder, new HTTPRequest(method.toString().toLowerCase(Locale.ROOT), path, queryParams.size() > 0 ? queryParams : null, bodyOrFormParams.size() > 0 ? new HTTPBody(bodyOrFormParams) : null, hasRequestBodyExample, params.headers.size() > 0 ? params : null, k6Checks.size() > 0 ? k6Checks : null, dataExtract.orElse(null)));
            }
            this.addOrUpdateRequestGroup(requestGroups, groupName, (Set)pathVariables.get(groupName), requests);
        }
        for (HTTPRequestGroup requestGroup : requestGroups.values()) {
            for (HTTPRequest hTTPRequest : requestGroup.requests) {
                if (!hTTPRequest.path.contains("/{")) continue;
                hTTPRequest.path = hTTPRequest.path.replace("/{", "/${");
            }
            this.initializeDataExtractSubstituteParameters(dataExtractSubstituteParams, requestGroup);
        }
        this.additionalProperties.put("requestGroups", requestGroups.values());
        this.additionalProperties.put("extra", extraParameters);
        for (Iterator<Object> iterator : JAVASCRIPT_SUPPORTING_FILES) {
            Iterator<Object> templateFile = iterator[0];
            String folder = INVOKER_PKG_SUPPORTING_FILES.contains(templateFile) ? this.createPath(this.sourceFolder, this.invokerPackage) : "";
            this.supportingFiles.add(new SupportingFile((String)((Object)templateFile), folder, (String)((Object)iterator[1])));
        }
    }

    private String generateNestedModelTemplate(CodegenModel model) {
        StringBuilder reference = new StringBuilder();
        int modelEntrySetSize = model.getAllVars().size();
        for (CodegenProperty property : model.getAllVars()) {
            reference.append(this.getDoubleQuotedString(property.name)).append(": ").append(this.getDoubleQuotedString(property.dataType.toLowerCase(Locale.ROOT)));
            if (modelEntrySetSize <= 1) continue;
            reference.append(", ");
        }
        reference = new StringBuilder("{" + reference + "}");
        reference = new StringBuilder(reference.toString().replace(", }", "}"));
        return reference.toString();
    }

    private String getTemplateVariable(String input) {
        return "${" + input + "}";
    }

    public String getModelPropertyNaming() {
        return this.modelPropertyNaming;
    }

    private String getNameUsingModelPropertyNaming(String name) {
        switch (CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.valueOf(this.getModelPropertyNaming())) {
            case original: {
                return name;
            }
            case camelCase: {
                return StringUtils.camelize(name, CamelizeOption.LOWERCASE_FIRST_LETTER);
            }
            case PascalCase: {
                return StringUtils.camelize(name);
            }
            case snake_case: {
                return StringUtils.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid model property naming '" + name + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
    }

    @Override
    public String toVarName(String name) {
        if ("_".equals(name = this.sanitizeName(name))) {
            name = "_u";
        }
        if (name.matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = this.getNameUsingModelPropertyNaming(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    private String getTemplateString(String input) {
        return "`" + this.getTemplateVariable(input) + "`";
    }

    private String getDoubleQuotedString(String input) {
        return "\"" + input + "\"";
    }

    private String createPath(String ... segments) {
        StringBuilder buf = new StringBuilder();
        for (String segment : segments) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)segment) || segment.equals(".")) continue;
            if (buf.length() != 0) {
                buf.append(File.separatorChar);
            }
            buf.append(segment);
        }
        for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (c != '/' && c != '\\' || c == File.separatorChar) continue;
            buf.setCharAt(i, File.separatorChar);
        }
        return buf.toString();
    }

    @Override
    public String apiFileFolder() {
        return this.createPath(this.outputFolder, this.sourceFolder, this.invokerPackage, this.apiPackage());
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public void setModelPropertyNaming(String naming) {
        if (!("original".equals(naming) || "camelCase".equals(naming) || "PascalCase".equals(naming) || "snake_case".equals(naming))) {
            throw new IllegalArgumentException("Invalid model property naming '" + naming + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
        }
        this.modelPropertyNaming = naming;
    }

    public void setPreserveLeadingParamChar(boolean preserveLeadingParamChar) {
        this.preserveLeadingParamChar = preserveLeadingParamChar;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "").replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    private static String getAccept(OpenAPI openAPI, Operation operation) {
        String accepts = null;
        String defaultContentType = "application/json";
        Set<String> producesInfo = K6ClientCodegen.getProducesInfo(openAPI, operation);
        if (producesInfo != null && !producesInfo.isEmpty()) {
            ArrayList<String> produces = new ArrayList<String>(producesInfo);
            StringBuilder sb = new StringBuilder();
            for (String produce : produces) {
                if (defaultContentType.equalsIgnoreCase(produce)) {
                    accepts = defaultContentType;
                    break;
                }
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(produce);
            }
            if (accepts == null) {
                accepts = sb.toString();
            }
        } else {
            accepts = defaultContentType;
        }
        return accepts;
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"handleParamValue", (Object)new ParameterValueLambda());
    }

    private void addOrUpdateRequestGroup(Map<String, HTTPRequestGroup> requestGroups, String groupName, Set<Parameter> variables, Map<Integer, HTTPRequest> requests) {
        if (requestGroups.containsKey(groupName)) {
            HTTPRequestGroup existingHTTPRequestGroup = requestGroups.get(groupName);
            existingHTTPRequestGroup.addRequests(requests);
            existingHTTPRequestGroup.addVariables(variables);
        } else {
            requestGroups.put(groupName, new HTTPRequestGroup(groupName, variables, requests));
        }
    }

    private Map<String, DataExtractSubstituteParameter> getDataExtractSubstituteParameters(OpenAPI openAPI) {
        HashMap<String, DataExtractSubstituteParameter> dataExtractSubstituteParams = new HashMap<String, DataExtractSubstituteParameter>();
        for (String path : openAPI.getPaths().keySet()) {
            for (Map.Entry methodOperation : ((PathItem)openAPI.getPaths().get((Object)path)).readOperationsMap().entrySet()) {
                PathItem.HttpMethod method = (PathItem.HttpMethod)methodOperation.getKey();
                Operation operation = (Operation)methodOperation.getValue();
                CodegenOperation cgOperation = super.fromOperation(path, method.name(), operation, null);
                if (!cgOperation.getHasVendorExtensions() || !cgOperation.vendorExtensions.containsKey(X_OPERATION_DATAEXTRACT) || !(cgOperation.vendorExtensions.get(X_OPERATION_DATAEXTRACT) instanceof Map)) continue;
                Optional<DataExtractSubstituteParameter> dataExtractSubstituteParameter = this.getDataExtractSubstituteParameter((Map)cgOperation.vendorExtensions.get(X_OPERATION_DATAEXTRACT));
                dataExtractSubstituteParameter.ifPresent(extractSubstituteParameter -> dataExtractSubstituteParams.put(extractSubstituteParameter.operationId, (DataExtractSubstituteParameter)extractSubstituteParameter));
            }
        }
        return dataExtractSubstituteParams;
    }

    private Optional<DataExtractSubstituteParameter> getDataExtractSubstituteParameter(Map<?, ?> xOperationDataExtractProperties) {
        Optional<Object> operationId = Optional.empty();
        Optional<Object> valuePath = Optional.empty();
        Optional<Object> parameterName = Optional.empty();
        for (Map.Entry<?, ?> xOperationDataExtractPropertiesEntry : xOperationDataExtractProperties.entrySet()) {
            switch (String.valueOf(xOperationDataExtractPropertiesEntry.getKey())) {
                case "operationId": {
                    operationId = Optional.of(String.valueOf(xOperationDataExtractPropertiesEntry.getValue()));
                    break;
                }
                case "valuePath": {
                    valuePath = Optional.of(String.valueOf(xOperationDataExtractPropertiesEntry.getValue()));
                    break;
                }
                case "parameterName": {
                    parameterName = Optional.of(String.valueOf(xOperationDataExtractPropertiesEntry.getValue()));
                }
            }
        }
        if (operationId.isPresent() && valuePath.isPresent() && parameterName.isPresent()) {
            return Optional.of(new DataExtractSubstituteParameter((String)operationId.get(), (String)valuePath.get(), (String)parameterName.get()));
        }
        return Optional.empty();
    }

    private Optional<DataExtractSubstituteParameter> getDataExtractSubstituteParameter(Map<String, DataExtractSubstituteParameter> dataExtractSubstituteParams, String operationId) {
        return !dataExtractSubstituteParams.isEmpty() && dataExtractSubstituteParams.containsKey(operationId) ? Optional.of(dataExtractSubstituteParams.get(operationId)) : Optional.empty();
    }

    private Optional<OperationGrouping> extractOperationGrouping(CodegenOperation cgOperation) {
        Map.Entry operationGroupingEntry;
        Optional<OperationGrouping> operationGrouping = Optional.empty();
        if (cgOperation.getHasVendorExtensions() && cgOperation.vendorExtensions.containsKey(X_OPERATION_GROUPING) && cgOperation.vendorExtensions.get(X_OPERATION_GROUPING) instanceof Map && (operationGroupingEntry = (Map.Entry)((Map)cgOperation.vendorExtensions.get(X_OPERATION_GROUPING)).entrySet().stream().findFirst().orElse(null)) != null) {
            return Optional.of(new OperationGrouping(String.valueOf(operationGroupingEntry.getKey()), Integer.parseInt(String.valueOf(operationGroupingEntry.getValue()))));
        }
        return operationGrouping;
    }

    private boolean shouldHideOperationResponse(ApiResponse resp) {
        Map respExtensions;
        Map.Entry entry;
        boolean hideOperationResponse = false;
        if (Objects.nonNull(resp.getExtensions()) && !resp.getExtensions().isEmpty() && resp.getExtensions().containsKey(X_OPERATION_RESPONSE) && (entry = (Map.Entry)(respExtensions = (Map)resp.getExtensions().get(X_OPERATION_RESPONSE)).entrySet().stream().findFirst().orElse(null)) != null && entry.getKey().equals(X_OPERATION_RESPONSE_HIDE)) {
            return Boolean.parseBoolean(String.valueOf(entry.getValue()));
        }
        return false;
    }

    private boolean hasRequestBodyExample(RequestBody requestBody, String contentTypeValue) {
        return Objects.nonNull(requestBody.getContent()) && requestBody.getContent().containsKey((Object)contentTypeValue) && Objects.nonNull(((MediaType)requestBody.getContent().get((Object)contentTypeValue)).getExamples()) && !((MediaType)requestBody.getContent().get((Object)contentTypeValue)).getExamples().isEmpty();
    }

    private void extractRequestBodyExample(RequestBody requestBody, String contentTypeValue, List<Parameter> bodyOrFormParams) {
        Optional requestBodyExampleEntry = ((MediaType)requestBody.getContent().get((Object)contentTypeValue)).getExamples().entrySet().stream().findFirst();
        if (requestBodyExampleEntry.isPresent()) {
            Example requestBodyExample = (Example)((Map.Entry)requestBodyExampleEntry.get()).getValue();
            try {
                JsonNode requestBodyExampleValueJsonNode = Json.mapper().readTree(String.valueOf(requestBodyExample.getValue()));
                Iterator fields = requestBodyExampleValueJsonNode.fields();
                while (fields.hasNext()) {
                    Map.Entry fieldsEntry = (Map.Entry)fields.next();
                    JsonNode exampleValueAsJsonNode = (JsonNode)fieldsEntry.getValue();
                    Parameter k6Parameter = new Parameter((String)fieldsEntry.getKey(), exampleValueAsJsonNode.isNumber() ? exampleValueAsJsonNode.asText() : exampleValueAsJsonNode.toString());
                    bodyOrFormParams.add(k6Parameter);
                }
            }
            catch (JsonProcessingException e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Integer calculateRequestOrder(OptionalInt operationGroupingOrder, int requestsSize) {
        int requestOrder;
        if (operationGroupingOrder.isPresent()) {
            requestOrder = operationGroupingOrder.getAsInt() - 1;
        } else {
            switch (requestsSize) {
                case 0: 
                case 1: {
                    requestOrder = requestsSize;
                    break;
                }
                default: {
                    requestOrder = requestsSize - 1;
                }
            }
        }
        return requestOrder;
    }

    private void initializeDataExtractSubstituteParameters(Map<String, DataExtractSubstituteParameter> dataExtractSubstituteParams, HTTPRequestGroup requestGroup) {
        if (!dataExtractSubstituteParams.isEmpty()) {
            Set existingVariablesNames = requestGroup.variables.stream().map(v -> v.key).collect(Collectors.toSet());
            Set initializeVariables = dataExtractSubstituteParams.values().stream().filter(p -> !existingVariablesNames.contains(this.toVarName(p.paramName))).collect(Collectors.toSet());
            for (DataExtractSubstituteParameter initializeVariable : initializeVariables) {
                requestGroup.variables.add(new Parameter(this.toVarName(initializeVariable.paramName), true));
            }
        }
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.K_SIX;
    }

    public static class HTTPRequestGroup {
        String groupName;
        Set<Parameter> variables;
        List<HTTPRequest> requests;
        private final Map<Integer, HTTPRequest> requestsMap;

        public HTTPRequestGroup(String groupName, Set<Parameter> variables, Map<Integer, HTTPRequest> requestsMap) {
            this.groupName = groupName;
            this.variables = variables;
            this.requestsMap = requestsMap;
            this.requests = this.sortRequests(requestsMap);
        }

        private void addRequests(Map<Integer, HTTPRequest> moreRequests) {
            this.requestsMap.putAll(moreRequests);
            this.requests = this.sortRequests(this.requestsMap);
        }

        private void addVariables(Set<Parameter> moreVariables) {
            this.variables.addAll(moreVariables);
        }

        private List<HTTPRequest> sortRequests(Map<Integer, HTTPRequest> requestsMap) {
            return new ArrayList<HTTPRequest>(new TreeMap<Integer, HTTPRequest>(requestsMap).values());
        }
    }

    static class HTTPRequest {
        String method;
        boolean isDelete;
        String path;
        @Nullable
        List<Parameter> query;
        @Nullable
        HTTPBody body;
        boolean hasBodyExample;
        @Nullable
        HTTPParameters params;
        @Nullable
        List<k6Check> k6Checks;
        @Nullable
        DataExtractSubstituteParameter dataExtract;

        public HTTPRequest(String method, String path, @Nullable List<Parameter> query, @Nullable HTTPBody body, boolean hasBodyExample, @Nullable HTTPParameters params, @Nullable List<k6Check> k6Checks, DataExtractSubstituteParameter dataExtract) {
            this.method = method.equals("delete") ? "del" : method;
            this.isDelete = method.equals("delete");
            this.path = path;
            this.query = query;
            this.body = body;
            this.hasBodyExample = hasBodyExample;
            this.params = params;
            this.k6Checks = k6Checks;
            this.dataExtract = dataExtract;
        }
    }

    static class k6Check {
        Integer status;
        String description;

        public k6Check(Integer status, String description) {
            this.status = status;
            this.description = description;
        }
    }

    static class HTTPParameters {
        @Nullable
        String auth;
        @Nullable
        List<Parameter> cookies;
        @Nullable
        List<Parameter> headers;
        @Nullable
        List<Parameter> jar;
        @Nullable
        Integer redirects;
        @Nullable
        List<Parameter> tags;
        @Nullable
        Integer timeout;
        @Nullable
        String compression;
        @Nullable
        String responseType;

        public HTTPParameters(@Nullable String auth, @Nullable List<Parameter> cookies, @Nullable List<Parameter> headers, @Nullable List<Parameter> jar, @Nullable Integer redirects, @Nullable List<Parameter> tags, @Nullable Integer timeout, @Nullable String compression, @Nullable String responseType) {
            this.auth = auth;
            this.cookies = cookies;
            this.headers = headers;
            this.jar = jar;
            this.redirects = redirects;
            this.tags = tags;
            this.timeout = timeout;
            this.compression = compression;
            this.responseType = responseType;
        }
    }

    static class HTTPBody {
        List<Parameter> parameters;

        public HTTPBody(List<Parameter> parameters) {
            this.parameters = parameters;
        }
    }

    static class ParameterValueLambda
    implements Mustache.Lambda {
        private static final String NO_EXAMPLE_PARAM_VALUE_PREFIX = "TODO_EDIT_THE_";

        ParameterValueLambda() {
        }

        public void execute(Template.Fragment fragment, Writer writer) throws IOException {
            String noExampleParamValue = String.join((CharSequence)"", ParameterValueLambda.quoteExample(String.join((CharSequence)"", NO_EXAMPLE_PARAM_VALUE_PREFIX, fragment.execute())), ";", " // specify value as there is no example value for this parameter in OpenAPI spec");
            if (fragment.context() instanceof Parameter && ((Parameter)fragment.context()).hasExample) {
                Object rawValue = ((Parameter)fragment.context()).value;
                if (rawValue instanceof Map) {
                    Set exampleValues = ((Map)rawValue).values().stream().map(x -> ParameterValueLambda.quoteExample(StringEscapeUtils.escapeEcmaScript((String)String.valueOf(x.getValue())))).collect(Collectors.toCollection(TreeSet::new));
                    if (!exampleValues.isEmpty()) {
                        writer.write(String.join((CharSequence)"", Arrays.toString(exampleValues.toArray()), ".shift();", " // first element from list extracted from 'examples' field defined at the parameter level of OpenAPI spec"));
                    } else {
                        writer.write(noExampleParamValue);
                    }
                } else {
                    writer.write(String.join((CharSequence)"", ParameterValueLambda.quoteExample(StringEscapeUtils.escapeEcmaScript((String)String.valueOf(((Parameter)fragment.context()).value))), ";", " // extracted from 'example' field defined at the parameter level of OpenAPI spec"));
                }
            } else if (fragment.context() instanceof Parameter && ((Parameter)fragment.context()).initialize) {
                writer.write(String.join((CharSequence)"", "null", ";", " // parameter initialized for subsequent data extraction"));
            } else {
                writer.write(noExampleParamValue);
            }
        }

        private static String quoteExample(String exampleValue) {
            return org.apache.commons.lang3.StringUtils.wrap((String)exampleValue, (String)"'");
        }
    }

    static class DataExtractSubstituteParameter {
        String operationId;
        String valuePath;
        String paramName;

        public DataExtractSubstituteParameter(String operationId, String valuePath, String paramName) {
            this.operationId = operationId;
            this.valuePath = valuePath;
            this.paramName = paramName;
        }
    }

    static class OperationGrouping {
        String groupName;
        int order;

        public OperationGrouping(String groupName, int order) {
            this.groupName = groupName;
            this.order = order;
        }
    }

    static class Parameter {
        String key;
        Object value;
        boolean hasExample;
        boolean initialize;

        public Parameter(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Parameter(String key, Object exampleValue, boolean hasExample) {
            this.key = key;
            this.value = exampleValue;
            this.hasExample = hasExample;
        }

        public Parameter(String key, boolean initialize) {
            this.key = key;
            this.initialize = initialize;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter p = (Parameter)obj;
            return this.key.equals(p.key) && this.value.equals(p.value) && this.hasExample == p.hasExample && this.initialize == p.initialize;
        }
    }
}

