/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPhpCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpDataTransferClientCodegen
extends AbstractPhpCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(PhpDataTransferClientCodegen.class);
    public static final String OPT_MODERN = "modern";
    public static final String VEN_PARAMETER_LOCATION = "internal.parameterLocation";
    public static final String VEN_FROM_PARAMETERS = "internal.fromParameters";
    public static final String VEN_COLLECTION_FORMAT = "internal.collectionFormat";
    public static final String VEN_PARAMETER_DATA_TYPE = "internal.parameterDataType";
    public static final String VEN_HAS_PARAMETER_DATA = "internal.hasParameterData";
    public static final String VEN_FROM_CONTAINER = "internal.fromContainer";
    public static final String VEN_CONTAINER_DATA_TYPE = "internal.containerDataType";
    private boolean useModernSyntax = false;

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "php-dt";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP client relying on Data Transfer ( https://github.com/Articus/DataTransfer ) and compliant with PSR-7, PSR-11, PSR-17 and PSR-18.";
    }

    public PhpDataTransferClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.BearerToken, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.languageSpecificPrimitives.remove("\\DateTime");
        this.languageSpecificPrimitives.remove("\\SplFileObject");
        this.typeMapping.put("date", "\\DateTimeInterface");
        this.typeMapping.put("Date", "\\DateTimeInterface");
        this.typeMapping.put("DateTime", "\\DateTimeInterface");
        this.typeMapping.put("file", "string");
        this.apiTemplateFiles.clear();
        this.apiTestTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.modelTestTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.additionalProperties.put("artifactVersion", "1.0.0");
        this.addSwitch(OPT_MODERN, "use modern language features (generated code will require PHP 8.1)", this.useModernSyntax);
    }

    @Override
    public void processOpts() {
        this.setSrcBasePath("src");
        String rootNamespace = "App";
        if (this.additionalProperties.containsKey("invokerPackage")) {
            rootNamespace = (String)this.additionalProperties.get("invokerPackage");
        }
        Object modelNamespace = rootNamespace + "\\DTO";
        if (this.additionalProperties.containsKey("modelPackage")) {
            modelNamespace = (String)this.additionalProperties.get("modelPackage");
        }
        super.processOpts();
        this.setInvokerPackage(rootNamespace);
        this.additionalProperties.put("invokerPackage", rootNamespace);
        this.setModelPackage((String)modelNamespace);
        this.additionalProperties.put("modelPackage", modelNamespace);
        if (this.additionalProperties.containsKey(OPT_MODERN)) {
            this.templateDir = "php-dt-modern";
            this.embeddedTemplateDir = "php-dt-modern";
            this.useModernSyntax = true;
        } else {
            this.templateDir = "php-dt";
            this.embeddedTemplateDir = "php-dt";
        }
        this.supportingFiles.add(new SupportingFile("composer.json.mustache", "", "composer.json"));
        this.supportingFiles.add(new SupportingFile("ApiClient.php.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "ApiClient.php"));
        this.supportingFiles.add(new SupportingFile("ApiClientFactory.php.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "ApiClientFactory.php"));
        this.supportingFiles.add(new SupportingFile("README.md.mustache", "", "README.md"));
    }

    @Override
    public String toSrcPath(String packageName, String basePath) {
        return basePath + File.separator + packageName.replace("\\", File.separator);
    }

    @Override
    public String toApiName(String name) {
        return super.toApiName(this.toModelName(name));
    }

    @Override
    public String toRegularExpression(String pattern) {
        String result = super.toRegularExpression(pattern);
        if (result != null && !this.useModernSyntax) {
            result = result.replace("\\\\", "\\").replace("\\\"", "\"\"");
        }
        return result;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        Map extensions = p.getExtensions();
        String result = extensions != null && extensions.containsKey(VEN_CONTAINER_DATA_TYPE) ? (String)extensions.get(VEN_CONTAINER_DATA_TYPE) : (ModelUtils.isArraySchema(p) || ModelUtils.isMapSchema(p) ? "array" : super.getTypeDeclaration(p));
        return result;
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        super.addOperationToGroup("", resourcePath, operation, co, operations);
    }

    @Override
    protected String getContentType(RequestBody requestBody) {
        return null;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        this.generateParameterSchemas(openAPI);
        this.generateContainerSchemas(openAPI);
    }

    @Override
    public void processOpenAPI(OpenAPI openAPI) {
        super.processOpenAPI(openAPI);
        this.quoteMediaTypes(openAPI);
    }

    protected void generateParameterSchemas(OpenAPI openAPI) {
        Paths paths = openAPI.getPaths();
        if (paths != null) {
            for (Map.Entry pathsEntry : paths.entrySet()) {
                String pathname = (String)pathsEntry.getKey();
                PathItem path = (PathItem)pathsEntry.getValue();
                Map operationMap = path.readOperationsMap();
                if (operationMap == null) continue;
                for (Map.Entry operationMapEntry : operationMap.entrySet()) {
                    PathItem.HttpMethod method = (PathItem.HttpMethod)operationMapEntry.getKey();
                    Operation operation = (Operation)operationMapEntry.getValue();
                    HashMap<String, Schema> propertySchemas = new HashMap<String, Schema>();
                    if (operation == null || operation.getParameters() == null) continue;
                    ArrayList<String> requiredProperties = new ArrayList<String>();
                    for (Parameter parameter : operation.getParameters()) {
                        Parameter referencedParameter = ModelUtils.getReferencedParameter(openAPI, parameter);
                        Schema propertySchema = this.convertParameterToSchema(openAPI, referencedParameter);
                        if (propertySchema == null) continue;
                        propertySchemas.put(propertySchema.getName(), propertySchema);
                        if (!Boolean.TRUE.equals(referencedParameter.getRequired())) continue;
                        requiredProperties.add(propertySchema.getName());
                    }
                    if (propertySchemas.isEmpty()) continue;
                    ObjectSchema schema = new ObjectSchema();
                    String operationId = this.getOrGenerateOperationId(operation, pathname, method.name());
                    schema.setDescription("Parameters for " + operationId);
                    schema.setProperties(propertySchemas);
                    schema.setRequired(requiredProperties);
                    this.addInternalExtensionToSchema((Schema)schema, VEN_FROM_PARAMETERS, Boolean.TRUE);
                    String schemaName = this.generateUniqueSchemaName(openAPI, operationId + "ParameterData");
                    openAPI.getComponents().addSchemas(schemaName, (Schema)schema);
                    String schemaDataType = this.getTypeDeclaration(this.toModelName(schemaName));
                    this.addInternalExtensionToOperation(operation, VEN_PARAMETER_DATA_TYPE, schemaDataType);
                    this.addInternalExtensionToOperation(operation, VEN_HAS_PARAMETER_DATA, Boolean.TRUE);
                }
            }
        }
    }

    protected Schema convertParameterToSchema(OpenAPI openAPI, Parameter parameter) {
        BooleanSchema property = null;
        Schema parameterSchema = ModelUtils.getReferencedSchema(openAPI, parameter.getSchema());
        if (ModelUtils.isArraySchema(parameterSchema)) {
            Schema itemSchema = ((ArraySchema)parameterSchema).getItems();
            ArraySchema arraySchema = new ArraySchema();
            arraySchema.setMinItems(parameterSchema.getMinItems());
            arraySchema.setMaxItems(parameterSchema.getMaxItems());
            arraySchema.setItems(itemSchema);
            String collectionFormat = this.getCollectionFormat(parameter);
            if (collectionFormat == null) {
                collectionFormat = "csv";
            }
            this.addInternalExtensionToSchema((Schema)arraySchema, VEN_COLLECTION_FORMAT, collectionFormat);
            property = arraySchema;
        } else {
            switch (parameterSchema.getType()) {
                case "string": {
                    StringSchema stringSchema = new StringSchema();
                    stringSchema.setMinLength(parameterSchema.getMinLength());
                    stringSchema.setMaxLength(parameterSchema.getMaxLength());
                    stringSchema.setPattern(parameterSchema.getPattern());
                    stringSchema.setEnum(parameterSchema.getEnum());
                    property = stringSchema;
                    break;
                }
                case "integer": {
                    IntegerSchema integerSchema = new IntegerSchema();
                    integerSchema.setMinimum(parameterSchema.getMinimum());
                    integerSchema.setMaximum(parameterSchema.getMaximum());
                    property = integerSchema;
                    break;
                }
                case "number": {
                    NumberSchema floatSchema = new NumberSchema();
                    floatSchema.setMinimum(parameterSchema.getMinimum());
                    floatSchema.setMaximum(parameterSchema.getMaximum());
                    property = floatSchema;
                    break;
                }
                case "boolean": {
                    property = new BooleanSchema();
                    break;
                }
                case "date": {
                    property = new DateSchema();
                    break;
                }
                case "date-time": {
                    property = new DateTimeSchema();
                }
            }
        }
        if (property != null) {
            property.setName(parameter.getName());
            property.setDescription(parameter.getDescription());
            this.addInternalExtensionToSchema((Schema)property, VEN_PARAMETER_LOCATION, parameter.getIn());
        }
        return property;
    }

    protected void addInternalExtensionToSchema(Schema schema, String name, Object value) {
        if (schema.getExtensions() == null) {
            schema.setExtensions(new HashMap());
        }
        schema.getExtensions().put(name, value);
    }

    protected void addInternalExtensionToOperation(Operation operation, String name, Object value) {
        if (operation.getExtensions() == null) {
            operation.setExtensions(new HashMap());
        }
        operation.getExtensions().put(name, value);
    }

    protected String generateUniqueSchemaName(OpenAPI openAPI, String name) {
        Object result = name;
        if (openAPI.getComponents().getSchemas() != null) {
            int count = 1;
            while (openAPI.getComponents().getSchemas().containsKey(result)) {
                result = name + "_" + count;
                ++count;
            }
        }
        return result;
    }

    protected void generateContainerSchemas(OpenAPI openAPI) {
        HashSet<Schema> visitedSchemas = new HashSet<Schema>();
        Paths paths = openAPI.getPaths();
        for (String pathName : paths.keySet()) {
            for (Operation operation : ((PathItem)paths.get((Object)pathName)).readOperations()) {
                Content requestBodyContent;
                RequestBody requestBody;
                List parameters = operation.getParameters();
                if (parameters != null) {
                    for (Parameter parameter : parameters) {
                        this.generateContainerSchemas(openAPI, visitedSchemas, ModelUtils.getReferencedParameter(openAPI, parameter).getSchema());
                    }
                }
                if ((requestBody = ModelUtils.getReferencedRequestBody(openAPI, operation.getRequestBody())) != null && (requestBodyContent = requestBody.getContent()) != null) {
                    for (String mediaTypeName : requestBodyContent.keySet()) {
                        this.generateContainerSchemas(openAPI, visitedSchemas, ((MediaType)requestBodyContent.get((Object)mediaTypeName)).getSchema());
                    }
                }
                ApiResponses responses = operation.getResponses();
                for (String responseCode : responses.keySet()) {
                    ApiResponse response = ModelUtils.getReferencedApiResponse(openAPI, (ApiResponse)responses.get((Object)responseCode));
                    Content responseContent = response.getContent();
                    if (responseContent == null) continue;
                    for (String mediaTypeName : responseContent.keySet()) {
                        this.generateContainerSchemas(openAPI, visitedSchemas, ((MediaType)responseContent.get((Object)mediaTypeName)).getSchema());
                    }
                }
            }
        }
    }

    protected void generateContainerSchemas(OpenAPI openAPI, Set<Schema> visitedSchemas, Schema schema) {
        if (visitedSchemas.contains(schema)) {
            return;
        }
        visitedSchemas.add(schema);
        if (schema != null) {
            schema = ModelUtils.getReferencedSchema(openAPI, schema);
            Boolean isContainer = Boolean.FALSE;
            if (ModelUtils.isObjectSchema(schema)) {
                Map properties = schema.getProperties();
                if (properties != null) {
                    for (String propertyName : properties.keySet()) {
                        this.generateContainerSchemas(openAPI, visitedSchemas, (Schema)properties.get(propertyName));
                    }
                }
            } else if (ModelUtils.isArraySchema(schema)) {
                this.generateContainerSchemas(openAPI, visitedSchemas, ((ArraySchema)schema).getItems());
                isContainer = Boolean.TRUE;
            } else if (ModelUtils.isMapSchema(schema)) {
                Object itemSchema = schema.getAdditionalProperties();
                if (itemSchema instanceof Schema) {
                    this.generateContainerSchemas(openAPI, visitedSchemas, (Schema)itemSchema);
                }
                isContainer = Boolean.TRUE;
            }
            if (isContainer.booleanValue()) {
                String containerSchemaName = this.generateUniqueSchemaName(openAPI, "Collection");
                ObjectSchema containerSchema = new ObjectSchema();
                containerSchema.addProperty("inner", schema);
                this.addInternalExtensionToSchema((Schema)containerSchema, VEN_FROM_CONTAINER, Boolean.TRUE);
                openAPI.getComponents().addSchemas(containerSchemaName, (Schema)containerSchema);
                String containerDataType = this.getTypeDeclaration(this.toModelName(containerSchemaName));
                this.addInternalExtensionToSchema(schema, VEN_CONTAINER_DATA_TYPE, containerDataType);
            }
        }
    }

    protected void quoteMediaTypes(OpenAPI openAPI) {
        Paths paths = openAPI.getPaths();
        if (paths != null) {
            for (Map.Entry pathsEntry : paths.entrySet()) {
                String pathname = (String)pathsEntry.getKey();
                PathItem path = (PathItem)pathsEntry.getValue();
                List operations = path.readOperations();
                if (operations == null) continue;
                for (Operation operation : operations) {
                    RequestBody requestBody = ModelUtils.getReferencedRequestBody(openAPI, operation.getRequestBody());
                    if (requestBody != null) {
                        requestBody.setContent(this.copyWithQuotedMediaTypes(requestBody.getContent()));
                    }
                    ApiResponses responses = operation.getResponses();
                    for (String responseCode : responses.keySet()) {
                        ApiResponse response = ModelUtils.getReferencedApiResponse(openAPI, (ApiResponse)responses.get((Object)responseCode));
                        response.setContent(this.copyWithQuotedMediaTypes(response.getContent()));
                    }
                }
            }
        }
    }

    protected Content copyWithQuotedMediaTypes(Content content) {
        Content result = null;
        if (content != null) {
            result = new Content();
            for (String mediaType : content.keySet()) {
                result.addMediaType("'" + mediaType + "'", (MediaType)content.get((Object)mediaType));
            }
        }
        return result;
    }
}

