/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.pattern;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.iface.Lockable;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.pattern.provider.DataProvider;

public interface Remote<M>
extends Shutdownable,
Activatable,
Lockable,
DataProvider<M> {
    public void activate(boolean var1) throws CouldNotPerformException, InterruptedException;

    public void addConnectionStateObserver(Observer<ConnectionState> var1);

    public void removeConnectionStateObserver(Observer<ConnectionState> var1);

    @Override
    public Class<M> getDataClass();

    @Override
    public M getData() throws NotAvailableException;

    @Override
    default public CompletableFuture<M> getDataFuture() {
        try {
            if (!this.isDataAvailable()) {
                return this.requestData();
            }
            return CompletableFuture.completedFuture(this.getData());
        }
        catch (CouldNotPerformException ex) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(ex);
            return future;
        }
    }

    @Override
    public void waitForData() throws CouldNotPerformException, InterruptedException;

    @Override
    public void waitForData(long var1, TimeUnit var3) throws CouldNotPerformException, InterruptedException;

    public boolean isConnected();

    public ConnectionState getConnectionState();

    public CompletableFuture<M> requestData() throws CouldNotPerformException;

    public static enum ConnectionState {
        UNKNOWN,
        CONNECTING,
        CONNECTED,
        DISCONNECTED,
        RECONNECTING;

    }
}

