/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.pattern.statemachine;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.iface.Initializable;
import org.openbase.jul.pattern.statemachine.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateRunner
implements Runnable,
Initializable<Class<? extends State>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateRunner.class);
    public static final String STATE_CHANGE = "StateChange";
    public static final String STATE_ERROR = "StateError";
    private final Map<Class<? extends State>, State> stateMap = new HashMap<Class<? extends State>, State>();
    private final PropertyChangeSupport change = new PropertyChangeSupport(this);
    private State currentState;

    public void init(Class<? extends State> stateClass) throws InitializationException {
        try {
            this.currentState = this.getState(stateClass);
            this.change.firePropertyChange(STATE_CHANGE, null, this.currentState.getClass());
        }
        catch (NotAvailableException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    @Override
    public synchronized void run() {
        LOGGER.info("run " + this.currentState.getClass().getSimpleName() + "...");
        if (this.currentState == null) {
            throw new IllegalStateException("No initial state defined.");
        }
        while (this.currentState != null) {
            Object nextStateClass;
            LOGGER.debug("execute " + this.currentState);
            try {
                nextStateClass = this.currentState.call();
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Somthing went wrong during state execution!", (Throwable)ex, (Logger)LOGGER);
                if (!Thread.currentThread().isInterrupted()) continue;
                return;
            }
            catch (Throwable t) {
                ExceptionPrinter.printHistory((String)"State failed: ", (Throwable)t, (Logger)LOGGER);
                this.change.firePropertyChange(STATE_ERROR, this.currentState.getClass(), t.getMessage());
                return;
            }
            this.change.firePropertyChange(STATE_CHANGE, this.currentState.getClass(), nextStateClass);
            if (nextStateClass == null) continue;
            LOGGER.info("StateChange: " + this.currentState.getClass().getSimpleName() + " -> " + ((Class)nextStateClass).getSimpleName());
            try {
                this.currentState = this.getState((Class<? extends State>)nextStateClass);
            }
            catch (NotAvailableException ex) {
                ExceptionPrinter.printHistory((String)"State change failed!", (Throwable)ex, (Logger)LOGGER);
            }
        }
        LOGGER.info("finished execution.");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.change.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.change.removePropertyChangeListener(listener);
    }

    private State getState(Class<? extends State> stateClass) throws NotAvailableException {
        if (!this.stateMap.containsKey(stateClass)) {
            try {
                State state;
                try {
                    state = stateClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    throw new CouldNotPerformException("Could not create instance of " + stateClass.getName(), (Throwable)ex);
                }
                this.stateMap.put(stateClass, state);
                return state;
            }
            catch (CouldNotPerformException ex) {
                throw new NotAvailableException("State[" + stateClass.getSimpleName() + "]", (Throwable)ex);
            }
        }
        return this.stateMap.get(stateClass);
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public boolean isCurrentState(Class clazz) {
        return this.currentState.getClass().equals(clazz);
    }
}

