/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.processing;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.processing.FileProcessor;

public class JSonObjectFileProcessor<DT>
implements FileProcessor<DT> {
    private final ObjectMapper mapper;
    private final JsonFactory jsonFactory;
    private final Class<DT> dataTypeClass;

    public JSonObjectFileProcessor(Class<DT> dataTypeClass) {
        this.dataTypeClass = dataTypeClass;
        this.jsonFactory = new JsonFactory();
        this.jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        this.mapper = new ObjectMapper(this.jsonFactory);
        this.mapper.enableDefaultTyping();
        this.mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT);
        this.mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        this.mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    @Override
    public File serialize(DT data, File file) throws CouldNotPerformException {
        try {
            JsonGenerator generator = this.jsonFactory.createGenerator(file, JsonEncoding.UTF8);
            generator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            this.mapper.writeValue(generator, data);
            return file;
        }
        catch (IOException | NullPointerException ex) {
            throw new CouldNotPerformException("Could not serialize " + data.getClass().getSimpleName() + " into " + file + "!", (Throwable)ex);
        }
    }

    @Override
    public DT deserialize(File file, DT message) throws CouldNotPerformException {
        return this.deserialize(file);
    }

    @Override
    public DT deserialize(File file) throws CouldNotPerformException {
        return this.deserialize(file, this.dataTypeClass);
    }

    @Override
    public <T> T deserialize(File file, Class<T> clazz) throws CouldNotPerformException {
        try {
            JsonParser parser = this.jsonFactory.createParser(file);
            return (T)this.mapper.readValue(parser, clazz);
        }
        catch (IOException | NullPointerException ex) {
            throw new CouldNotPerformException("Could not deserialize " + clazz.getSimpleName() + " from " + file + "!", (Throwable)ex);
        }
    }
}

