/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.processing;

public class StringProcessor {
    public static String insertSpaceBetweenCamelCase(String input) {
        String output = "";
        String[] split = input.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        for (int i = 0; i < split.length; ++i) {
            output = output + (i + 1 < split.length && !split[i].endsWith(" ") ? split[i] + " " : split[i]);
        }
        return output;
    }

    public static String removeDoubleWhiteSpaces(String input) {
        return input.replaceAll("\\s+", " ");
    }

    public static String formatHumanReadable(String input) {
        return StringProcessor.removeDoubleWhiteSpaces(StringProcessor.insertSpaceBetweenCamelCase(input)).trim();
    }

    public static String transformUpperCaseToCamelCase(String input) {
        String output = "";
        for (String component : input.split("(_| )")) {
            if (component.isEmpty()) continue;
            output = output + component.substring(0, 1).toUpperCase() + component.substring(1).toLowerCase();
        }
        return output;
    }

    public static String transformToCamelCase(String input) {
        return StringProcessor.transformUpperCaseToCamelCase(StringProcessor.transformToUpperCase(StringProcessor.replaceHyphenWithUnderscore(input)));
    }

    public static String replaceHyphenWithUnderscore(String input) {
        return input.replaceAll("-", "_");
    }

    public static String transformToUpperCase(String input) {
        input = StringProcessor.removeDoubleWhiteSpaces(input.trim());
        String output = input.replaceAll("([a-z])([A-Z])", "$1_$2");
        output = output.replaceAll(" ", "_");
        return output.replaceAll("__", "_").toUpperCase();
    }

    public static String transformFirstCharToUpperCase(String input) {
        if (input.isEmpty()) {
            return "";
        }
        if (input.length() == 1) {
            return input.toUpperCase();
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static String fillWithSpaces(String input, int lenght) {
        return StringProcessor.fillWithSpaces(input, lenght, Alignment.LEFT);
    }

    public static String fillWithSpaces(String input, int lenght, Alignment textAlignment) {
        String spaces = "";
        for (int i = lenght - input.length(); i > 0; --i) {
            spaces = spaces + " ";
        }
        switch (textAlignment) {
            case RIGHT: {
                return spaces + input;
            }
            case CENTER: {
                int half_spaces_size = (lenght - input.length()) / 2;
                return spaces.substring(0, half_spaces_size - 1) + input + spaces.substring(half_spaces_size, spaces.length());
            }
        }
        return input + spaces;
    }

    public static String transformToIdString(String input) {
        input = StringProcessor.removeDoubleWhiteSpaces(input);
        input = input.replaceAll("\u00e4", "ae");
        input = input.replaceAll("\u00f6", "oe");
        input = input.replaceAll("\u00fc", "ue");
        input = input.replaceAll("\u00df", "ss");
        input = input.replaceAll("[^0-9a-zA-Z-_]+", "_");
        return input;
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

