/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.processing;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.processing.VariableProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VariableProcessor {
    private static final Logger logger = LoggerFactory.getLogger(VariableProcessor.class);

    private VariableProcessor() {
    }

    public static String resolveVariables(String context, boolean throwOnError, Collection<VariableProvider> providers) throws MultiException {
        VariableProvider[] providerArray = new VariableProvider[providers.size()];
        return VariableProcessor.resolveVariables(context, throwOnError, providers.toArray(providerArray));
    }

    public static String resolveVariables(String context, boolean throwOnError, VariableProvider ... providers) throws MultiException {
        String variableIdentifier;
        MultiException.ExceptionStack exceptionStack = null;
        while (!Thread.interrupted() && (variableIdentifier = StringUtils.substringBetween((String)context, (String)"${", (String)"}")) != null) {
            String variableValue = "";
            for (VariableProvider provider : providers) {
                try {
                    variableValue = provider.getValue(variableIdentifier);
                    if (variableValue == null) continue;
                    logger.debug("Variable[" + variableIdentifier + "] = Value[" + variableValue + "] resolved by Provider[" + provider.getName() + "].");
                    break;
                }
                catch (NotAvailableException ex) {
                    // empty catch block
                }
            }
            if (variableValue == null || variableValue.isEmpty()) {
                exceptionStack = MultiException.push(VariableProcessor.class, (Exception)((Object)new NotAvailableException("Variable[" + variableIdentifier + "]")), exceptionStack);
                variableValue = "";
            }
            context = StringUtils.replace((String)context, (String)("${" + variableIdentifier + "}"), (String)variableValue);
        }
        try {
            MultiException.checkAndThrow((String)"Could not resolve all variables!", exceptionStack);
        }
        catch (MultiException ex) {
            if (throwOnError) {
                throw ex;
            }
            if (JPService.testMode()) {
                return context;
            }
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)logger);
        }
        return context;
    }

    public static String resolveVariable(String variable, Collection<VariableProvider> providers) throws MultiException {
        VariableProvider[] providerArray = new VariableProvider[providers.size()];
        return VariableProcessor.resolveVariable(variable, providers.toArray(providerArray));
    }

    public static String resolveVariable(String variable, VariableProvider ... providers) throws MultiException {
        MultiException.ExceptionStack exceptionStack = null;
        for (VariableProvider provider : providers) {
            try {
                return provider.getValue(variable);
            }
            catch (NotAvailableException ex) {
                exceptionStack = MultiException.push(VariableProcessor.class, (Exception)((Object)ex), exceptionStack);
            }
        }
        MultiException.checkAndThrow((String)("Could not resolve Variable[" + variable + "]!"), (MultiException.ExceptionStack)exceptionStack);
        throw new AssertionError((Object)"Fatal error during variable resolving.");
    }
}

