/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.processing;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.processing.VariableProvider;

public class VariableStore
implements VariableProvider {
    private final String name;
    private final Map<String, String> variableMap;

    public VariableStore(String name) {
        this.name = name;
        this.variableMap = new TreeMap<String, String>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue(String key) throws NotAvailableException {
        return this.variableMap.get(key);
    }

    @Override
    public Map<String, String> getValues(String variableContains) throws NotAvailableException {
        HashMap<String, String> variableSelection = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.variableMap.entrySet()) {
            if (!entry.getKey().contains(variableContains) || entry.getValue().isEmpty()) continue;
            variableSelection.put(entry.getKey(), entry.getValue());
        }
        if (variableSelection.isEmpty()) {
            throw new NotAvailableException("No values found because no variables are matching [" + variableContains + "]!");
        }
        return variableSelection;
    }

    public void store(String key, String value) {
        this.variableMap.put(key, value);
    }
}

