/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.nfvo.vim_interfaces.vim;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.openbaton.exceptions.NotFoundException;
import org.openbaton.exceptions.PluginException;
import org.openbaton.nfvo.vim_interfaces.flavor_management.DeploymentFlavorManagement;
import org.openbaton.nfvo.vim_interfaces.image_management.ImageManagement;
import org.openbaton.nfvo.vim_interfaces.network_management.NetworkManagement;
import org.openbaton.nfvo.vim_interfaces.resource_management.ResourceManagement;
import org.openbaton.plugin.utils.RabbitPluginBroker;
import org.openbaton.vim.drivers.VimDriverCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
@ConfigurationProperties
public abstract class Vim
implements ImageManagement,
ResourceManagement,
NetworkManagement,
DeploymentFlavorManagement {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected VimDriverCaller client;

    public Vim(String type, String brokerIp, int port, String managementPort, ApplicationContext context) throws PluginException {
        try {
            if (managementPort == null) {
                managementPort = "15672";
            }
            if (context == null) {
                this.client = new VimDriverCaller(brokerIp, "admin", "openbaton", port, type, managementPort);
            } else {
                this.log.trace("Using context: " + context.getApplicationName());
                try {
                    this.client = (VimDriverCaller)((RabbitPluginBroker)context.getBean("rabbitPluginBroker")).getVimDriverCaller(brokerIp, "admin", "openbaton", port, type, managementPort);
                }
                catch (BeansException ignored) {
                    this.client = new VimDriverCaller(brokerIp, "admin", "openbaton", port, type, managementPort);
                }
            }
        }
        catch (IOException | TimeoutException | NotFoundException e) {
            throw new PluginException("Error instantiating plugin: " + e.getMessage(), e);
        }
    }

    public Vim() {
    }

    public Vim(String type, String managementPort, ApplicationContext context) throws PluginException {
        try {
            if (managementPort == null || managementPort.isEmpty()) {
                managementPort = "15672";
            }
            if (context == null) {
                this.client = new VimDriverCaller("", type, managementPort);
            } else {
                this.log.trace("Using context: " + context.getApplicationName());
                try {
                    this.client = (VimDriverCaller)((RabbitPluginBroker)context.getBean("rabbitPluginBroker")).getVimDriverCaller("", type, managementPort);
                }
                catch (BeansException ignored) {
                    this.client = new VimDriverCaller("", type, managementPort);
                }
            }
        }
        catch (IOException | TimeoutException | NotFoundException e) {
            throw new PluginException("Error instantiating plugin: " + e.getMessage(), e);
        }
    }

    public Vim(String type, String name, String managementPort, ApplicationContext context) throws PluginException {
        try {
            if (managementPort == null) {
                managementPort = "15672";
            }
            if (context == null) {
                this.client = new VimDriverCaller(name, type, managementPort);
            } else {
                this.log.trace("Using context: " + context.getApplicationName());
                try {
                    this.client = (VimDriverCaller)((RabbitPluginBroker)context.getBean("rabbitPluginBroker")).getVimDriverCaller(name, type, managementPort);
                }
                catch (BeansException ignored) {
                    this.client = new VimDriverCaller(name, type, managementPort);
                }
            }
        }
        catch (IOException | TimeoutException | NotFoundException e) {
            throw new PluginException("Error instantiating plugin: " + e.getMessage(), e);
        }
    }

    public Vim(String type, ApplicationContext context) throws PluginException {
        try {
            if (context == null) {
                this.client = new VimDriverCaller("", type, "15672");
            } else {
                this.log.trace("Using context: " + context.getApplicationName());
                try {
                    this.client = (VimDriverCaller)((RabbitPluginBroker)context.getBean("rabbitPluginBroker")).getVimDriverCaller("", type, "15672");
                }
                catch (BeansException ignored) {
                    this.client = new VimDriverCaller("", type, "15672");
                }
            }
        }
        catch (IOException | TimeoutException | NotFoundException e) {
            throw new PluginException("Error instantiating plugin: " + e.getMessage(), e);
        }
    }

    public Vim(String type, String username, String password, String brokerIp, String managementPort, ApplicationContext context) throws PluginException {
        try {
            if (managementPort == null) {
                managementPort = "15672";
            }
            if (context == null) {
                this.client = new VimDriverCaller(brokerIp, username, password, type, managementPort);
            } else {
                this.log.trace("Using context: " + context.getApplicationName());
                try {
                    this.client = (VimDriverCaller)((RabbitPluginBroker)context.getBean("rabbitPluginBroker")).getVimDriverCaller(brokerIp, username, password, type, managementPort);
                }
                catch (BeansException ignored) {
                    this.client = new VimDriverCaller(brokerIp, username, password, type, managementPort);
                }
            }
        }
        catch (IOException | TimeoutException | NotFoundException e) {
            throw new PluginException("Error instantiating plugin: " + e.getMessage(), e);
        }
    }

    public VimDriverCaller getClient() {
        return this.client;
    }

    public void setClient(VimDriverCaller client) {
        this.client = client;
    }
}

