/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.dhcpl2relay;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ComponentContextAdapter;
import org.onlab.packet.ChassisId;
import org.onlab.packet.DHCP;
import org.onlab.packet.DHCPOption;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPv4;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.UDP;
import org.onlab.packet.VlanId;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.CoreServiceAdapter;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.NetworkConfigRegistryAdapter;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.host.HostServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.opencord.dhcpl2relay.DhcpL2Relay;
import org.opencord.dhcpl2relay.DhcpL2RelayConfig;
import org.opencord.dhcpl2relay.DhcpL2RelayTestBase;
import org.opencord.dhcpl2relay.packet.DhcpOption82;
import org.opencord.sadis.SubscriberAndDeviceInformation;
import org.opencord.sadis.SubscriberAndDeviceInformationService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DhcpL2RelayTest
extends DhcpL2RelayTestBase {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private DhcpL2Relay dhcpL2Relay;
    private static final MacAddress CLIENT_MAC = MacAddress.valueOf((String)"00:00:00:00:00:01");
    private static final VlanId CLIENT_C_TAG = VlanId.vlanId((short)999);
    private static final VlanId CLIENT_S_TAG = VlanId.vlanId((short)111);
    private static final String CLIENT_NAS_PORT_ID = "PON 1/1";
    private static final String CLIENT_CIRCUIT_ID = "CIR-PON 1/1";
    private static final String OLT_DEV_ID = "of:00000000000000aa";
    private static final MacAddress OLT_MAC_ADDRESS = MacAddress.valueOf((String)"01:02:03:04:05:06");
    private static final DeviceId DEVICE_ID_1 = DeviceId.deviceId((String)"of:00000000000000aa");
    private static final ConnectPoint SERVER_CONNECT_POINT = ConnectPoint.deviceConnectPoint((String)"of:0000000000000001/5");
    private static final String SCHEME_NAME = "dhcpl2relay";
    private static final DefaultAnnotations DEVICE_ANNOTATIONS = DefaultAnnotations.builder().set("protocol", "dhcpl2relay".toUpperCase()).build();
    ComponentConfigService mockConfigService = (ComponentConfigService)EasyMock.createMock(ComponentConfigService.class);

    @Before
    public void setUp() {
        this.dhcpL2Relay = new DhcpL2Relay();
        this.dhcpL2Relay.cfgService = new TestNetworkConfigRegistry();
        this.dhcpL2Relay.coreService = new CoreServiceAdapter();
        this.dhcpL2Relay.packetService = new DhcpL2RelayTestBase.MockPacketService();
        this.dhcpL2Relay.componentConfigService = this.mockConfigService;
        this.dhcpL2Relay.deviceService = new MockDeviceService();
        this.dhcpL2Relay.subsService = new MockSubService();
        this.dhcpL2Relay.hostService = new MockHostService();
        this.dhcpL2Relay.mastershipService = new MockMastershipService();
        this.dhcpL2Relay.activate((ComponentContext)new ComponentContextAdapter());
    }

    @After
    public void tearDown() {
        this.dhcpL2Relay.deactivate();
    }

    @Test
    public void testDhcpDiscover() throws Exception {
        System.out.println("Sending pakcet");
        Ethernet discoverPacket = this.constructDhcpDiscoverPacket(CLIENT_MAC);
        this.sendPacket(discoverPacket, ConnectPoint.deviceConnectPoint((String)"of:00000000000000aa/1"));
        Ethernet discoverRelayed = (Ethernet)this.getPacket();
        this.compareClientPackets(discoverPacket, discoverRelayed);
    }

    @Test
    public void testDhcpRequest() throws Exception {
        System.out.println("Sending pakcet");
        Ethernet requestPacket = this.constructDhcpRequestPacket(CLIENT_MAC);
        this.sendPacket(requestPacket, ConnectPoint.deviceConnectPoint((String)"of:00000000000000aa/1"));
        Ethernet requestRelayed = (Ethernet)this.getPacket();
        this.compareClientPackets(requestPacket, requestRelayed);
    }

    @Test
    public void testDhcpOffer() {
        System.out.println("Sending pakcet");
        Ethernet offerPacket = this.constructDhcpOfferPacket(MacAddress.valueOf((String)"bb:bb:bb:bb:bb:bb"), CLIENT_MAC, "1.1.1.1", "2.2.2.2");
        this.sendPacket(offerPacket, ConnectPoint.deviceConnectPoint((String)"of:00000000000000aa/1"));
        Ethernet offerRelayed = (Ethernet)this.getPacket();
        this.compareServerPackets(offerPacket, offerRelayed);
    }

    @Test
    public void testDhcpAck() {
        Ethernet ackPacket = this.constructDhcpAckPacket(MacAddress.valueOf((String)"bb:bb:bb:bb:bb:bb"), CLIENT_MAC, "1.1.1.1", "2.2.2.2");
        this.sendPacket(ackPacket, ConnectPoint.deviceConnectPoint((String)"of:00000000000000aa/1"));
        Ethernet ackRelayed = (Ethernet)this.getPacket();
        this.compareServerPackets(ackPacket, ackRelayed);
    }

    public void compareClientPackets(Ethernet sent, Ethernet relayed) {
        sent.setSourceMACAddress(OLT_MAC_ADDRESS);
        sent.setQinQVID(CLIENT_S_TAG.toShort());
        sent.setVlanID(CLIENT_C_TAG.toShort());
        IPv4 ipv4Packet = (IPv4)sent.getPayload();
        UDP udpPacket = (UDP)ipv4Packet.getPayload();
        DHCP dhcpPacket = (DHCP)udpPacket.getPayload();
        ArrayList options = Lists.newArrayList((Iterable)dhcpPacket.getOptions());
        DhcpOption82 option82 = new DhcpOption82();
        option82.setAgentCircuitId(CLIENT_CIRCUIT_ID);
        DHCPOption option = new DHCPOption().setCode(DHCP.DHCPOptionCode.OptionCode_CircuitID.getValue()).setData(option82.toByteArray()).setLength(option82.length());
        options.add(options.size() - 1, option);
        dhcpPacket.setOptions((List)options);
        Assert.assertEquals((Object)sent, (Object)relayed);
    }

    public void compareServerPackets(Ethernet sent, Ethernet relayed) {
        sent.setDestinationMACAddress(CLIENT_MAC);
        sent.setQinQVID(CLIENT_S_TAG.toShort());
        sent.setVlanID(CLIENT_C_TAG.toShort());
        ByteBuffer byteBuffer = ByteBuffer.wrap(sent.serialize());
        Ethernet expectedPacket = null;
        try {
            expectedPacket = (Ethernet)Ethernet.deserializer().deserialize(byteBuffer.array(), 0, byteBuffer.array().length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals(expectedPacket, (Object)relayed);
    }

    static /* synthetic */ DefaultAnnotations access$600() {
        return DEVICE_ANNOTATIONS;
    }

    private static final class TestNetworkConfigRegistry
    extends NetworkConfigRegistryAdapter {
        private TestNetworkConfigRegistry() {
        }

        public <S, C extends Config<S>> C getConfig(S subject, Class<C> configClass) {
            MockDhcpL2RealyConfig dhcpConfig = new MockDhcpL2RealyConfig();
            return (C)((Object)dhcpConfig);
        }
    }

    static class MockDhcpL2RealyConfig
    extends DhcpL2RelayConfig {
        MockDhcpL2RealyConfig() {
        }

        public Set<ConnectPoint> getDhcpServerConnectPoint() {
            return ImmutableSet.of((Object)SERVER_CONNECT_POINT);
        }
    }

    private class MockHostService
    extends HostServiceAdapter {
        private MockHostService() {
        }

        public Set<Host> getHostsByMac(MacAddress mac) {
            HostLocation loc = new HostLocation(DEVICE_ID_1, PortNumber.portNumber((long)22L), 0L);
            IpAddress ip = IpAddress.valueOf((String)"10.100.200.10");
            DefaultHost h = new DefaultHost(ProviderId.NONE, HostId.hostId((MacAddress)mac, (VlanId)VlanId.NONE), mac, VlanId.NONE, loc, (Set)ImmutableSet.of((Object)ip), new Annotations[0]);
            return ImmutableSet.of((Object)h);
        }
    }

    private class MockSubscriberAndDeviceInformation
    extends SubscriberAndDeviceInformation {
        MockSubscriberAndDeviceInformation(String id, VlanId ctag, VlanId stag, String nasPortId, String circuitId, MacAddress hardId, Ip4Address ipAddress) {
            this.setCTag(ctag);
            this.setHardwareIdentifier(hardId);
            this.setId(id);
            this.setIPAddress(ipAddress);
            this.setSTag(stag);
            this.setNasPortId(nasPortId);
            this.setCircuitId(circuitId);
        }
    }

    private class MockMastershipService
    extends MastershipServiceAdapter {
        private MockMastershipService() {
        }

        public boolean isLocalMaster(DeviceId d) {
            return true;
        }
    }

    private class MockSubService
    implements SubscriberAndDeviceInformationService {
        MockSubscriberAndDeviceInformation device;
        MockSubscriberAndDeviceInformation sub;

        private MockSubService() {
            this.device = new MockSubscriberAndDeviceInformation(DhcpL2RelayTest.OLT_DEV_ID, VlanId.NONE, VlanId.NONE, null, null, OLT_MAC_ADDRESS, Ip4Address.valueOf((String)"10.10.10.10"));
            this.sub = new MockSubscriberAndDeviceInformation(DhcpL2RelayTest.CLIENT_NAS_PORT_ID, CLIENT_C_TAG, CLIENT_S_TAG, DhcpL2RelayTest.CLIENT_NAS_PORT_ID, DhcpL2RelayTest.CLIENT_CIRCUIT_ID, null, null);
        }

        public SubscriberAndDeviceInformation get(String id) {
            if (id.equals(DhcpL2RelayTest.OLT_DEV_ID)) {
                return this.device;
            }
            return this.sub;
        }

        public void invalidateAll() {
        }

        public void invalidateId(String id) {
        }

        public SubscriberAndDeviceInformation getfromCache(String id) {
            return null;
        }
    }

    private class MockPort
    implements Port {
        private MockPort() {
        }

        public boolean isEnabled() {
            return true;
        }

        public long portSpeed() {
            return 1000L;
        }

        public Element element() {
            return null;
        }

        public PortNumber number() {
            return null;
        }

        public Annotations annotations() {
            return new MockAnnotations();
        }

        public Port.Type type() {
            return Port.Type.FIBER;
        }

        private class MockAnnotations
        implements Annotations {
            private MockAnnotations() {
            }

            public String value(String val) {
                return DhcpL2RelayTest.CLIENT_NAS_PORT_ID;
            }

            public Set<String> keys() {
                return null;
            }
        }
    }

    private class MockDeviceService
    extends DeviceServiceAdapter {
        private ProviderId providerId = new ProviderId("of", "foo");
        private final Device device1 = new MockDevice(this.providerId, DhcpL2RelayTest.access$500(), Device.Type.SWITCH, "foo.inc", "0", "0", "of:00000000000000aa", new ChassisId(), new Annotations[]{DhcpL2RelayTest.access$600()});

        private MockDeviceService() {
        }

        public Device getDevice(DeviceId devId) {
            return this.device1;
        }

        public Port getPort(ConnectPoint cp) {
            return new MockPort();
        }

        public boolean isAvailable(DeviceId d) {
            return true;
        }
    }

    private class MockDevice
    extends DefaultDevice {
        public MockDevice(ProviderId providerId, DeviceId id, Device.Type type, String manufacturer, String hwVersion, String swVersion, String serialNumber, ChassisId chassisId, Annotations ... annotations) {
            super(providerId, id, type, manufacturer, hwVersion, swVersion, serialNumber, chassisId, annotations);
        }
    }
}

