/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.kernel.collection;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.openmdx.kernel.exception.BasicException;

public class InternalizedKeys {
    private static final ConcurrentMap<Short, Short> shortCacheExtension = new ConcurrentHashMap<Short, Short>();
    private static final short JDK_SHORT_CACHE_LOWER_BOUND = -128;
    private static final short JDK_SHORT_CACHE_UPPER_BOUND = 127;
    private static final ConcurrentMap<Integer, Integer> integerCacheExtension = new ConcurrentHashMap<Integer, Integer>();
    private static final int JDK_INTEGER_CACHE_LOWER_BOUND = -128;
    private static final int JDK_INTEGER_CACHE_UPPER_BOUND = 127;
    private static ConcurrentMap<Long, Long> longCache = new ConcurrentHashMap<Long, Long>();
    private static final long JDK_LONG_CACHE_LOWER_BOUND = InternalizedKeys.isCached(-128L) ? -128L : Long.MAX_VALUE;
    private static final long JDK_LONG_CACHE_UPPER_BOUND = InternalizedKeys.isCached(127L) ? 127L : Long.MIN_VALUE;

    private static boolean isCached(long candidate) {
        return Long.valueOf(candidate) == Long.valueOf(candidate);
    }

    public static boolean isInternalizable(Object key) {
        return key == null || key instanceof String || key instanceof Integer || key instanceof Long || key instanceof Short;
    }

    public static <T> T internalize(T key) {
        if (key == null) {
            return null;
        }
        if (key instanceof String) {
            return (T)((String)key).intern();
        }
        if (key instanceof Integer) {
            return (T)InternalizedKeys.internalize((Integer)key);
        }
        if (key instanceof Long) {
            return (T)InternalizedKeys.internalize((Long)key);
        }
        if (key instanceof Short) {
            return (T)InternalizedKeys.internalize((Short)key);
        }
        throw (IllegalArgumentException)BasicException.initHolder((Throwable)new IllegalArgumentException("Inappropriate key class", (Throwable)BasicException.newEmbeddedExceptionStack((String)"DefaultDomain", (int)-30, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("key", key), new BasicException.Parameter("supported", new Object[]{String.class.getName(), Integer.class.getName()}), new BasicException.Parameter("actual", (Object)key.getClass().getName())})));
    }

    private static Short internalize(Short actual) {
        short value = actual;
        return value >= -128 && value <= 127 ? Short.valueOf(value) : shortCacheExtension.computeIfAbsent(actual, key -> key);
    }

    private static Integer internalize(Integer actual) {
        int value = actual;
        return value >= -128 && value <= 127 ? Integer.valueOf(value) : integerCacheExtension.computeIfAbsent(actual, key -> key);
    }

    private static Long internalize(Long actual) {
        long value = actual;
        return value >= JDK_LONG_CACHE_LOWER_BOUND && value <= JDK_LONG_CACHE_UPPER_BOUND ? Long.valueOf(value) : longCache.computeIfAbsent(actual, key -> key);
    }
}

