/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.kernel.text.format;

import org.openmdx.kernel.text.MultiLineStringRepresentation;
import org.openmdx.kernel.text.format.HexadecimalFormatter;

public class ByteArrayFormatter
implements MultiLineStringRepresentation {
    private byte[] buf;
    private int offset;
    private int length;
    private String header;

    public ByteArrayFormatter(byte[] buf, int offset, int length, String header) {
        this.buf = buf;
        this.offset = buf != null ? offset : 0;
        this.length = buf != null ? length : 0;
        this.header = header;
        if (buf != null) {
            if (this.offset < 0) {
                this.length += this.offset;
                this.offset = 0;
            } else if (this.offset >= buf.length) {
                this.offset = 0;
                this.length = 0;
            }
            if (this.length < 0) {
                this.length = 0;
            }
            if (this.offset + this.length >= buf.length) {
                this.length = buf.length - this.offset;
            }
        }
    }

    public ByteArrayFormatter(byte[] buf, int offset, int length) {
        this(buf, offset, length, null);
    }

    public ByteArrayFormatter(byte[] buf) {
        this(buf, 0, buf != null ? buf.length : 0);
    }

    public String toString() {
        return this.hexify();
    }

    private String hexify() {
        if (this.buf == null || this.length <= 0 || this.offset >= this.buf.length) {
            return this.header == null ? new String() : this.header;
        }
        StringBuilder hexBuf = new StringBuilder(this.length * 5);
        StringBuilder hex = new StringBuilder();
        StringBuilder ascii = new StringBuilder();
        int lineBytes = 0;
        int idx = 0;
        byte value = 0;
        int line = 0;
        if (this.header != null) {
            hexBuf.append(this.header).append('\n');
        }
        while (idx < this.length) {
            int ii;
            lineBytes = this.length - idx >= 16 ? 16 : this.length - idx;
            hex.setLength(0);
            ascii.setLength(0);
            for (ii = 0; ii < lineBytes; ++ii) {
                value = this.buf[this.offset + idx];
                hex.append(new HexadecimalFormatter(value >= 0 ? (long)value : (long)(256 + value), 2)).append(' ');
                if (ii == 7) {
                    hex.append(' ');
                }
                ascii.append(value >= 32 && value <= 126 ? (char)value : (char)'.');
                ++idx;
            }
            if (lineBytes <= 7) {
                hex.append(' ');
            }
            for (ii = 0; ii < (16 - lineBytes) * 3; ++ii) {
                hex.append(' ');
            }
            if (line > 0) {
                hexBuf.append('\n');
            }
            hexBuf.append(new HexadecimalFormatter(line * 16, 6)).append("  ").append((CharSequence)hex);
            hexBuf.append(' ').append((CharSequence)ascii);
            ++line;
        }
        return hexBuf.toString();
    }
}

