/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.kernel.text.format;

import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.openmdx.kernel.collection.ArraysExtension;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.kernel.text.MultiLineStringRepresentation;
import org.openmdx.kernel.text.format.IndentingFormatter;

public class DatabaseDriverFormatter
implements MultiLineStringRepresentation {
    private final Driver driver;
    private final String url;
    private final Properties info;
    private static final String[] DRIVER_PROPERTY_INFO_KEYS = new String[]{"name", "description", "value", "required", "choices"};

    public DatabaseDriverFormatter(Driver driver, String url, Properties info) {
        this.driver = driver;
        this.url = url;
        this.info = info;
    }

    private Object getPropertyInfo() {
        try {
            DriverPropertyInfo[] source = this.driver.getPropertyInfo(this.url, this.info == null ? new Properties() : this.info);
            Object[] target = new Object[source.length];
            for (int i = 0; i < source.length; ++i) {
                target[i] = source[i] == null ? null : ArraysExtension.asMap(DRIVER_PROPERTY_INFO_KEYS, new Object[]{source[i].name, source[i].description, source[i].value, source[i].required, source[i].choices});
            }
            return target;
        }
        catch (SQLException e) {
            SysLog.error((String)"JDBC Driver Property Info Acquisition failed", (Throwable)e);
            return "n/a";
        }
    }

    private Object getURLAcceptance() {
        try {
            return this.driver.acceptsURL(this.url) ? "accepted" : "rejected";
        }
        catch (SQLException e) {
            SysLog.error((String)"JDBC Driver URL Aceptance Test failed", (Throwable)e);
            return "n/a";
        }
    }

    public String toString() {
        return this.driver.getClass().getName() + ": " + IndentingFormatter.toString(ArraysExtension.asMap(new String[]{"version", this.url, "propertyInfo"}, new Object[]{Integer.toString(this.driver.getMinorVersion()) + "." + this.driver.getMajorVersion(), this.getURLAcceptance(), this.getPropertyInfo()}));
    }
}

