/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.kernel.text.format;

import java.util.Arrays;

public class HexadecimalFormatter {
    private final long fixedSizeValue;
    private final byte[] variableSizeValue;
    private final int digits;
    private static final char[] HEXADECIMAL_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public HexadecimalFormatter(long value, int digits) {
        if (digits < 0) {
            throw new IllegalArgumentException("Digits must not be negative: " + digits);
        }
        this.fixedSizeValue = value;
        this.digits = digits;
        this.variableSizeValue = null;
    }

    public HexadecimalFormatter(long value) {
        this(value, 16);
    }

    public HexadecimalFormatter(int value) {
        this(value, 8);
    }

    public HexadecimalFormatter(short value) {
        this(value, 4);
    }

    public HexadecimalFormatter(byte value) {
        this(value, 2);
    }

    public HexadecimalFormatter(byte[] value, int offset, int bytes) {
        if (bytes < 0) {
            throw new IllegalArgumentException("Bytes must not be negative: " + bytes);
        }
        this.fixedSizeValue = offset;
        this.variableSizeValue = value;
        this.digits = value == null ? -1 : bytes * 2;
    }

    public HexadecimalFormatter(byte[] value) {
        this(value, 0, value == null ? 0 : value.length);
    }

    private static char[] toHexadecimalString(long _value, int digits) {
        long value = _value;
        char[] buffer = new char[digits];
        int i = digits;
        while (i > 0) {
            buffer[--i] = HEXADECIMAL_DIGITS[(int)(value & 0xFL)];
            value >>= 4;
        }
        return buffer;
    }

    private static char[] toHexadecimalString(byte[] value, int offset, int digits) {
        char[] buffer = new char[digits];
        int available = 2 * (value.length - offset);
        int cursor = 0;
        int end = digits;
        if (available < digits) {
            end = available;
        }
        if (offset < 0) {
            cursor = -2 * offset;
        }
        if (cursor != 0 || end != digits) {
            Arrays.fill(buffer, ' ');
        }
        while (cursor < end) {
            byte b = value[offset + cursor / 2];
            if (cursor % 2 == 0) {
                b = (byte)(b >> 4);
            }
            buffer[cursor++] = HEXADECIMAL_DIGITS[b & 0xF];
        }
        return buffer;
    }

    public String toString() {
        return this.digits < 0 ? "null" : new String(this.variableSizeValue == null ? HexadecimalFormatter.toHexadecimalString(this.fixedSizeValue, this.digits) : HexadecimalFormatter.toHexadecimalString(this.variableSizeValue, (int)this.fixedSizeValue, this.digits));
    }
}

