/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.security.radius.client;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.logging.Logger;
import org.openmdx.uses.net.sourceforge.jradiusclient.RadiusClient;
import org.openmdx.uses.org.apache.commons.pool.PoolableObjectFactory;

public class RadiusClientFactory
implements PoolableObjectFactory {
    private final String[] hostNames;
    private final int[] authenticationPorts;
    private final int[] accountingPorts;
    private final String sharedSecret;
    private final BigDecimal socketTimeout;
    private final Logger logger;
    private final boolean trace;
    private final InetAddress nasAddress;

    public RadiusClientFactory(String[] hostNames, int[] authenticationPorts, int[] accountingPorts, String sharedSecret, long socketTimeout, Logger logger, boolean trace, InetAddress nasAddress) {
        this.hostNames = hostNames;
        this.authenticationPorts = authenticationPorts;
        this.accountingPorts = accountingPorts;
        this.sharedSecret = sharedSecret;
        this.socketTimeout = new BigDecimal(BigInteger.valueOf(socketTimeout), 3);
        this.logger = logger;
        this.trace = trace;
        this.nasAddress = nasAddress;
    }

    @Override
    public Object makeObject() throws Exception {
        return new RadiusClient(this.hostNames, this.authenticationPorts, this.accountingPorts, this.sharedSecret, this.socketTimeout, this.logger, this.trace, this.nasAddress);
    }

    @Override
    public void destroyObject(Object obj) throws Exception {
    }

    @Override
    public boolean validateObject(Object obj) {
        return obj instanceof RadiusClient && ((RadiusClient)obj).isValid();
    }

    @Override
    public void activateObject(Object obj) throws Exception {
    }

    @Override
    public void passivateObject(Object obj) throws Exception {
    }
}

