/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.uses.net.sourceforge.jradiusclient;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Logger;
import org.openmdx.kernel.collection.ArraysExtension;
import org.openmdx.kernel.text.MultiLineStringRepresentation;
import org.openmdx.kernel.text.format.DatagramPacketFormatter;
import org.openmdx.kernel.text.format.IndentingFormatter;
import org.openmdx.uses.net.sourceforge.jradiusclient.AbstractRadiusClient;
import org.openmdx.uses.net.sourceforge.jradiusclient.RadiusAttribute;
import org.openmdx.uses.net.sourceforge.jradiusclient.RadiusConnection;
import org.openmdx.uses.net.sourceforge.jradiusclient.RadiusPacket;
import org.openmdx.uses.net.sourceforge.jradiusclient.exception.InvalidParameterException;
import org.openmdx.uses.net.sourceforge.jradiusclient.exception.RadiusException;

public class RadiusClient
extends AbstractRadiusClient
implements RadiusConnection,
MultiLineStringRepresentation {
    private static byte[] NAS_ID;
    private static final int AUTH_LOOP_COUNT = 3;
    private static final int ACCT_LOOP_COUNT = 3;
    private static final int DEFAULT_AUTH_PORT = 1812;
    private static final int DEFAULT_ACCT_PORT = 1813;
    public static final int DEFAULT_SOCKET_TIMEOUT = 6000;
    private byte[] sharedSecret = null;
    private InetAddress[] hostname = null;
    private int[] authenticationPort = null;
    private int[] accountingPort = null;
    private DatagramSocket socket = null;
    private int socketTimeout = 6000;
    private MessageDigest md5MessageDigest;
    private final byte[] NAS_IP;
    private boolean valid;
    public static final String ENCODING = "UTF-8";
    private int authenticationRetries = 3;
    private int accountingRetries = 3;

    public RadiusClient(String hostname, String sharedSecret) throws RadiusException, InvalidParameterException {
        this(hostname, 1812, 1813, sharedSecret, 6000);
    }

    public RadiusClient(String hostname, int authPort, int acctPort, String sharedSecret) throws RadiusException, InvalidParameterException {
        this(hostname, authPort, acctPort, sharedSecret, 6000);
    }

    public RadiusClient(String hostname, int authPort, int acctPort, String sharedSecret, int sockTimeout) throws RadiusException, InvalidParameterException {
        this(new String[]{hostname}, new int[]{authPort}, new int[]{acctPort}, sharedSecret, new BigDecimal(BigInteger.valueOf(sockTimeout), 3), Logger.getLogger("org.openmdx.uses.net.sourceforge.jradiusclient"), false, null);
    }

    public RadiusClient(String[] hostname, int[] authPort, int[] acctPort, String sharedSecret, BigDecimal sockTimeout, Logger logger, boolean trace, InetAddress nasAddress) throws RadiusException, InvalidParameterException {
        super(logger, trace);
        this.setProvider(hostname, authPort, acctPort);
        if (hostname.length > 1) {
            this.authenticationRetries = hostname.length;
            this.accountingRetries = hostname.length;
        }
        this.setSharedSecret(sharedSecret);
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException sex) {
            throw new RadiusException(sex);
        }
        this.setTimeout(sockTimeout == null ? 6000 : sockTimeout.scaleByPowerOfTen(3).intValue());
        try {
            this.md5MessageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsaex) {
            throw new RadiusException(nsaex);
        }
        this.NAS_IP = nasAddress == null ? null : nasAddress.getAddress();
        this.valid = true;
        this.logInfo("Radius client instance #{0} created");
    }

    @Override
    public RadiusPacket authenticate(RadiusPacket accessRequest) throws RadiusException, InvalidParameterException {
        return this.authenticate(accessRequest, this.authenticationRetries);
    }

    public RadiusPacket authenticate(RadiusPacket accessRequest, int retries) throws RadiusException, InvalidParameterException {
        byte code;
        if (null == accessRequest) {
            throw new InvalidParameterException("accessRequest parameter cannot be null");
        }
        if (retries < 0) {
            throw new InvalidParameterException("retries must be zero or greater!");
        }
        if (retries == 0) {
            retries = 3;
        }
        if ((code = accessRequest.getPacketType()) != 1) {
            throw new InvalidParameterException("Invalid packet type submitted to authenticate");
        }
        byte identifier = accessRequest.getPacketIdentifier();
        byte[] requestAuthenticator = this.makeRFC2865RequestAuthenticator();
        try {
            byte[] userPass = accessRequest.getAttribute(2).getValue();
            if (userPass.length > 0) {
                byte[] encryptedPass = this.encodePapPassword(userPass, requestAuthenticator);
                accessRequest.setAttribute(new RadiusAttribute(2, encryptedPass));
            }
        }
        catch (RadiusException userPass) {
            // empty catch block
        }
        if (this.NAS_IP == null) {
            accessRequest.setAttribute(new RadiusAttribute(32, NAS_ID));
        } else {
            accessRequest.setAttribute(new RadiusAttribute(4, this.NAS_IP));
        }
        byte[] requestAttributes = accessRequest.getAttributeBytes(4, 61, 1, 2);
        short length = (short)(20 + requestAttributes.length);
        return this.sendReceivePacket(code, identifier, length, requestAuthenticator, requestAttributes, retries, accessRequest.getSocketIndex(), this.getHostname(), this.getAuthPort());
    }

    @Override
    public RadiusPacket account(RadiusPacket requestPacket) throws InvalidParameterException, RadiusException {
        if (null == requestPacket) {
            throw new InvalidParameterException("requestPacket parameter cannot be null");
        }
        byte code = requestPacket.getPacketType();
        if (code != 4) {
            throw new InvalidParameterException("Invalid type passed in for RadiusPacket");
        }
        try {
            requestPacket.getAttribute(1);
            requestPacket.getAttribute(40);
            requestPacket.getAttribute(44);
            requestPacket.getAttribute(6);
        }
        catch (RadiusException rex) {
            throw new InvalidParameterException("Missing RadiusAttribute in Accounting RequestPacket: " + rex.getMessage());
        }
        byte identifier = requestPacket.getPacketIdentifier();
        if (this.NAS_IP == null) {
            requestPacket.setAttribute(new RadiusAttribute(32, NAS_ID));
        } else {
            requestPacket.setAttribute(new RadiusAttribute(4, this.NAS_IP));
        }
        byte[] requestAttributes = requestPacket.getAttributeBytes();
        short length = (short)(20 + requestAttributes.length);
        byte[] requestAuthenticator = this.makeRFC2866RequestAuthenticator(code, identifier, length, requestAttributes);
        RadiusPacket responsePacket = this.sendReceivePacket(code, identifier, length, requestAuthenticator, requestAttributes, this.accountingRetries, requestPacket.getSocketIndex(), this.getHostname(), this.getAcctPort());
        if (5 != responsePacket.getPacketType()) {
            throw new RadiusException("The radius Server responded with an incorrect response type.");
        }
        return responsePacket;
    }

    private byte[] encodePapPassword(byte[] userPass, byte[] requestAuthenticator) {
        int i;
        byte[] userPassBytes = null;
        if (userPass.length > 128) {
            userPassBytes = new byte[128];
            System.arraycopy(userPass, 0, userPassBytes, 0, 128);
        } else {
            userPassBytes = userPass;
        }
        byte[] encryptedPass = null;
        encryptedPass = userPassBytes.length < 128 ? (userPassBytes.length % 16 == 0 ? new byte[userPassBytes.length] : new byte[userPassBytes.length / 16 * 16 + 16]) : new byte[128];
        System.arraycopy(userPassBytes, 0, encryptedPass, 0, userPassBytes.length);
        for (int i2 = userPassBytes.length; i2 < encryptedPass.length; ++i2) {
            encryptedPass[i2] = 0;
        }
        this.md5MessageDigest.reset();
        this.md5MessageDigest.update(this.sharedSecret);
        this.md5MessageDigest.update(requestAuthenticator);
        byte[] bn = this.md5MessageDigest.digest();
        for (i = 0; i < 16; ++i) {
            encryptedPass[i] = (byte)(bn[i] ^ encryptedPass[i]);
        }
        if (encryptedPass.length > 16) {
            for (i = 16; i < encryptedPass.length; i += 16) {
                this.md5MessageDigest.reset();
                this.md5MessageDigest.update(this.sharedSecret);
                this.md5MessageDigest.update(encryptedPass, i - 16, 16);
                bn = this.md5MessageDigest.digest();
                for (int j = 0; j < 16; ++j) {
                    encryptedPass[i + j] = (byte)(bn[j] ^ encryptedPass[i + j]);
                }
            }
        }
        return encryptedPass;
    }

    private byte[] makeRFC2865RequestAuthenticator() {
        byte[] requestAuthenticator = new byte[16];
        Random r = new Random();
        for (int i = 0; i < 16; ++i) {
            requestAuthenticator[i] = (byte)r.nextInt();
        }
        this.md5MessageDigest.reset();
        this.md5MessageDigest.update(this.sharedSecret);
        this.md5MessageDigest.update(requestAuthenticator);
        return this.md5MessageDigest.digest();
    }

    private byte[] makeRFC2865ResponseAuthenticator(byte code, byte identifier, short length, byte[] requestAuthenticator, byte[] responseAttributeBytes) {
        this.md5MessageDigest.reset();
        this.md5MessageDigest.update(code);
        this.md5MessageDigest.update(identifier);
        this.md5MessageDigest.update((byte)(length >> 8));
        this.md5MessageDigest.update((byte)(length & 0xFF));
        this.md5MessageDigest.update(requestAuthenticator, 0, requestAuthenticator.length);
        this.md5MessageDigest.update(responseAttributeBytes, 0, responseAttributeBytes.length);
        this.md5MessageDigest.update(this.sharedSecret);
        return this.md5MessageDigest.digest();
    }

    private byte[] makeRFC2866RequestAuthenticator(byte code, byte identifier, short length, byte[] requestAttributes) {
        byte[] requestAuthenticator = new byte[16];
        for (int i = 0; i < 16; ++i) {
            requestAuthenticator[i] = 0;
        }
        this.md5MessageDigest.reset();
        this.md5MessageDigest.update(code);
        this.md5MessageDigest.update(identifier);
        this.md5MessageDigest.update((byte)(length >> 8));
        this.md5MessageDigest.update((byte)(length & 0xFF));
        this.md5MessageDigest.update(requestAuthenticator, 0, requestAuthenticator.length);
        this.md5MessageDigest.update(requestAttributes, 0, requestAttributes.length);
        this.md5MessageDigest.update(this.sharedSecret);
        return this.md5MessageDigest.digest();
    }

    private void setProvider(String[] hostname, int[] authPort, int[] acctPort) throws InvalidParameterException {
        ArrayList<String> exceptions = new ArrayList<String>();
        ArrayList<InetAddress> hostnames = new ArrayList<InetAddress>();
        ArrayList<Integer> acctPorts = new ArrayList<Integer>();
        ArrayList<Integer> authPorts = new ArrayList<Integer>();
        if (hostname == null) {
            exceptions.add("Hostname array can not be null");
        } else if (authPort == null || acctPort == null) {
            exceptions.add("Port array can not be null");
        } else if (hostname.length == 0) {
            exceptions.add("Hostname array can't be empty");
        } else if (hostname.length != authPort.length || hostname.length != acctPort.length) {
            exceptions.add("Hostname and port arrays must have the same length");
        }
        if (exceptions.isEmpty()) {
            for (int i = 0; i < hostname.length; ++i) {
                int exceptionCount = exceptions.size();
                if (authPort[i] < 0 || authPort[i] > 65535) {
                    exceptions.add("authorizationPort[" + i + "] out of range: " + authPort[i]);
                }
                if (acctPort[i] < 0 || acctPort[i] > 65535) {
                    exceptions.add("accountingPort[" + i + "] out of range: " + acctPort[i]);
                }
                if (null == hostname[i]) {
                    exceptions.add("Hostname[" + i + "] is null");
                } else if ("".equals(hostname[i].trim())) {
                    exceptions.add("Hostname[" + i + "] is empty or blank");
                }
                if (exceptionCount != exceptions.size()) continue;
                try {
                    hostnames.add(InetAddress.getByName(hostname[i]));
                    authPorts.add(authPort[i]);
                    acctPorts.add(acctPort[i]);
                    continue;
                }
                catch (UnknownHostException exception) {
                    exceptions.add("Hostname[" + i + "] could not be resolved: " + hostname[i]);
                }
            }
            Iterator e = exceptions.iterator();
            while (e.hasNext()) {
                super.logWarning("Radius Client #{0}: {1}", e.next());
            }
            int acceptable = hostnames.size();
            if (acceptable == 0) {
                this.logSevere("Radius Client #{0}: None of the host configurations was acceptable");
                throw new InvalidParameterException("None of the host configurations was acceptable: " + exceptions);
            }
            this.hostname = new InetAddress[acceptable];
            this.authenticationPort = new int[acceptable];
            this.accountingPort = new int[acceptable];
            for (int i = 0; i < acceptable; ++i) {
                this.hostname[i] = (InetAddress)hostnames.get(i);
                this.authenticationPort[i] = ((Number)authPorts.get(i)).intValue();
                this.accountingPort[i] = ((Number)acctPorts.get(i)).intValue();
            }
        }
    }

    public InetAddress[] getHostname() {
        return this.hostname;
    }

    public int[] getAuthPort() {
        return this.authenticationPort;
    }

    public int[] getAcctPort() {
        return this.accountingPort;
    }

    protected byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    private void setSharedSecret(String sharedSecret) throws InvalidParameterException {
        if (sharedSecret == null) {
            throw new InvalidParameterException("Shared secret can not be null!");
        }
        if (sharedSecret.equals("")) {
            throw new InvalidParameterException("Shared secret can not be an empty string!");
        }
        try {
            this.sharedSecret = sharedSecret.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding \"UTF-8\": " + e.getMessage());
        }
    }

    public int getTimeout() {
        return this.socketTimeout;
    }

    private void setTimeout(int socket_timeout) throws InvalidParameterException {
        if (socket_timeout < 0) {
            throw new InvalidParameterException("A negative timeout value is not allowed!");
        }
        this.socketTimeout = socket_timeout;
        try {
            if (null == this.socket) {
                this.socket = new DatagramSocket();
            }
            this.socket.setSoTimeout(this.socketTimeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private RadiusPacket checkRadiusPacket(DatagramPacket packet, byte requestIdentifier, byte[] requestAuthenticator, int socketIndex) throws RadiusException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private DatagramPacket composeRadiusPacket(byte code, byte identifier, short length, byte[] requestAuthenticator, byte[] requestAttributes) throws RadiusException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private RadiusPacket sendReceivePacket(byte code, byte identifier, short length, byte[] requestAuthenticator, byte[] requestAttributes, int retry, int provider, InetAddress[] hostname, int[] port) throws RadiusException {
        try {
            DatagramPacket packet_out = this.composeRadiusPacket(code, identifier, length, requestAuthenticator, requestAttributes);
            if (packet_out.getLength() > 4096) {
                throw new RadiusException("Packet too big!");
            }
            if (packet_out.getLength() < 20) {
                throw new RadiusException("Packet too short !");
            }
            DatagramPacket packet_in = new DatagramPacket(new byte[4096], 4096);
            IOException ioException = null;
            for (int i = 0; i < retry; ++i) {
                try {
                    int p = provider < 0 ? i % hostname.length : provider;
                    packet_out.setAddress(hostname[p]);
                    packet_out.setPort(port[p]);
                    if (i == 0) {
                        this.logDebug("RadiusClient #{0}: Send\n{1}", new DatagramPacketFormatter(packet_out));
                    } else {
                        this.logDebug("RadiusClient #{0}: Retry {1}\n{2}", i, new DatagramPacketFormatter(packet_out));
                    }
                    this.socket.send(packet_out);
                    this.socket.receive(packet_in);
                    this.logDebug("RadiusClient #{0}: Receive\n{1}", new DatagramPacketFormatter(packet_in));
                    return this.checkRadiusPacket(packet_in, identifier, requestAuthenticator, provider);
                }
                catch (IOException exception) {
                    ioException = exception;
                    continue;
                }
            }
            throw new RadiusException(ioException);
        }
        catch (RadiusException exception) {
            this.valid = false;
            throw exception;
        }
    }

    public String toString() {
        return this.getClass().getName() + ": " + IndentingFormatter.toString(ArraysExtension.asMap(new String[]{"HostName", "AuthenticationPort", "AccountingPort"}, new Object[]{this.getHostname(), this.getAuthPort(), this.getAcctPort()}));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof RadiusClient)) {
            return false;
        }
        RadiusClient that = (RadiusClient)object;
        return Arrays.equals(this.getHostname(), that.getHostname()) && Arrays.equals(this.getAuthPort(), that.getAuthPort()) && Arrays.equals(this.getAcctPort(), that.getAcctPort()) && Arrays.equals(this.getSharedSecret(), that.getSharedSecret());
    }

    public int hashCode() {
        InetAddress[] x1 = this.getHostname();
        int[] x2 = this.getAcctPort();
        int[] x3 = this.getAuthPort();
        int h = Arrays.hashCode(this.getSharedSecret());
        for (int i = 0; i < x1.length; ++i) {
            h = 31 * h + x1[i].hashCode();
            h = 31 * h + x2[i];
            h = 31 * h + x3[i];
        }
        return h;
    }

    @Override
    public void close() {
        this.socket.close();
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public boolean isValid() {
        if (!this.valid) {
            this.logInfo("Radius client instance #{0} is invalid");
        }
        return this.valid;
    }

    static {
        try {
            NAS_ID = InetAddress.getLocalHost().getHostName().getBytes(ENCODING);
        }
        catch (UnknownHostException exception) {
            throw new RuntimeException("Local host could not be determined: " + exception.getMessage());
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException("Unsupported encoding \"UTF-8\": " + exception.getMessage());
        }
    }
}

