/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.uses.net.sourceforge.jradiusclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openmdx.uses.net.sourceforge.jradiusclient.RadiusAttribute;
import org.openmdx.uses.net.sourceforge.jradiusclient.exception.InvalidParameterException;
import org.openmdx.uses.net.sourceforge.jradiusclient.exception.RadiusException;

public class RadiusPacket {
    public static final int MIN_PACKET_LENGTH = 20;
    public static final int MAX_PACKET_LENGTH = 4096;
    public static final short RADIUS_HEADER_LENGTH = 20;
    public static final String EMPTYSTRING = "";
    public static final int ACCESS_REQUEST = 1;
    public static final int ACCESS_ACCEPT = 2;
    public static final int ACCESS_REJECT = 3;
    public static final int ACCOUNTING_REQUEST = 4;
    public static final int ACCOUNTING_RESPONSE = 5;
    public static final int ACCOUNTING_STATUS = 6;
    public static final int PASSWORD_REQUEST = 7;
    public static final int PASSWORD_ACCEPT = 8;
    public static final int PASSWORD_REJECT = 9;
    public static final int ACCOUNTING_MESSAGE = 10;
    public static final int ACCESS_CHALLENGE = 11;
    public static final int STATUS_SERVER = 12;
    public static final int STATUS_CLIENT = 13;
    public static final int RESERVED = 255;
    private static Object nextPacketIdLock = new Object();
    private static byte nextPacketId = 0;
    private int packetType = 0;
    private byte packetIdentifier = 0;
    private Map<Integer, RadiusAttribute> attributes;
    private int socketIndex = -1;

    public RadiusPacket(int type) throws InvalidParameterException {
        this(type, RadiusPacket.getAndIncrementPacketIdentifier(), new ArrayList<RadiusAttribute>());
    }

    public RadiusPacket(int type, byte identifier) throws InvalidParameterException {
        this(type, identifier, new ArrayList<RadiusAttribute>());
    }

    public RadiusPacket(int type, byte identifier, int socketIndex) throws InvalidParameterException {
        this(type, identifier, Collections.emptyList());
        this.setSocketIndex(socketIndex);
    }

    public RadiusPacket(int type, List<RadiusAttribute> attributeList) throws InvalidParameterException {
        this(type, RadiusPacket.getAndIncrementPacketIdentifier(), attributeList);
    }

    public RadiusPacket(int type, byte identifier, List<RadiusAttribute> attributeList) throws InvalidParameterException {
        if (type < 1 || type > 256) {
            throw new InvalidParameterException("Type was out of bounds");
        }
        if (null == attributeList) {
            throw new InvalidParameterException("Attribute List was null");
        }
        this.packetType = type;
        this.packetIdentifier = identifier;
        this.attributes = new HashMap<Integer, RadiusAttribute>();
        this.setAttributes(attributeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(RadiusAttribute radiusAttribute) throws InvalidParameterException {
        if (null == radiusAttribute) {
            throw new InvalidParameterException("radiusAttribute was null");
        }
        this.validateAttribute(radiusAttribute);
        Map<Integer, RadiusAttribute> map = this.attributes;
        synchronized (map) {
            this.attributes.put(radiusAttribute.getType(), radiusAttribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(List<RadiusAttribute> attributeList) throws InvalidParameterException {
        if (null == attributeList) {
            throw new InvalidParameterException("Attribute List was null");
        }
        for (RadiusAttribute tempRa : attributeList) {
            try {
                this.validateAttribute(tempRa);
            }
            catch (ClassCastException ccex) {
                throw new InvalidParameterException("Attribute List contained an entry that was not a net.sourceforge.jradiusclient.RadiusAttribute");
            }
            Map<Integer, RadiusAttribute> map = this.attributes;
            synchronized (map) {
                this.attributes.put(tempRa.getType(), tempRa);
            }
        }
    }

    protected void validateAttribute(RadiusAttribute attribute) throws InvalidParameterException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RadiusAttribute getAttribute(int attributeType) throws InvalidParameterException, RadiusException {
        if (attributeType < 0 || attributeType > 256) {
            throw new InvalidParameterException("attributeType is out of bounds");
        }
        RadiusAttribute tempRa = null;
        Map<Integer, RadiusAttribute> map = this.attributes;
        synchronized (map) {
            tempRa = this.attributes.get(attributeType);
        }
        if (null == tempRa) {
            throw new RadiusException("No attribute found for type " + attributeType);
        }
        return tempRa;
    }

    public Collection<RadiusAttribute> getAttributes() {
        return this.attributes.values();
    }

    public byte getPacketType() {
        return (byte)this.packetType;
    }

    public byte getPacketIdentifier() {
        return this.packetIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] getAttributeBytes() throws RadiusException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        Map<Integer, RadiusAttribute> map = this.attributes;
        synchronized (map) {
            try {
                for (RadiusAttribute attribute : this.attributes.values()) {
                    bytes.write(attribute.getBytes());
                }
            }
            catch (IOException ioex) {
                throw new RadiusException(ioex, "Error writing bytes to ByteArrayOutputStream!!!");
            }
            return bytes.toByteArray();
        }
    }

    public final byte[] getAttributeBytes(int ... order) throws RadiusException {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            HashMap<Integer, RadiusAttribute> attributes = new HashMap<Integer, RadiusAttribute>(this.attributes);
            for (int i = 0; i < order.length; ++i) {
                RadiusAttribute candidate = (RadiusAttribute)attributes.remove(order[i]);
                if (candidate == null) continue;
                bytes.write(candidate.getBytes());
            }
            for (RadiusAttribute attribute : attributes.values()) {
                bytes.write(attribute.getBytes());
            }
            return bytes.toByteArray();
        }
        catch (IOException ioex) {
            throw new RadiusException(ioex, "Error writing bytes to ByteArrayOutputStream!!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte getAndIncrementPacketIdentifier() {
        Object object = nextPacketIdLock;
        synchronized (object) {
            byte by = nextPacketId;
            nextPacketId = (byte)(by + 1);
            return by;
        }
    }

    protected void setSocketIndex(int socketIndex) {
        this.socketIndex = socketIndex;
    }

    public int getSocketIndex() {
        return this.socketIndex;
    }
}

