/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.gradle.GradleProjectParser;
import org.openrewrite.gradle.RewriteClassLoader;
import org.openrewrite.gradle.RewriteExtension;

public class DelegatingProjectParser
implements GradleProjectParser {
    protected final Class<?> gppClass;
    protected final Object gpp;
    protected static List<URL> rewriteClasspath;
    protected static RewriteClassLoader rewriteClassLoader;
    protected static final Map<String, Object> astCache;

    public DelegatingProjectParser(Project project, RewriteExtension extension, Set<Path> classpath) {
        try {
            List<URL> classpathUrls = classpath.stream().map(Path::toUri).map(uri -> {
                try {
                    return uri.toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            String path = this.getClass().getResource("/org/openrewrite/gradle/isolated/DefaultProjectParser.class").toString();
            URL currentJar = null;
            if (path.startsWith("jar:")) {
                int indexOfBang = (path = path.substring(4)).indexOf("!");
                if (indexOfBang != -1) {
                    path = path.substring(0, indexOfBang);
                }
                currentJar = new URI(path).toURL();
            } else if (path.endsWith(".class")) {
                currentJar = Paths.get(System.getProperty("jarLocationForTest"), new String[0]).toUri().toURL();
            }
            classpathUrls.add(currentJar);
            if (rewriteClassLoader == null || !classpathUrls.equals(rewriteClasspath)) {
                rewriteClassLoader = new RewriteClassLoader(classpathUrls);
                rewriteClasspath = classpathUrls;
                astCache.clear();
            }
            this.gppClass = Class.forName("org.openrewrite.gradle.isolated.DefaultProjectParser", true, rewriteClassLoader);
            assert (this.gppClass.getClassLoader() == rewriteClassLoader) : "DefaultProjectParser must be loaded from RewriteClassLoader to be sufficiently isolated from Gradle's classpath";
            this.gpp = this.gppClass.getDeclaredConstructor(Project.class, RewriteExtension.class, Map.class).newInstance(project, extension, astCache);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SortedSet<String> getActiveRecipes() {
        return this.unwrapInvocationException(() -> (SortedSet)this.gppClass.getMethod("getActiveRecipes", new Class[0]).invoke(this.gpp, new Object[0]));
    }

    @Override
    public SortedSet<String> getActiveStyles() {
        return this.unwrapInvocationException(() -> (SortedSet)this.gppClass.getMethod("getActiveStyles", new Class[0]).invoke(this.gpp, new Object[0]));
    }

    @Override
    public SortedSet<String> getAvailableStyles() {
        return this.unwrapInvocationException(() -> (SortedSet)this.gppClass.getMethod("getAvailableStyles", new Class[0]).invoke(this.gpp, new Object[0]));
    }

    @Override
    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        return this.unwrapInvocationException(() -> (Collection)this.gppClass.getMethod("listRecipeDescriptors", new Class[0]).invoke(this.gpp, new Object[0]));
    }

    @Override
    public Collection<Path> listSources(Project project) {
        return this.unwrapInvocationException(() -> (Collection)this.gppClass.getMethod("listSources", new Class[0]).invoke(this.gpp, new Object[0]));
    }

    @Override
    public void run(boolean useAstCache, Consumer<Throwable> onError) {
        this.unwrapInvocationException(() -> this.gppClass.getMethod("run", Boolean.TYPE, Consumer.class).invoke(this.gpp, useAstCache, onError));
    }

    @Override
    public void dryRun(Path reportPath, boolean dumpGcActivity, boolean useAstCache, Consumer<Throwable> onError) {
        this.unwrapInvocationException(() -> this.gppClass.getMethod("dryRun", Path.class, Boolean.TYPE, Boolean.TYPE, Consumer.class).invoke(this.gpp, reportPath, dumpGcActivity, useAstCache, onError));
    }

    @Override
    public void clearAstCache() {
        this.unwrapInvocationException(() -> this.gppClass.getMethod("clearAstCache", new Class[0]).invoke(this.gpp, new Object[0]));
    }

    @Override
    public void shutdownRewrite() {
        this.unwrapInvocationException(() -> this.gppClass.getMethod("shutdownRewrite", new Class[0]).invoke(this.gpp, new Object[0]));
    }

    private <T> T unwrapInvocationException(Callable<T> supplier) {
        try {
            return supplier.call();
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        astCache = new HashMap<String, Object>();
    }
}

