/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import javax.inject.Inject;
import org.gradle.api.internal.tasks.userinput.UserInputHandler;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.gradle.AbstractRewriteTask;
import org.openrewrite.gradle.ui.RecipeDescriptorTreePrompter;

public class RewriteDiscoverTask
extends AbstractRewriteTask {
    private static final Logger log = Logging.getLogger(RewriteDiscoverTask.class);
    private static final String LOG_INDENT_INCREMENT = "    ";
    private boolean interactive;

    @Option(description="Whether to enter an interactive shell to explore available recipes.", option="interactive")
    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    @Input
    public boolean isInteractive() {
        return this.interactive;
    }

    @Inject
    public RewriteDiscoverTask() {
        this.setGroup("rewrite");
        this.setDescription("Lists all available recipes and their visitors");
    }

    @TaskAction
    public void run() {
        Collection<RecipeDescriptor> availableRecipeDescriptors = this.getProjectParser().listRecipeDescriptors();
        if (this.interactive) {
            log.quiet("Entering interactive mode, Ctrl-C to exit...");
            UserInputHandler prompter = (UserInputHandler)this.getServices().get(UserInputHandler.class);
            RecipeDescriptorTreePrompter treePrompter = new RecipeDescriptorTreePrompter(prompter);
            RecipeDescriptor rd = treePrompter.execute(availableRecipeDescriptors);
            this.writeRecipeDescriptor(rd);
        } else {
            Set<String> activeRecipes = this.getActiveRecipes();
            SortedSet<String> availableStyles = this.getProjectParser().getAvailableStyles();
            Set<String> activeStyles = this.getActiveStyles();
            log.quiet("Available Recipes:");
            for (RecipeDescriptor recipe : availableRecipeDescriptors) {
                log.quiet(RewriteDiscoverTask.indent(1, recipe.getName()));
            }
            log.quiet(RewriteDiscoverTask.indent(0, ""));
            log.quiet("Available Styles:");
            for (String style : availableStyles) {
                log.quiet(RewriteDiscoverTask.indent(1, style));
            }
            log.quiet(RewriteDiscoverTask.indent(0, ""));
            log.quiet("Active Styles:");
            for (String style : activeStyles) {
                log.quiet(RewriteDiscoverTask.indent(1, style));
            }
            log.quiet(RewriteDiscoverTask.indent(0, ""));
            log.quiet("Active Recipes:");
            for (String activeRecipe : activeRecipes) {
                log.quiet(RewriteDiscoverTask.indent(1, activeRecipe));
            }
            log.quiet(RewriteDiscoverTask.indent(0, ""));
            log.quiet("Found " + availableRecipeDescriptors.size() + " available recipes and " + availableStyles.size() + " available styles.");
            log.quiet("Configured with " + activeRecipes.size() + " active recipes and " + activeStyles.size() + " active styles.");
        }
    }

    private void writeRecipeDescriptor(RecipeDescriptor rd) {
        log.quiet(RewriteDiscoverTask.indent(0, rd.getDisplayName()));
        log.quiet(RewriteDiscoverTask.indent(1, rd.getName()));
        if (rd.getDescription() != null && !rd.getDescription().isEmpty()) {
            log.quiet(RewriteDiscoverTask.indent(1, rd.getDescription()));
        }
        if (!rd.getOptions().isEmpty()) {
            log.quiet(RewriteDiscoverTask.indent(0, "options: "));
            for (OptionDescriptor od : rd.getOptions()) {
                log.quiet(RewriteDiscoverTask.indent(1, od.getName() + ": " + od.getType() + (od.isRequired() ? "!" : "")));
                if (od.getDescription() == null || od.getDescription().isEmpty()) continue;
                log.quiet(RewriteDiscoverTask.indent(2, od.getDescription()));
            }
        }
        log.quiet("");
    }

    private static String indent(int indent, CharSequence content) {
        StringBuilder prefix = RewriteDiscoverTask.repeat(indent);
        return prefix.append(content).toString();
    }

    private static StringBuilder repeat(int repeat) {
        StringBuilder buffer = new StringBuilder(repeat * LOG_INDENT_INCREMENT.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(LOG_INDENT_INCREMENT);
        }
        return buffer;
    }
}

